﻿// $Id$

#ifndef INCLUDE_ccc_xml_CatalogUnit_h
#define INCLUDE_ccc_xml_CatalogUnit_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * カタログ情報の1単位を示します。
 */
class CatalogUnit
{
 public:
  /*!
   * カタログ単位の形式を示します。
   */
  enum UnitType
  {
    UT_COMMENT,		/*!< -- comment -- */
    UT_OVERRIDE,	/*!< OVERRIDE (YES | NO) */
    UT_SGMLDECL,	/*!< SGMLDECL space* "? PATH "? */
    UT_PUBLIC,		/*!< PUBLIC space* " PUBID " space* "? PATH "? */
    UT_SYSTEM,		/*!< SYSTEM space* " SYSID " space* "? PATH "? */
    UT_DTDDECL,		/*!< DTDDECL space* " PUBID " space* "? PATH "? */
  };
 private:
  /*!
   * このカタログ単位の形式
   */
  UnitType ut;
  /*!
   * PUBLIC ID, SYSTEM IDなどのID文字列
   */
  const char* id;
  /*!
   * パス
   */
  const char* path;
 public:
  /*!
   * コンストラクタ
   * \param ut カタログ単位の形式
   * \param id ID文字列、コメントの内容や、OVERRIDEのYES,NOもここに格納します。
   * \param path パス
   */
  CatalogUnit(UnitType ut, const char* id, const char* path = 0);
  /*!
   * デストラクタ
   */
  ~CatalogUnit();
  /*!
   * カタログ単位の形式を得ます。
   * \return カタログ単位の形式
   */
  UnitType getUnitType() { return ut; }
  /*!
   * PUBLIC ID, SYSTEM IDなどのID文字列を得ます。
   * \return ID文字列
   */
  const char* getId() { return id; }
  /*!
   * パスを得ます。
   * \return パス
   */
  const char* getPath() { return path; }
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_CatalogUnit_h */
