﻿// $Id$

#include <ccc/xml/dom.h>

using namespace CCC;

void
CharacterData::setData(const DOMString* arg) CCC_RAISES(DOMException)
{
  node_value.assign(*arg);
}

void
CharacterData::setData(const DOMString& arg) CCC_RAISES(DOMException)
{
  node_value.assign(arg);
}

const DOMString*
CharacterData::getData() const CCC_RAISES(DOMException)
{
  return &node_value;
}

Size
CharacterData::getLength() const
{
  return node_value.getLength();
}

DOMString*
CharacterData::substringData(CCC_IN unsigned long offset, CCC_IN unsigned long count) CCC_RAISES(DOMException)
{
  DOMSubString ss(node_value, offset, count);
  return new DOMString(ss);
}

void
CharacterData::appendData(CCC_IN const DOMString* arg) CCC_RAISES(DOMException)
{
  node_value.add(*arg);
}

void
CharacterData::appendData(CCC_IN const DOMString& arg) CCC_RAISES(DOMException)
{
  node_value.add(arg);
}

void
CharacterData::insertData(CCC_IN unsigned long offset, CCC_IN const DOMString* arg) CCC_RAISES(DOMException)
{
  node_value.insert(offset, *arg);
}

void
CharacterData::insertData(CCC_IN unsigned long offset, CCC_IN const DOMString& arg) CCC_RAISES(DOMException)
{
  node_value.insert(offset, arg);
}

void
CharacterData::deleteData(CCC_IN unsigned long offset, CCC_IN unsigned long count) CCC_RAISES(DOMException)
{
  node_value.remove(offset, count);
}

void
CharacterData::replaceData(CCC_IN unsigned long offset, CCC_IN unsigned long count, CCC_IN const DOMString* arg) CCC_RAISES(DOMException)
{
  node_value.replace(offset, count, *arg);
}

void
CharacterData::replaceData(CCC_IN unsigned long offset, CCC_IN unsigned long count, CCC_IN const DOMString& arg) CCC_RAISES(DOMException)
{
  node_value.replace(offset, count, arg);
}

// CODEX
CharacterData::CharacterData(Document* document_, Node* parent_, unsigned short node_type_)
  : Node(document_, parent_, node_type_)
{
}

CharacterData::~CharacterData()
{
}


