﻿#line 1 "Comment.upp"
#include <ccc/xml/dom.h>

using namespace CCC;

Node*
Comment::cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException)
{
  Comment* new_comment = new Comment(*this);
  return new_comment;
}

// class Comment

static DOMChar comment_node_name[] = { 0x23 /* # */, 0x63 /* c */, 0x6f /* o */, 0x6d /* m */, 0x6d /* m */, 0x65 /* e */, 0x6e /* n */, 0x74 /* t */, 0x00, };

Comment::Comment(Document* document_, Node* parent_, CCC_IN const DOMString* value_)
 : CharacterData(document_, parent_, Node::COMMENT_NODE)
{
  setNodeName(comment_node_name);
  if (value_)
  {
    node_value.assign(*value_);
  }
}

Comment::Comment(Document* document_, Node* parent_, CCC_IN const DOMString& value_)
 : CharacterData(document_, parent_, Node::COMMENT_NODE)
{
  setNodeName(comment_node_name);
  node_value.assign(value_);
}

Comment::Comment(Document* document_, Node* parent_, CCC_IN const DOMChar* value_)
 : CharacterData(document_, parent_, Node::COMMENT_NODE)
{
  setNodeName(comment_node_name);
  if (value_)
  {
    node_value.assign(value_);
  }
}

Comment::Comment(Document* document_, Node* parent_, CCC_IN const DOMChar* value_, Size value_length)
 : CharacterData(document_, parent_, Node::COMMENT_NODE)
{
  setNodeName(comment_node_name);
  if (value_)
  {
    node_value.assign(value_, value_length);
  }
}

Comment::Comment(const Comment& comment)
 : CharacterData(comment.getOwnerDocument(), 0, Node::COMMENT_NODE)
{
  setNodeName(comment_node_name);
  node_value.assign(comment.node_value);
}

Comment::~Comment()
{
}
