﻿// $Id$

#ifndef INCLUDE_ccc_xml_Comment_h
#define INCLUDE_ccc_xml_Comment_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * This interface inherits from CharacterData and represents the content of
 * a comment, i.e., all the characters between the starting '&lt;!--' and
 * ending '--\>'.  Note that this is the definition of a comment in XML, and,
 * in practice, HTML, although some HTML tools may implement the full SGML
 * comment structure.
 */
class Comment
  : public CharacterData
{
 public:
  /*!
   * (CODEX original)<br>
   * ノードを複製します。
   * \param deep deep copyするかどうかのフラグ
   * \return 複製されたノード
   */
  virtual Node* cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException);
  /*!
   * (CODEX original)<br>
   * コンストラクタ
   * \param document Document
   * \param parent 親ノード
   * \param value ノード値
   */
  Comment(Document* document, Node* parent, CCC_IN const DOMString* value);
  Comment(Document* document, Node* parent, CCC_IN const DOMString& value);
  Comment(Document* document, Node* parent, CCC_IN const DOMChar* value);
  /*!
   * (CODEX original)<br>
   * コンストラクタ
   * \param document Document
   * \param parent 親ノード
   * \param value ノード値
   * \param value_length ノード値の長さ
   */
  Comment(Document* document, Node* parent, CCC_IN const DOMChar* value, Size value_length);
  /*!
   * (CODEX original)<br>
   * コピーコンストラクタ
   * \param comment コピー元
   */
  Comment(const Comment& comment);
  /*!
   * (CODEX original)<br>
   * デストラクタ
   */
  ~Comment();
  /*!
   * (CODEX original)<br>
   * XMLをストリームに書き出します。
   * \param xo 出力先
   */
  virtual void writeXml(XMLOutputter* xo) const CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_Comment_h */
