﻿// $Id$

#ifndef INCLUDE_ccc_xml_ConstNodeIterator_h
#define INCLUDE_ccc_xml_ConstNodeIterator_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * (CODEX original)<br>
 * ノードのツリーを順番に辿るためのイタレータクラスです。
 * NodeIteratorクラスとは、結果のNode*にconstが付く点が
 * 異なります。
 */
class ConstNodeIterator
  : public Iterator<const Node>
{
  NodeIterator ni;

 public:
  /*!
   * コンストラクタ
   * \param top イタレートするツリーの頂上ノード
   */
  ConstNodeIterator(const Node* top = 0) : ni((Node*)top) { }
  /*!
   * 頂上ノードを再設定します。
   * \param top イタレートするツリーの頂上ノード
   */
  void reset(const Node* top) { ni.reset((Node*)top); }
  /*!
   * 現在位置のノードへのポインタを返します。
   * \return 指し示しているノードへのポインタ
   */
  const Node* current() const { return ni.current(); }
  /*!
   * 現在位置のノードへのポインタを返し、参照位置を一つ進めます。
   * \return 指し示していたノードへのポインタ
   */
  const Node* next() { return ni.next(); }
  /*!
   * 現在位置のノードへのポインタを返し、参照位置を1つ戻します。
   * \return 指し示していたノードへのポインタ
   */
  const Node* prev() { return ni.prev(); }
  /*!
   * 現在位置を先頭に戻します。
   * \return 先頭のノードへのポインタ
   */
  const Node* rewind() { return ni.rewind(); }
  /*!
   * 現在位置を最後まで進めます。
   * \return 最後のノードへのポインタ
   */
  const Node* unwind() { return ni.unwind(); }
  /*!
   * 現在位置が有効な位置かどうかを調べます。
   * \retval true 有効な位置
   * \retval false 無効な位置
   */
  bool validPositionP() const { return ni.validPositionP(); }
  /*!
   * 先頭から順に数えた現在位置の数字を得ます。
   * \return 現在位置の数字,先頭は1から始まります。
   */
  Size getPosition() const { return ni.getPosition(); }
  /*!
   * イタレーションが終了しているかどうかを調べます。
   * \retval true 終了
   * \retval false まだ終了していない
   */
  bool eofP() const { return !validPositionP(); }
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_ConstNodeIterator_h */
