﻿// $Id$

#ifndef INCLUDE_ccc_xml_DOMException_h
#define INCLUDE_ccc_xml_DOMException_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * \ja
 * DOMの例外用のクラスです。
 * \ja_end
 * \en
 * DOM Exception class.
 * \en_end
 */
class DOMException
{
  /*!
   * 例外コード
   */
  unsigned short code;
 public:
  /*!
   * (CODEX original)<br>
   * コンストラクタ
   * \param code_ 例外コード
   */
  DOMException(unsigned short code_) : code(code_) { }
  /*!
   * 例外コードを得ます。
   * \return 例外コード
   */
  unsigned short getCode() const { return code; }
};

/*
 * \ja
 * 例外コード
 * \ja_end
 * \en
 * Exception Code
 * \en_end
 */
//! If index or size is negative, or greater than the allowed value
const unsigned short INDEX_SIZE_ERR		= 1;
//! If the specified range of text does not fit into a DOMString
const unsigned short DOMSTRING_SIZE_ERR		= 2;
//! If any node is inserted somewhere it doesn't belong
const unsigned short HIERARCHY_REQUEST_ERR	= 3;
//! If a node is used in a different document than the one that created it (that doesn't support it)
const unsigned short WRONG_DOCUMENT_ERR		= 4;
//! If an invalid or illegal character is specified, such as in a name.
//! See production 2 in the XML specification for the definition of a legal
//! character, and production 5 for the definition of a legal name character.
const unsigned short INVALID_CHARACTER_ERR	= 5;
//! If data is specified for a node which does not support data
const unsigned short NO_DATA_ALLOWED_ERR	= 6;
//! If an attempt is made to modify an object where modifications are not allowed
const unsigned short NO_MODIFICATION_ALLOWED_ERR= 7;
//! If an attempt is made to reference a node in a context where it does not exist
const unsigned short NOT_FOUND_ERR		= 8;
//! If the implementation does not support the requested type of object or operation.
const unsigned short NOT_SUPPORTED_ERR		= 9;
//! If an attempt is made to add an attribute that is already in use elsewhere
const unsigned short INUSE_ATTRIBUTE_ERR	= 10;
//! (Introduced in DOM Level 2)<br>
//! If an attempt is made to use an object that is not, or is no longer,
//! usable.
const unsigned short INVALID_STATE_ERR		= 11;
//! (Introduced in DOM Level 2)<br>
//! If an invalid or illegal string is specified.
const unsigned short SYNTAX_ERR			= 12;
//! (Introduced in DOM Level 2)<br>
//! If an attempt is made to modify the type of the underlying object.
const unsigned short INVALID_MODIFICATION_ERR	= 13;
//! (Introduced in DOM Level 2)<br>
//! If an attempt is made to create or change an object in a way
//! which is incorrect with regard to namespaces.
const unsigned short NAMESPACE_ERR		= 14;
//! (Introduced in DOM Level 2)<br>
//! If a parameter or an operation is not supported by the underlying object.
const unsigned short INVALID_ACCESS_ERR		= 15;
// NOTE: Following exception codes are not standard. (CODEX original)
// obsolete (CODEX original)
//const unsigned short READ_XML_STREAM_ERR	= 1001;
// obsolete  (CODEX original)
//const unsigned short READ_XML_PARSE_ERR	= 1002;
/*!
 * (CODEX original)<br>
 * XMLをストリームに出力中にエラーが発生したことを示します。
 */
const unsigned short WRITE_XML_STREAM_ERR	= 1003;

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_DOMException_h */
