﻿// $Id$

#ifndef INCLUDE_ccc_xml_DOMImplementation_h
#define INCLUDE_ccc_xml_DOMImplementation_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * The DOMImplementation interface provides a number of methods for performing
 * operations that are independent of any particular instance of the document
 * object model.
 */
class DOMImplementation
{
 public:
  /*!
   * (CODEX original)<br>
   * コンストラクタ
   */
  DOMImplementation();
  /*!
   * (CODEX original)<br>
   * デストラクタ
   */
  virtual ~DOMImplementation();
  /*!
   * Test if the DOM implementation implements a specific feature.
   *
   * \param feature
   *	The name of the feature to test (case-insensitive). The values used by
   *	DOM features are defined throughout the DOM Level 2 specifications and
   *	listed in the Conformance section.  The name must be an XML name.
   *	To avoid possible conflicts, as a convention, names referring to
   *	features defined outside the DOM specification should be made unique by
   *	reversing the name of the Internet domain name of the person (or the
   *	organization that the person belongs to) who defines the, component by
   *	component, and using this as a prefix.  For instance, the W3C SVG
   *	Working Group defines the feature "org.w3c.dom.svg".
   * \param version
   *	This is the version number of the feature to test. In Level 2, the
   *	string can be either "2.0" or "1.0". If the version is not specified,
   *	supporting any version of the feature causes the method to return true.
   *
   * \return True if the feature is implemented in the specified version,
   *	false otherwise.
   */
  virtual bool hasFeature(CCC_IN DOMString& feature,
			  CCC_IN DOMString& version);
  /*!
   * (CODEX original)<br>
   * Documentを生成します。
   * \return Document
   */
  Document* createDocument();
  /*!
   * Introduced in DOM Level 2:<br>
   * Creates an XML Document object of the specified type with its document
   * element. HTML-only DOM implementations do not need to implement this
   * method.
   *
   * \param namespace_uri The namespace URI of the document element to create.
   * \param qualified_name The qualified name of the document element to be
   *	created.
   * \param doctype The type of document to be created or null.
   *	When doctype is not null, its Node.ownerDocument attribute is set to
   *	the document being created.
   *
   * \return A new Document object.
   *
   * \exception INVALID_CHARACTER_ERR
   *	Raised if the specified qualified name contains an illegal character.
   * \exception NAMESPACE_ERR
   *	Raised if the qualified_name is malformed, if the qualified_name has a
   *	prefix and the namespace_uri is null, or if the qualified_name has a
   *	prefix that is "xml" and the namespaceURI is different from
   *	"http://www.w3.org/XML/1998/namespace" [Namespaces].
   * \exception WRONG_DOCUMENT_ERR
   *	Raised if doctype has already been used with a different document or
   *	was created from a different implementation.
   *
   * 未実装です。
   */
  Document* createDocument(CCC_IN const DOMString* namespace_uri,
  			   CCC_IN const DOMString* qualified_name,
  			   CCC_IN DocumentType* doctype) CCC_RAISES(DOMException);
  /*!
   * Introduced in DOM Level 2:<br>
   * Creates an empty DocumentType node. Entity declarations and notations are
   * not made available. Entity reference expansions and default attribute
   * additions do not occur. It is expected that a future version of the DOM
   * will provide a way for populating a DocumentType.<br>
   * HTML-only DOM implementations do not need to implement this method.
   *
   * \param qualified_name
   *	The qualified name of the document type to be created.
   * \param public_id The external subset public identifier.
   * \param system_id The external subset system identifier.
   *
   * \return A new DocumentType node with Node.ownerDocument set to null.
   *
   * \exception INVALID_CHARACTER_ERR
   *	Raised if the specified qualified name contains an illegal character.
   * \exception NAMESPACE_ERR Raised if the qualifiedName is malformed.
   *
   * 未実装です。
   */
  DocumentType* createDocumentType(CCC_IN const DOMString* qualified_name,
				   CCC_IN const DOMString* public_id,
				   CCC_IN const DOMString* system_id) CCC_RAISES(DOMException);
  /*!
   * for class initialization
   * \param p true:initialize, false:uninitialize
   */
  static void initailze(bool p);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_DOMImplementation_h */
