﻿// $Id$

#ifndef INCLUDE_ccc_xml_DereferSgmlEntity_h
#define INCLUDE_ccc_xml_DereferSgmlEntity_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>
#include <ccc/base/TString.h>
#include <ccc/xml/DOMString.h>

CCC_NAMESPACE_START(CCC);

/*!
 * 実体参照
 */
struct EntityRef
{
  /*!
   * 実体参照名(開始の&と終了の;は記述しません)
   */
  CCC::UInt16* ref;
  /*!
   * 実体参照先文字列
   */
  CCC::UInt16* entity;
};

/*!
 * SGMLの実体参照表記を参照解決します。
 */
class DereferSgmlEntity
{
 public:
  /*!
   * SGMLの実体参照表記を参照解決します。
   * 追加の実体参照テーブルを指定しない場合には、amp, lt, gt, apos, quotと
   * 数値による文字参照(Numeric character references)のみが参照解決されます。
   * \param from 変換元
   * \param to 変換先
   * \param additional_refs 追加の実体参照テーブル(EntityRefの配列、最後の要素は{0,0}にします。)
   */
  static void convert(const CCC::DString* from, CCC::DString* to, EntityRef* additional_refs = 0);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_DereferSgmlEntity_h */
