﻿#line 1 "Document.upp"
#include <ccc/xml/dom.h>
#include <ccc/base/cstring.h>

using namespace CCC;

DocumentType*
Document::getDoctype() const
{
  return document_type;
}

Element*
Document::getDocumentElement() const
{
  // find first Element node from children
  Node* node = getChildNodes()->head();
  while (node)
  {
    if (node->getNodeType() == Node::ELEMENT_NODE)
    {
      break;
    }
    node = node->getNext();
  }
  return (Element*)node;
}

Element*
Document::createElement(CCC_IN const DOMString* tag_name) CCC_RAISES(DOMException)
{
  return new Element(this, 0, tag_name);
}

Element*
Document::createElement(CCC_IN const DOMString& tag_name) CCC_RAISES(DOMException)
{
  return new Element(this, 0, &tag_name);
}

Element*
Document::createElement(CCC_IN const DOMChar* tag_name) CCC_RAISES(DOMException)
{
  DOMString tmp(tag_name);
  return new Element(this, 0, &tmp);
}

Element*
Document::createElementNS(CCC_IN const DOMString* namespace_uri_, CCC_IN const DOMString* qualified_name_) CCC_RAISES(DOMException)
{
  return new Element(this, 0, namespace_uri_, qualified_name_);
}

Element*
Document::createElementNS(CCC_IN const DOMString& namespace_uri_, CCC_IN const DOMString& qualified_name_) CCC_RAISES(DOMException)
{
  return new Element(this, 0, &namespace_uri_, &qualified_name_);
}

Element*
Document::createElementNS(CCC_IN const DOMChar* namespace_uri_, CCC_IN const DOMChar* qualified_name_) CCC_RAISES(DOMException)
{
  DOMString s_namespace_uri(namespace_uri_);
  DOMString s_qualified_name(qualified_name_);
  return new Element(this, 0, &s_namespace_uri, &s_qualified_name);
}

DocumentFragment*
Document::createDocumentFragment()
{
  return new DocumentFragment();
}

Text*
Document::createTextNode(CCC_IN const DOMString* data)
{
  return new Text(this, 0, data);
}

Text*
Document::createTextNode(CCC_IN const DOMString& data)
{
  return new Text(this, 0, &data);
}

Comment*
Document::createComment(CCC_IN const DOMString* data)
{
  return new Comment(this, 0, data);
}

Comment*
Document::createComment(CCC_IN const DOMString& data)
{
  return new Comment(this, 0, &data);
}

CDATASection*
Document::createCDATASection(CCC_IN const DOMString* data) CCC_RAISES(DOMException)
{
  return new CDATASection(this, 0, data);
}

CDATASection*
Document::createCDATASection(CCC_IN const DOMString& data) CCC_RAISES(DOMException)
{
  return new CDATASection(this, 0, &data);
}

ProcessingInstruction*
Document::createProcessingInstruction(CCC_IN const DOMString* target, CCC_IN const DOMString* data) CCC_RAISES(DOMException)
{
  return new ProcessingInstruction(this, 0, target, data);
}

ProcessingInstruction*
Document::createProcessingInstruction(CCC_IN const DOMString& target, CCC_IN const DOMString& data) CCC_RAISES(DOMException)
{
  return new ProcessingInstruction(this, 0, &target, &data);
}

Attr*
Document::createAttribute(CCC_IN const DOMString* name) CCC_RAISES(DOMException)
{
  return new Attr(this, name, 0);
}

Attr*
Document::createAttribute(CCC_IN const DOMString& name) CCC_RAISES(DOMException)
{
  return new Attr(this, &name, 0);
}

Attr*
Document::createAttribute(CCC_IN const DOMChar* name) CCC_RAISES(DOMException)
{
  DOMString s(name);
  return new Attr(this, &s, 0);
}

Attr*
Document::createAttributeNS(CCC_IN const DOMString* namespace_uri_, CCC_IN const DOMString* qualified_name_) CCC_RAISES(DOMException)
{
  return new Attr(this, namespace_uri_, qualified_name_, 0);
}

Attr*
Document::createAttributeNS(CCC_IN const DOMString& namespace_uri_, CCC_IN const DOMString& qualified_name_) CCC_RAISES(DOMException)
{
  return new Attr(this, &namespace_uri_, &qualified_name_, 0);
}

Attr*
Document::createAttributeNS(CCC_IN const DOMChar* namespace_uri_, CCC_IN const DOMChar* qualified_name_) CCC_RAISES(DOMException)
{
  DOMString s_namespace_uri(namespace_uri_);
  DOMString s_qualified_name(qualified_name_);
  return new Attr(this, &s_namespace_uri, &s_qualified_name, 0);
}

EntityReference*
Document::createEntityReference(CCC_IN const DOMString* name) CCC_RAISES(DOMException)
{
  return new EntityReference(this, 0, name);
}

EntityReference*
Document::createEntityReference(CCC_IN const DOMString& name) CCC_RAISES(DOMException)
{
  return new EntityReference(this, 0, &name);
}

NodeList*
Document::getElementsByTagName(CCC_IN const DOMString* tagname) const
{
  const Element* root_element = getDocumentElement();
  return root_element->getElementsByTagName(tagname);
}

NodeList*
Document::getElementsByTagName(CCC_IN const DOMString& tagname) const
{
  const Element* root_element = getDocumentElement();
  return root_element->getElementsByTagName(&tagname);
}

NodeList*
Document::getElementsByTagNameNS(CCC_IN const DOMString* namespace_uri_, CCC_IN const DOMString* local_name_)
{
  const Element* root_element = getDocumentElement();
  return root_element->getElementsByTagNameNS(namespace_uri_, local_name_);
}

NodeList*
Document::getElementsByTagNameNS(CCC_IN const DOMString& namespace_uri_, CCC_IN const DOMString& local_name_)
{
  const Element* root_element = getDocumentElement();
  return root_element->getElementsByTagNameNS(&namespace_uri_, &local_name_);
}

// CODEX original
static DOMChar document_node_name[] = { 0x23 /* # */, 0x64 /* d */, 0x6f /* o */, 0x63 /* c */, 0x75 /* u */, 0x6d /* m */, 0x65 /* e */, 0x6e /* n */, 0x74 /* t */, 0x00, };

Document::Document(DOMImplementation* dom_implementation_)
 : Node(Node::DOCUMENT_NODE)
{
  setNodeName(document_node_name);
  dom_implementation = dom_implementation_;
  document_type = new DocumentType(this);
  xmldecl = new XMLDecl(this);
  appendChild(xmldecl);
}

Document::Document(const Document& document)
 : Node(Node::DOCUMENT_NODE)
{
  setNodeName(document_node_name);
  dom_implementation = document.dom_implementation;
  document_type = new DocumentType(this);
  xmldecl = new XMLDecl(this);
  appendChild(xmldecl);
  // TODO: copy referece document information into this document.
}

Document::~Document()
{
  // delete document_type in case of document_type isn't registerd in the children.
  Node* node = getChildNodes()->head();
  while (node)
  {
    if (node->getNodeType() == Node::DOCUMENT_TYPE_NODE)
    {
      break;
    }
    node = node->getNext();
  }
  if (!node)
  {
    delete document_type;
  }
  // no need to delete xmldecl
}

const NamedNodeMap*
Document::getXMLDeclNodeMap() const
{
  return xmldecl->getAttributes();
}

#if 0
// MiniXMLParser
Document*
Document::readXML(InStream* is) CCC_RAISES(DOMException)
{
  Document* ret = 0;
  try
  {
    MiniXMLParser mxp;
    ret = mxp.read(is);
  }
  catch (StreamException)
  {
    throw DOMException(READ_XML_STREAM_ERR);
  }
  catch (DOMException ex)
  {
    throw ex;
  }
  return ret;
}
#endif

DOMString*
Document::getAtom(const DOMString* node_name)
{
  DOMString* atom = atom_table.search(node_name);
  if (!atom)
  {
    atom = new DOMString(node_name);
    atom_table.add(atom);
  }
  return atom;
}

DOMString*
Document::getAtom(const DOMString& node_name)
{
  DOMString* atom = atom_table.search(&node_name);
  if (!atom)
  {
    atom = new DOMString(node_name);
    atom_table.add(atom);
  }
  return atom;
}

DOMString*
Document::getAtom(const DOMChar* node_name)
{
  DOMString* atom = atom_table.searchWithDOMCharString(node_name);
  if (!atom)
  {
    atom = new DOMString(node_name);
    atom_table.add(atom);
  }
  return atom;
}

DOMString*
Document::getNamespaceUriAtom(const DOMString* namespace_uri)
{
  DOMString* atom = namespace_uri_atom_table.search(namespace_uri);
  if (!atom)
  {
    atom = new DOMString(namespace_uri);
    namespace_uri_atom_table.add(atom);
  }
  return atom;
}

DOMString*
Document::getNamespaceUriAtom(const DOMString& namespace_uri)
{
  DOMString* atom = namespace_uri_atom_table.search(&namespace_uri);
  if (!atom)
  {
    atom = new DOMString(namespace_uri);
    namespace_uri_atom_table.add(atom);
  }
  return atom;
}

DOMString*
Document::getNamespaceUriAtom(const DOMChar* namespace_uri)
{
  DOMString* atom = namespace_uri_atom_table.searchWithDOMCharString(namespace_uri);
  if (!atom)
  {
    atom = new DOMString(namespace_uri);
    namespace_uri_atom_table.add(atom);
  }
  return atom;
}

DOMString*
Document::findNamespaceUriAtom(const DOMString* namespace_uri)
{
  DOMString* atom = namespace_uri_atom_table.search(namespace_uri);
  return atom;
}

DOMString*
Document::getPrefixAtom(const DOMString* prefix)
{
  DOMString* atom = prefix_atom_table.search(prefix);
  if (!atom)
  {
    atom = new DOMString(prefix);
    prefix_atom_table.add(atom);
  }
  return atom;
}

DOMString*
Document::getPrefixAtom(const DOMString& prefix)
{
  DOMString* atom = prefix_atom_table.search(&prefix);
  if (!atom)
  {
    atom = new DOMString(prefix);
    prefix_atom_table.add(atom);
  }
  return atom;
}

DOMString*
Document::getPrefixAtom(const DOMChar* prefix)
{
  DOMString* atom = prefix_atom_table.searchWithDOMCharString(prefix);
  if (!atom)
  {
    atom = new DOMString(prefix);
    prefix_atom_table.add(atom);
  }
  return atom;
}

DOMString*
Document::getPrefixAtomFromQualifiedName(CCC_IN const DOMString* qualified_name)
{
  DOMChar* start = qualified_name->getStartPtr();
  DOMChar* p = start;
  Size len = qualified_name->getLength();
  while (len > 0)
  {
    if (*p == (DOMChar)':')
    {
      break;
    }
    len--;
    p++;
  }
  if (len > 0)
  {
    DOMString s(start, p - start);
    return getPrefixAtom(&s);
  }
  else
  {
    DOMString empty;
    return getPrefixAtom(empty);
  }
}

DOMString*
Document::getPrefixAtomFromQualifiedName(CCC_IN const DOMChar* qualified_name)
{
  const DOMChar* start = qualified_name;
  const DOMChar* p = start;
  Size len = strLen(qualified_name);
  while (len > 0)
  {
    if (*p == (DOMChar)':')
    {
      break;
    }
    len--;
    p++;
  }
  if (len > 0)
  {
    DOMString s(start, p - start);
    return getPrefixAtom(&s);
  }
  else
  {
    DOMString empty("");
    return getPrefixAtom(empty);
  }
}

DOMString*
Document::getLocalNameFromQualifiedName(CCC_IN const DOMString* qualified_name)
{
  DOMChar* start = qualified_name->getStartPtr();
  DOMChar* p = start;
  Size len = qualified_name->getLength();
  while (len > 0)
  {
    if (*p++ == (DOMChar)':')
    {
      break;
    }
    len--;
  }
  if (len > 0)
  {
    len = qualified_name->getLength();
    DOMString s(p, len - (p - start));
    return getAtom(&s);
  }
  else
  {
    return getAtom(qualified_name);
  }
}

DOMString*
Document::getLocalNameFromQualifiedName(CCC_IN const DOMChar* qualified_name)
{
  const DOMChar* start = qualified_name;
  const DOMChar* p = start;
  Size len = strLen(qualified_name);
  while (len > 0)
  {
    if (*p++ == (DOMChar)':')
    {
      break;
    }
    len--;
  }
  if (len > 0)
  {
    len = strLen(qualified_name);
    DOMString s(p, len - (p - start));
    return getAtom(&s);
  }
  else
  {
    return getAtom(qualified_name);
  }
}

Node*
Document::cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException)
{
  Document* document = new Document(*this);
  if (deep)
  {
    deepCopy(document);
  }
  return document;
}

Node*
Document::importNode(CCC_IN Node* imported_node, bool deep) CCC_RAISES(DOMException)
{
  /* imported_nodeは別ドキュメントのノードの可能性を考慮します。 */
  Node* new_node = 0;
  const DOMString* node_name = imported_node->getNodeName();
  const DOMString* namespace_uri = imported_node->getNamespaceURI();
  switch (imported_node->getNodeType())
  {
   case Node::ELEMENT_NODE:
    if (namespace_uri)
    {
      new_node = createElementNS(namespace_uri, node_name);
    }
    else
    {
      new_node = createElement(node_name);
    }
    break;
   case Node::ATTRIBUTE_NODE:
    if (namespace_uri)
    {
      new_node = createAttributeNS(namespace_uri, node_name);
    }
    else
    {
      new_node = createAttribute(node_name);
    }
    break;
   case Node::TEXT_NODE:
    new_node = createTextNode(((Text*)imported_node)->getData());
    break;
   case Node::CDATA_SECTION_NODE:
    new_node = createCDATASection(((CDATASection*)imported_node)->getData());
    break;
   case Node::COMMENT_NODE:
    new_node = createComment(((Comment*)imported_node)->getData());
    break;
   case Node::ENTITY_REFERENCE_NODE:
   case Node::ENTITY_NODE:
   case Node::PROCESSING_INSTRUCTION_NODE:
   case Node::DOCUMENT_NODE:
   case Node::DOCUMENT_TYPE_NODE:
   case Node::DOCUMENT_FRAGMENT_NODE:
   case Node::NOTATION_NODE:
    // (CODEX original)
   case Node::XMLDECL_NODE:
   case Node::DTD_ELEMENT_NODE:
   case Node::DTD_ATTLIST_NODE:
   case Node::DTD_PENTITY_NODE:
    // TODO:
    return 0;
    break;
  }
  new_node->setNodeValue(imported_node->getNodeValue());
  if (deep)
  {
    // copy attributes
    NamedNodeMap* new_atts = new_node->getAttributes();
    Iterator<Node>* it = imported_node->getAttributes()->createIterator();
    Node* node;
    while ((node = it->next()))
    {
      assert(node->getNodeType() == Node::ATTRIBUTE_NODE);
      Attr* new_attr = (Attr*)importNode(node, false);
      assert(new_attr->getNodeType() == Node::ATTRIBUTE_NODE);
      new_atts->setNamedItem(new_attr);
    }
    delete it;
    
    // copy descendants
    node = imported_node->getChildNodes()->head();
    while (node)
    {
      Node* new_child = importNode(node, true);
      new_node->appendChild(new_child);
      node = node->getNext();
    }
  }
  return new_node;
}

Element*
Document::getElementById(CCC_IN DOMString* elementId)
{
  Element* root_element = getDocumentElement();
  return root_element->getElementById(elementId);
}

Element*
Document::getElementById(CCC_IN DOMString& elementId)
{
  Element* root_element = getDocumentElement();
  return root_element->getElementById(&elementId);
}
