﻿// $Id$

#include <ccc/xml/dom.h>

using namespace CCC;

DocumentType::DocumentType(Document* document)
  : External(document, 0, Node::DOCUMENT_TYPE_NODE),
    elements(this),
    entities(this),
    pentities(this),
    notations(this)
{
}

DocumentType::DocumentType(const DocumentType& ref)
  : External((External&)ref),
    elements(this),
    entities(this),
    pentities(this),
    notations(this)
{
  setNodeName(ref.getNodeName());
}

DocumentType::~DocumentType()
{
}

Node*
DocumentType::cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException)
{
  DocumentType* new_document_type = new DocumentType(*this);
  if (deep)
  {
    // TODO: Copy contents
  }
  return new_document_type;
}

void
DocumentType::addDtdElement(DtdElement* element, bool internal_p)
{
  elements.setNamedItem(element);
  if (internal_p)
  {
    internals.add(element);
  }
}

void
DocumentType::addDtdEntity(Entity* entity, bool internal_p)
{
  entities.setNamedItem(entity);
  if (internal_p)
  {
    internals.add(entity);
  }
}

void
DocumentType::addDtdPEntity(DtdPEntity* pentity, bool internal_p)
{
  pentities.setNamedItem(pentity);
  if (internal_p)
  {
    internals.add(pentity);
  }
}

void
DocumentType::addDtdNotation(Notation* notation, bool internal_p)
{
  notations.setNamedItem(notation);
  if (internal_p)
  {
    internals.add(notation);
  }
}

void
DocumentType::addDtdInternals(Node* node)
{
  internals.add(node);
}

DtdElement*
DocumentType::findDtdElement(const DOMString* name)
{
  Document* document = getOwnerDocument();
  DOMString* atom = document->getAtom(name);
  Node* node = elements.getNamedItem(atom);
  if (node)
  {
    assert(node->getNodeType() == DTD_ELEMENT_NODE);
  }
  return (DtdElement*)node;
}
