﻿// $Id$

#ifndef INCLUDE_ccc_xml_DocumentType_h
#define INCLUDE_ccc_xml_DocumentType_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * \brief This class has document type information.
 *
 * Each Document has a doctype attribute whose value is either null or a
 * DocumentType object. The DocumentType interface in the DOM Core provides
 * an interface to the list of entities that are defined for the document,
 * and little else because the effect of namespaces and the various XML
 * schema efforts on DTD representation are not clearly understood as of
 * this writing.
 *
 * The DOM Level 2 doesn't support editing DocumentType nodes.
 */
class DocumentType
  : public External
{
  /*!
   * (CODEX original)
   * declarations of ELEMENT.
   * list DtdElement objects.
   */
  NamedNodeMap elements;
  /*!
   * declarations of general ENTITY<br>
   * list of Entity objects.
   *
   * A NamedNodeMap containing the general entities, both external and
   * internal, declared in the DTD. Parameter entities are not
   * contained. Duplicates are discarded. For example in:
   *
   * <code>
   * \<!DOCTYPE ex SYSTEM "ex.dtd" [
   *   \<!ENTITY foo "foo"\>
   *   \<!ENTITY bar "bar"\>
   *   \<!ENTITY bar "bar2"\>
   *   \<!ENTITY % baz "baz"\>
   * ]\>
   * \<ex/\>
   * </code>
   *
   * the interface provides access to foo and the first declaration of
   * bar but not the second declaration of bar or baz. Every node in
   * this map also implements the Entity interface.
   * The DOM Level 2 does not support editing entities, therefore
   * entities cannot be altered in any way.
   */
  NamedNodeMap entities;
  /*!
   * (CODEX original)
   * declarations of parameter ENTITY.<br>
   * list of PEntity objects.
   */
  NamedNodeMap pentities;
  /*!
   * \brief declarations of NOTATION
   * list of Notation objects.
   *
   * A NamedNodeMap containing the notations declared in the DTD.
   * Duplicates are discarded. Every node in this map also implements
   * the Notation interface.
   * The DOM Level 2 does not support editing notations, therefore
   * notations cannot be altered in any way.
   */
  NamedNodeMap notations;
  /*!
   * (CODEX original)<br>
   * Apperance sequence list of internal subset definitions.
   */
  LinkList<Node> internals;
 public:
  /*!
   * The name of DTD; i.e., the name immediately following the DOCTYPE keyword.
   */
  const DOMString* getName() const { return node_name; }
  /*!
   * (CODEX original)<br>
   * エンティティの一覧を返します。
   * \return エンティティの一覧
   */
  const NamedNodeMap* getEntities() const { return &entities; }
  /*!
   * (CODEX original)<br>
   * Notationノードの一覧を返します。
   * \return Notationノードの一覧
   */
  const NamedNodeMap* getNotations() const { return &notations; }
  /*!
   * (CODEX original)<br>
   * ノードを複製します。
   * \param deep deep copyするかどうかのフラグ
   * \return 複製されたノード
   */
  virtual Node* cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException);
  /*!
   * Introduced in DOM Level 2:<br>
   * The public identifier of the external subset.
   */
  //const DOMString* getPublicId() const { return External::getPublidId(); }
  /*!
   * Introduced in DOM Level 2:<br>
   * The system identifier of the external subset.
   */
  //const DOMString* getSystemId() const { return External::getSystemId(); }
  /*!
   * Introduced in DOM Level 2:<br>
   * The internal subset as a string.
   *
   * Note: The actual content returned depends on how much information
   * is available to the implementation. This may vary depending on
   * various parameters, including the XML processor used to build the
   * document.
   *
   * CODEX: Always return 0.
   */
  const DOMString* getInternalSubset() const { return 0; }
  /*!
   * (CODEX original)<br>
   * コンストラクタ
   * \param document Document
   */
  DocumentType(Document* document);
  /*!
   * (CODEX original)<br>
   * コピーコンストラクタ
   * \param documenttype コピー元
   */
  DocumentType(const DocumentType& documenttype);
  /*!
   * (CODEX original)<br>
   * デストラクタ
   */
  ~DocumentType();
  /*!
   * (CODEX original)<br>
   * XMLをストリームに書き出します。
   * \param xo 出力先
   */
  virtual void writeXml(XMLOutputter* xo) const CCC_RAISES(IOException);
  // Interfaces for XMLParser
 private:
  friend class XMLParser;
  /*!
   * (CODEX original)<br>
   * DTDエレメントを追加します。
   * \param element DTDエレメント
   * \param internal_p 内部フラグ
   */
  void addDtdElement(DtdElement* element, bool internal_p);
  /*!
   * (CODEX original)<br>
   * エンティティを追加します。
   * \param entitiy エンティティ
   * \param internal_p 内部フラグ
   */
  void addDtdEntity(Entity* entity, bool internal_p);
  /*!
   * (CODEX original)<br>
   * パラメータエンティティを追加します。
   * \param pentity パラメータエンティティ
   * \param internal_p 内部フラグ
   */
  void addDtdPEntity(DtdPEntity* pentity, bool internal_p);
  /*!
   * (CODEX original)<br>
   * \param notation Notation
   * \param internal_p 内部フラグ
   */
  void addDtdNotation(Notation* notation, bool internal_p);
  /*!
   * (CODEX original)<br>
   * \a Comment or \a ProcessingInstruction object will be stored
   * in DocumentType children by the parser.
   * \a DtdAttlist will be stored as \a DtdElement chlidren.
   * This method store the argument node into the internals list.
   * \param node Node
   */
  void addDtdInternals(Node* node);
  /*!
   * (CODEX original)<br>
   * DTDエレメントを検索します。
   * \param name 名前
   */
  DtdElement* findDtdElement(const DOMString* name);
  /*!
   * (CODEX original)<br>
   * パラメータエンティティの一覧を取り出します。
   * \return パラメータエンティティの一覧
   */
  const NamedNodeMap* getPEntities() const { return &pentities; }
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_DocumentType_h */
