﻿// $Id$
// class DtdAttlist

#include <ccc/xml/dom.h>

using namespace CCC;

DtdAttlist::DtdAttlist(Document* document, const DOMString* name, bool first_attdef_p)
  : Node(document, 0, DTD_ATTLIST_NODE)
{
  DtdAttlist::first_attdef_p = first_attdef_p;
  last_attdef_p = false;
  setNodeName(name);
  att_type = ATTTYPE_UNKNOWN;
  default_type = DEFAULTTYPE_UNKNOWN;
  default_value = 0;
  candidates = 0;
}

DtdAttlist::DtdAttlist(Document* document, const DOMString& name, bool first_attdef_p)
  : Node(document, 0, DTD_ATTLIST_NODE)
{
  DtdAttlist::first_attdef_p = first_attdef_p;
  last_attdef_p = false;
  setNodeName(name);
  att_type = ATTTYPE_UNKNOWN;
  default_type = DEFAULTTYPE_UNKNOWN;
  default_value = 0;
  candidates = 0;
}

DtdAttlist::~DtdAttlist()
{
  delete default_value;
  if (candidates)
  {
    DOMString* s = 0;
    while ((s = candidates->pop()))
    {
      delete s;
    }
    delete candidates;
  }
}

Node*
DtdAttlist::cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException)
{
  // TODO
  return 0;
}

void
DtdAttlist::setDefaultValue(const DOMString* s)
{
  assert(!!default_value);
  default_value = new DOMString(*s);
}

void
DtdAttlist::setDefaultValue(const DOMString& s)
{
  assert(!!default_value);
  default_value = new DOMString(s);
}

void
DtdAttlist::addCandidate(const DOMString* candidate)
{
  if (!candidates)
  {
    candidates = new LinkList<DOMString>();
  }
  DOMString* s = new DOMString(*candidate);
  candidates->add(s);
}

void
DtdAttlist::addCandidate(const DOMString& candidate)
{
  if (!candidates)
  {
    candidates = new LinkList<DOMString>();
  }
  DOMString* s = new DOMString(candidate);
  candidates->add(s);
}
