﻿// $Id$

#ifndef INCLUDE_ccc_xml_DtdAttlist_h
#define INCLUDE_ccc_xml_DtdAttlist_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

//! (CODEX original)
//! This class has DTD ATTLIST information.
class DtdAttlist
  : public Node
{
 public:
  /*!
   * attlist type
   */
  enum AttType
  {
    ATTTYPE_UNKNOWN = 0,	//!< initial status
    ATTTYPE_CDATA,		//!< CDATA
    ATTTYPE_ID,			//!< ID
    ATTTYPE_IDREF,		//!< IDREF
    ATTTYPE_IDREFS,		//!< IDREFS
    ATTTYPE_NMTOKEN,		//!< NMTOKEN
    ATTTYPE_NMTOKENS,		//!< NMTOKENS
    ATTTYPE_ENTITY,		//!< ENTITY
    ATTTYPE_ENTITIES,		//!< ENTITYS
    ATTTYPE_NOTATION,		//!< NOTATION
    ATTTYPE_CANDIDATES,		//!< multiple candidates
  };
  /*!
   * default type
   */
  enum DefaultType
  {
    DEFAULTTYPE_UNKNOWN = 0,	//!< initial status
    DEFAULTTYPE_REQUIRED,	//!< REQUIRED
    DEFAULTTYPE_IMPLIED,	//!< IMPLIED
    DEFAULTTYPE_FIXED,		//!< FIXED
    DEFAULTTYPE_DEFAULT,	//!< default value
  };
 private:
  /*!
   * attlist type
   */
  AttType att_type;
  /*!
   * default type
   */
  DefaultType default_type;
  /*!
   * default value
   */
  DOMString* default_value;
  /*!
   * candidates of \a NotationType or \a Enumeration values
   */
  LinkList<DOMString>* candidates;
  /*!
   * first AttDef
   */
  bool first_attdef_p;
  /*!
   * last AttDef
   */
  bool last_attdef_p;
 public:
  /*! コンストラクタ */
  DtdAttlist(Document* document, const DOMString* name, bool first_attdef_p);
  DtdAttlist(Document* document, const DOMString& name, bool first_attdef_p);
  /*! デストラクタ */
  ~DtdAttlist();
  /*!
   * (CODEX original)<br>
   * ノードを複製します。
   * \param deep deep copyするかどうかのフラグ
   * \return 複製されたノード
   */
  Node* cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException);
  AttType getAttType() const { return att_type; }
  DefaultType getDefaultType() const { return default_type; }
  const DOMString* getDefalutValue() const { return default_value; }
  /*!
   * (CODEX original)<br>
   * XMLをストリームに書き出します。
   * \param xo 出力先
   */
  virtual void writeXml(XMLOutputter* xo) const CCC_RAISES(IOException);
 private:
  friend class XMLParser;
  void setAttType(AttType t) { att_type = t; }
  void setDefaultType(DefaultType t) { default_type = t; }
  void setDefaultValue(const DOMString* s);
  void setDefaultValue(const DOMString& s);
  void addCandidate(const DOMString* candidate);
  void addCandidate(const DOMString& candidate);
  void setLastAddDefP() { last_attdef_p = true; }
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_DtdAttlist_h */
