﻿// $Id$
// class DtdECUnit

#include <ccc/xml/dom.h>

using namespace CCC;

DtdECUnit::DtdECUnit(Document* document, UnitType unit_type)
{
  DtdECUnit::document = document;
  DtdECUnit::unit_type = unit_type;
  name = 0;
  children = 0;
}

DtdECUnit::~DtdECUnit()
{
  if (children)
  {
    DtdECUnit* unit;
    while ((unit = children->pop()))
    {
      delete unit;
    }
    delete children;
  }
}

void
DtdECUnit::setName(const DOMString* name)
{
  DtdECUnit::name = document->getAtom(name);
}

void
DtdECUnit::setName(const DOMString& name)
{
  DtdECUnit::name = document->getAtom(name);
}

void
DtdECUnit::addChildren(DtdECUnit* child)
{
  if (!children)
  {
    children = new LinkList<DtdECUnit>();
  }
  children->add(child);
}

bool
DtdECUnit::hasPcdataChildP()
{
  return ((unit_type == UT_MIXED_ONE) ||
	  (unit_type == UT_MIXED_CHOICE) ||
	  (unit_type == UT_TIP_ANY));
}
