﻿// $Id$

#ifndef INCLUDE_ccc_xml_DtdECUnit_h
#define INCLUDE_ccc_xml_DtdECUnit_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

//! (CODEX original)
//! DTD ELEMENT contents unit.
class DtdECUnit
{
 public:
  //! DTD ELEMENT contents type
  enum UnitType
  {
    UT_UNKNOWN		= 0,		//!< unset status
    UT_TIP_EMPTY 	= 0x0001,	//!< EMPTY
    UT_TIP_ANY		= 0x0002,	//!< ANY
    UT_TIP_PCDATA	= 0x0004,	//!< \#PCDATA
    UT_TIP_NAME		= 0x0008,	//!< Name
    UT_MIXED_ONE	= 0x0010,	//!< '(' S? '\#PCDATA' S? ')'
    UT_MIXED_CHOICE	= 0x0020,	//!< '(' S? '\#PCDATA' ( S? '|' Name )* S? ')*'
    UT_SEQUENCE		= 0x0040,	//!< '(' S? cp ( S? ',' S? cp )* S? ')'
    UT_CHOICE		= 0x0080,	//!< '(' S? cp ( S? '|' S? cp )* S? ')'
    UT_REP_ZERO_OR_ONE	= 0x1000,	//!< '?'
    UT_REP_ONE_OR_MORE	= 0x2000,	//!< '+'
    UT_REP_ZERO_OR_MORE	= 0x4000,	//!< '*'
    // bit mask
    UT_TIP_MASK		= 0x000f,	//!< tip contents bit mask
    UT_REP_MASK		= 0xf000,	//!< repeat description bit mask
  };

 private:
  /*!
   * document
   */
  Document* document;
  /*!
   * unit type
   */
  UnitType unit_type;
  /*!
   * in case of UT_TIP_ELEMENT, name points document atom.
   */
  DOMString* name;
  /*!
   * list of children
   */
  LinkList<DtdECUnit>* children;
 public:
  /*! コンストラクタ */
  DtdECUnit(Document* document, UnitType unit_type = UT_UNKNOWN);
  /*! デストラクタ */
  ~DtdECUnit();
  void setUnitType(UnitType t) { unit_type = t; }
  void orUnitType(UnitType t) { unit_type = (UnitType)(((int)unit_type) | ((int)t)); }
  UnitType getUnitType() const { return unit_type; }
  void setName(const DOMString* name);
  void setName(const DOMString& name);
  const DOMString* getName() const { return name; }
  void addChildren(DtdECUnit* child);
  bool hasPcdataChildP();
  /*!
   * (CODEX original)<br>
   * XMLをストリームに書き出します。
   * \param xo 出力先
   */
  void writeXml(XMLOutputter* xo) const CCC_RAISES(IOException);
 private:
  void writeXmlChild(XMLOutputter* xo, DOMChar* sep) const;
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_DtdECUnit_h */
