﻿// $Id$

#ifndef INCLUDE_ccc_xml_DtdElement_h
#define INCLUDE_ccc_xml_DtdElement_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

//! (CODEX original)
//! This class has DTD element information.
//! DtdAttlist object is stored in the Node::attributes.
class DtdElement
  : public Node
{
  /*!
   * contents specification
   */
  DtdECUnit spec;
 public:
  /*! コンストラクタ */
  DtdElement(Document* document, CCC_IN const DOMString* element_name);
  DtdElement(Document* document, CCC_IN const DOMString& element_name);
  /*! デストラクタ */
  ~DtdElement();
  /*!
   * (CODEX original)<br>
   * ノードを複製します。
   * \param deep deep copyするかどうかのフラグ
   * \return 複製されたノード
   */
  virtual Node* cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException);
  const DOMString* getElementName() const { return node_name; }
  DtdECUnit* getSpec() { return &spec; }
  /*!
   * (CODEX original)<br>
   * XMLをストリームに書き出します。
   * \param xo 出力先
   */
  virtual void writeXml(XMLOutputter* xo) const CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_DtdElement_h */
