﻿// $Id$
// class DtdPEntity

#include <ccc/xml/dom.h>

using namespace CCC;

DtdPEntity::DtdPEntity(Document* document, CCC_IN const DOMString* entity_name)
  : External(document, 0, DTD_PENTITY_NODE)
{
  setNodeName(entity_name);
}

DtdPEntity::DtdPEntity(Document* document, CCC_IN const DOMString& entity_name)
  : External(document, 0, DTD_PENTITY_NODE)
{
  setNodeName(entity_name);
}

DtdPEntity::DtdPEntity(const DtdPEntity& ref)
  : External(ref.getOwnerDocument(), 0, DTD_PENTITY_NODE)
{
  setNodeName(ref.getNodeName());
}

DtdPEntity::~DtdPEntity()
{
}

Node*
DtdPEntity::cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException)
{
  DtdPEntity* entity = new DtdPEntity(*this);
  return entity;
}
