﻿// $Id$

#ifndef INCLUDE_ccc_xml_DtdPEntity_h
#define INCLUDE_ccc_xml_DtdPEntity_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

//! (CODEX original)
//! This class has DTD parameter entity information.
class DtdPEntity
  : public External
{
 public:
  /*! コンストラクタ */
  DtdPEntity(Document* document, CCC_IN const DOMString* entity_name);
  DtdPEntity(Document* document, CCC_IN const DOMString& entity_name);
  /*! コピーコンストラクタ */
  DtdPEntity(const DtdPEntity& ref);
  /*! デストラクタ */
  ~DtdPEntity();
  /*!
   * (CODEX original)<br>
   * ノードを複製します。
   * \param deep deep copyするかどうかのフラグ
   * \return 複製されたノード
   */
  virtual Node* cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException);
  const DOMString* getEntityName() const { return node_name; }
  const DOMString* getPEDef() const { return &node_value; }
  /*!
   * (CODEX original)<br>
   * XMLをストリームに書き出します。
   * \param xo 出力先
   */
  virtual void writeXml(XMLOutputter* xo) const CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_DtdPEntity_h */
