﻿#line 1 "Element.upp"
#include <ccc/xml/dom.h>
#include <ccc/base/cstring.h>

using namespace CCC;

const DOMString*
Element::getAttribute(CCC_IN const DOMString* name) const
{
  Attr* attr = (Attr*)getAttributes()->getNamedItem(name);
  if (attr)
  {
    return attr->getValue();
  }
  return null_string;
}

const DOMString*
Element::getAttribute(CCC_IN const DOMString& name) const
{
  Attr* attr = (Attr*)getAttributes()->getNamedItem(name);
  if (attr)
  {
    return attr->getValue();
  }
  return null_string;
}

const DOMString*
Element::getAttribute(CCC_IN const DOMChar* name) const
{
  Attr* attr = (Attr*)getAttributes()->getNamedItem(name);
  if (attr)
  {
    return attr->getValue();
  }
  return null_string;
}

const DOMString*
Element::getAttributeNS(CCC_IN const DOMString* namespace_uri_,
			CCC_IN const DOMString* local_name_)
{
  Attr* attr = getAttributeNodeNS(namespace_uri_, local_name_);
  if (attr)
  {
    return attr->getValue();
  }
  return null_string;
}

const DOMString*
Element::getAttributeNS(CCC_IN const DOMChar* namespace_uri_,
			CCC_IN const DOMChar* local_name_)
{
  Attr* attr = getAttributeNodeNS(namespace_uri_, local_name_);
  if (attr)
  {
    return attr->getValue();
  }
  return null_string;
}

void
Element::setAttribute(CCC_IN const DOMString* name, CCC_IN const DOMString* value) CCC_RAISES(DOMException)
{
  Attr* attr = (Attr*)getAttributes()->getNamedItem(name);
  if (attr)
  {
    attr->setValue(value);
  }
  else
  {
    // create new Attr
    attr = new Attr(getOwnerDocument(), name, value);
    getAttributes()->setNamedItem(attr);
  }
}

void
Element::setAttribute(CCC_IN const DOMString& name, CCC_IN const DOMString& value) CCC_RAISES(DOMException)
{
  Attr* attr = (Attr*)getAttributes()->getNamedItem(name);
  if (attr)
  {
    attr->setValue(value);
  }
  else
  {
    // create new Attr
    attr = new Attr(getOwnerDocument(), name, value);
    getAttributes()->setNamedItem(attr);
  }
}

void
Element::setAttribute(CCC_IN const DOMChar* name, CCC_IN const DOMChar* value) CCC_RAISES(DOMException)
{
  Attr* attr = (Attr*)getAttributes()->getNamedItem(name);
  if (attr)
  {
    attr->setValue(value);
  }
  else
  {
    // create new Attr
    DOMString name_d(name);
    DOMString value_d(value);
    attr = new Attr(getOwnerDocument(), &name_d, &value_d);
    getAttributes()->setNamedItem(attr);
  }
}

Attr*
Element::setAttributeNodeNS(CCC_IN Attr* new_attr) CCC_RAISES(DOMException)
{
  Node* node = getAttributes()->setNamedItemNS(new_attr);
  return (Attr*)node;
}

void
Element::setAttributeNS(CCC_IN const DOMString* namespace_uri_,
			CCC_IN const DOMString* qualified_name_,
			CCC_IN const DOMString* value_) CCC_RAISES(DOMException)
{
  Document* doc = getOwnerDocument();
  DOMString* namespace_uri_atom = doc->getNamespaceUriAtom(namespace_uri_);
  DOMString* local_name_atom = doc->getLocalNameFromQualifiedName(qualified_name_);
  Attr* attr = (Attr*)getAttributes()->getNamedItemNSWithAtom(namespace_uri_atom, local_name_atom);
  if (attr)
  {
    attr->setValue(value_);
  }
  else
  {
    attr = doc->createAttributeNS(namespace_uri_, qualified_name_);
    attr->setValue(value_);
    Node* old = getAttributes()->setNamedItemNS(attr);
    assert(!old);
  }
}

void
Element::removeAttribute(CCC_IN const DOMString* name) CCC_RAISES(DOMException)
{
  if (getAttributes()->getNamedItem(name))
  {
    Node* node = getAttributes()->removeNamedItem(name);
    delete node;
  }
}

void
Element::removeAttribute(CCC_IN const DOMString& name) CCC_RAISES(DOMException)
{
  if (getAttributes()->getNamedItem(name))
  {
    Node* node = getAttributes()->removeNamedItem(name);
    delete node;
  }
}

void
Element::removeAttributeNS(CCC_IN const DOMString* namespace_uri_,
			   CCC_IN const DOMString* local_name_) CCC_RAISES(DOMException)
{
  if (getAttributes()->getNamedItemNS(namespace_uri, local_name))
  {
    Node* node = getAttributes()->removeNamedItemNS(namespace_uri_, local_name_);
    delete node;
  }
}

Attr*
Element::getAttributeNode(CCC_IN const DOMString* name) const
{
  return (Attr*)getAttributes()->getNamedItem(name);
}

Attr*
Element::getAttributeNode(CCC_IN const DOMString& name) const
{
  return (Attr*)getAttributes()->getNamedItem(name);
}

Attr*
Element::getAttributeNodeNS(CCC_IN const DOMString* namespace_uri_,
			    CCC_IN const DOMString* local_name_) const
{
  Document* doc = getOwnerDocument();
  DOMString* namespace_uri_atom = doc->getNamespaceUriAtom(namespace_uri_);
  DOMString* local_name_atom = doc->getAtom(local_name_);
  Attr* attr = (Attr*)getAttributes()->getNamedItemNSWithAtom(namespace_uri_atom, local_name_atom);
  return attr;
}

Attr*
Element::getAttributeNodeNS(CCC_IN const DOMChar* namespace_uri_,
			    CCC_IN const DOMChar* local_name_) const
{
  Document* doc = getOwnerDocument();
  DOMString* namespace_uri_atom = doc->getNamespaceUriAtom(namespace_uri_);
  DOMString* local_name_atom = doc->getAtom(local_name_);
  Attr* attr = (Attr*)getAttributes()->getNamedItemNSWithAtom(namespace_uri_atom, local_name_atom);
  return attr;
}

bool
Element::hasAttribute(CCC_IN const DOMString* name) const
{
  Attr* attr = getAttributeNode(name);
  return attr != 0;
}

bool
Element::hasAttributeNS(CCC_IN const DOMString* namespace_uri_,
			CCC_IN const DOMString* local_name_) const
{
  Attr* attr = getAttributeNodeNS(namespace_uri_, local_name_);
  return attr != 0;
}

Attr*
Element::setAttributeNode(CCC_IN Attr* new_attr) CCC_RAISES(DOMException)
{
  const DOMString* new_attr_name = new_attr->getName();
  Attr* prev = getAttributeNode(new_attr_name);
  if (prev)
  {
    removeAttributeNode(prev);
  }
  getAttributes()->setNamedItem(new_attr);
  return prev;
}

Attr*
Element::removeAttributeNode(CCC_IN Attr* old_attr) CCC_RAISES(DOMException)
{
  return (Attr*)getAttributes()->removeNode(old_attr);
}

NodeList*
Element::getElementsByTagName(CCC_IN const DOMString* name) const
{
  Document* document = getOwnerDocument();
  assert(document);
  DOMString* name_atom = document->getAtom(name);
  static DOMChar all[] = { 0x2a /* * */, 0x00, };
  NodeList* ret = new XNodeList();
  ConstNodeIterator ni(this);
  const Node* p;
  if (name->strCmp(all) == 0)
  {
    while ((p = ni.next()))
    {
      ret->add((Node*)p);
    }
  }
  else
  {
    while ((p = ni.next()))
    {
      if (p->getNodeName() == name_atom)
      {
	ret->add((Node*)p);
      }
    }
  }
  return ret;
}

NodeList*
Element::getElementsByTagName(CCC_IN const DOMChar* name) const
{
  Document* document = getOwnerDocument();
  assert(document);
  DOMString* name_atom = document->getAtom(name);
  static DOMChar all[] = { 0x2a /* * */, 0x00, };
  NodeList* ret = new XNodeList();
  ConstNodeIterator ni(this);
  const Node* p;
  if (strCmp(name, all) == 0)
  {
    while ((p = ni.next()))
    {
      ret->add((Node*)p);
    }
  }
  else
  {
    while ((p = ni.next()))
    {
      if (p->getNodeName() == name_atom)
      {
	ret->add((Node*)p);
      }
    }
  }
  return ret;
}

NodeList*
Element::getElementsByTagNameNS(CCC_IN const DOMString* namespace_uri_, CCC_IN const DOMString* local_name_) const
{
  Document* document = getOwnerDocument();
  assert(document);
  DOMString* namespace_uri_atom = document->getNamespaceUriAtom(namespace_uri_);
  DOMString* local_name_atom = document->getAtom(local_name_);
  static DOMChar all[] = { 0x2a /* * */, 0x00, };
  bool all_namespace_uri_p = (namespace_uri_->strCmp(all) == 0);
  bool all_local_name_p = (local_name_->strCmp(all) == 0);

  NodeList* ret = new XNodeList();
  ConstNodeIterator ni(this);
  const Node* p;
  while ((p = ni.next()))
  {
    if (all_namespace_uri_p ||
	(p->getNamespaceURI() == namespace_uri_atom))
    {
      if (all_local_name_p ||
	  (p->getLocalName() == local_name_atom))
      {
	ret->add((Node*)p);
      }
    }
  }
  return ret;
}

NodeList*
Element::getElementsByTagNameNS(CCC_IN const DOMChar* namespace_uri_, CCC_IN const DOMChar* local_name_) const
{
  Document* document = getOwnerDocument();
  assert(document);
  DOMString* namespace_uri_atom = document->getNamespaceUriAtom(namespace_uri_);
  DOMString* local_name_atom = document->getAtom(local_name_);
  static DOMChar all[] = { 0x2a /* * */, 0x00, };
  bool all_namespace_uri_p = (strCmp(namespace_uri_, all) == 0);
  bool all_local_name_p = (strCmp(local_name_, all) == 0);

  NodeList* ret = new XNodeList();
  ConstNodeIterator ni(this);
  const Node* p;
  while ((p = ni.next()))
  {
    if (all_namespace_uri_p ||
	(p->getNamespaceURI() == namespace_uri_atom))
    {
      if (all_local_name_p ||
	  (p->getLocalName() == local_name_atom))
      {
	ret->add((Node*)p);
      }
    }
  }
  return ret;
}

Node*
Element::cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException)
{
  Element* new_element = new Element(*this);
  if (deep)
  {
    deepCopy(new_element);
  }
  return new_element;
}

// CODEX
Element::Element(Document* document_, Node* parent_, CCC_IN const DOMString* tag_name)
 : Node(document_, parent_, Node::ELEMENT_NODE)
{
  setNodeName(tag_name);
}

Element::Element(Document* document_, Node* parent_, CCC_IN const DOMString& tag_name)
 : Node(document_, parent_, Node::ELEMENT_NODE)
{
  setNodeName(tag_name);
}

Element::Element(Document* document_, Node* parent_, CCC_IN const DOMString* namespace_uri, CCC_IN const DOMString* qualified_name)
  : Node(document_, parent_, Node::ELEMENT_NODE)
{
  setNodeNameNS(namespace_uri, qualified_name);
}

Element::Element(Document* document_, Node* parent_, CCC_IN const DOMString& namespace_uri, CCC_IN const DOMString& qualified_name)
  : Node(document_, parent_, Node::ELEMENT_NODE)
{
  setNodeNameNS(namespace_uri, qualified_name);
}

Element::Element(const Element& element)
 : Node(element)
{
}

Element::~Element()
{
}

DOMString*
Element::getChildTextValue() const
{
  DOMString* s = new DOMString();
  Node* node = getChildNodes()->head();
  while (node)
  {
    if (node->getNodeType() == Node::TEXT_NODE)
    {
      s->add(*(node->getNodeValue()));
    }
    node = node->getNext();
  }
  return s;
}

Element*
Element::getElementById(CCC_IN DOMString* elementId) const
{
  // get id attribute
  static DOMChar s_id[] = { 0x69 /* i */, 0x64 /* d */, 0x00, };
  Attr* attr = (Attr*)getAttributes()->getNamedItem(s_id);
  if (attr && (attr->getValue()->strCmp(elementId) == 0))
  {
    // found!
    return (Element*)this;
  }
  const Element* element = 0;
  const Node* node = getChildNodes()->head();
  while (node)
  {
    if (node->getNodeType() == Node::ELEMENT_NODE)
    {
      element = ((const Element*)node)->getElementById(elementId);
      if (element)
      {
	break;
      }
    }
    node = node->getNext();
  }
  return (Element*)element;
}
