﻿// $Id$

#include <ccc/xml/dom.h>

using namespace CCC;

// CODEX
Entity::Entity(Document* document, CCC_IN const DOMString* entity_name)
 : External(document, 0, Node::ENTITY_NODE)	// NOTE: Entity doesn't have parent
{
  ndata = 0;
  setNodeName(entity_name);
}

Entity::Entity(Document* document, CCC_IN const DOMString& entity_name)
 : External(document, 0, Node::ENTITY_NODE)	// NOTE: Entity doesn't have parent
{
  ndata = 0;
  setNodeName(entity_name);
}

Entity::Entity(const Entity& ref)
  : External((External&)ref),
    notation_name(ref.notation_name)
{
  setNodeName(ref.getNodeName());
  if (ref.ndata)
  {
    ndata = new DOMString(ref.ndata);
  }
  else
  {
    ndata = 0;
  }
}

Entity::~Entity()
{
  delete ndata;
}

Node*
Entity::cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException)
{
  Entity* entity = new Entity(*this);
  return entity;
}

void
Entity::setNdata(DOMString* s)
{
  if (ndata)
  {
    delete ndata;
  }
  ndata = new DOMString(*s);
}
