﻿// $Id$

#ifndef INCLUDE_ccc_xml_Entity_h
#define INCLUDE_ccc_xml_Entity_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * \brief This class has DTD general entity information.
 *
 * This interface represents an entity, either parsed or unparsed, in an XML
 * document. Note that this models the entity itself not the entity
 * declaration. Entity declaration modeling has been left for a later Level
 * of the DOM specification.
 *
 * The nodeName attribute that is inherited from Node contains the name of
 * the entity.
 *
 * An XML processor may choose to completely expand entities before the
 * structure model is passed to the DOM; in this case there will be no
 * EntityReference nodes in the document tree.
 *
 * XML does not mandate that a non-validating XML processor read and process
 * entity declarations made in the external subset or declared in external
 * parameter entities. This means that parsed entities declared in the
 * external subset need not be expanded by some classes of applications, and
 * that the replacement value of the entity may not be available. When the
 * replacement value is available, the corresponding Entity node's child list
 * represents the structure of that replacement text. Otherwise, the child
 * list is empty.
 *
 * The DOM Level 2 does not support editing Entity nodes; if a user wants to
 * make changes to the contents of an Entity, every related EntityReference
 * node has to be replaced in the structure model by a clone of the Entity's
 * contents, and then the desired changes must be made to each of those
 * clones instead. Entity nodes and all their descendants are readonly.
 *
 * An Entity node does not have any parent.
 *
 * Note: If the entity contains an unbound namespace prefix, the namespaceURI
 * of the corresponding node in the Entity node subtree is null. The same is
 * true for EntityReference nodes that refer to this entity, when they are
 * created using the createEntityReference method of the Document interface.
 * The DOM Level 2 does not support any mechanism to resolve namespace
 * prefixes.
 */
class Entity
  : public External
{
  /*!
   * For unparsed entities, the name of the notation for the entity.
   * For parsed entities, this is null.
   */
  DOMString notation_name;
  /*!
   * (CODEX original)
   */
  DOMString* ndata;
  /*!
   * (CODEX original)
   */
  DOMString entity_value;
 public:
  /*!
   * Notation名を取得します。
   * \return Notation名
   */
  const DOMString* getNotationName() const { return &notation_name; }
  /*!
   * (CODEX original)<br>
   * ノードを複製します。
   * \param deep deep copyするかどうかのフラグ
   * \return 複製されたノード
   */
  virtual Node* cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException);
  /* !
   * Introduced in DOM Level 2:<br>
   * The public identifier of the external subset.
   */
  //const DOMString* getPublicId() const { return External::getPublidId(); }
  /* !
   * Introduced in DOM Level 2:<br>
   * The system identifier of the external subset.
   */
  //const DOMString* getSystemId() const { return External::getSystemId(); }
  // (CODEX original)
  Entity(Document* document, CCC_IN const DOMString* entity_name);
  Entity(Document* document, CCC_IN const DOMString& entity_name);
  /*! コピーコンストラクタ */
  Entity(const Entity& entity);
  ~Entity();
  const DOMString* getEntityName() { return node_name; }
  void setEntityValue(DOMString* s) { entity_value.assign(*s); }
  const DOMString* getEntityValue() { return &entity_value; }
  void setNdata(DOMString* s);
  const DOMString* getNdata() { return ndata; }
  /*!
   * (CODEX original)<br>
   * XMLをストリームに書き出します。
   * \param xo 出力先
   */
  virtual void writeXml(XMLOutputter* xo) const CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_Entity_h */
