﻿// $Id$

#include <ccc/xml/dom.h>

using namespace CCC;

// class EntityReference

EntityReference::EntityReference(Document* document_, Node* parent_, CCC_IN const DOMString* name)
  : Node(document_, parent_, Node::ENTITY_REFERENCE_NODE)
{
  setNodeName(name);
}

EntityReference::EntityReference(Document* document_, Node* parent_, CCC_IN const DOMString& name)
  : Node(document_, parent_, Node::ENTITY_REFERENCE_NODE)
{
  setNodeName(name);
}

EntityReference::EntityReference(const EntityReference& entity_reference)
 : Node(entity_reference.getOwnerDocument(), 0, Node::ENTITY_REFERENCE_NODE)
{
  setNodeName(entity_reference.getNodeName());
}

EntityReference::~EntityReference()
{
}

Node*
EntityReference::cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException)
{
  EntityReference* entity_reference = new EntityReference(*this);
  return entity_reference;
}
