﻿// $Id$

#ifndef INCLUDE_ccc_xml_EntityReference_h
#define INCLUDE_ccc_xml_EntityReference_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * EntityReference objects may be inserted into the structure model when an
 * entity reference is in the source document, or when the user wishes to
 * insert an entity reference. Note that character references and references
 * to predefined entities are considered to be expanded by the HTML or XML
 * processor so that characters are represented by their Unicode equivalent
 * rather than by an entity reference. Moreover, the XML processor may
 * completely expand references to entities while building the structure
 * model, instead of providing EntityReference objects. If it does provide
 * such objects, then for a given EntityReference node, it may be that there
 * is no Entity node representing the referenced entity. If such an Entity
 * exists, then the subtree of the EntityReference node is in general a copy
 * of the Entity node subtree. However, this may not be true when an entity
 * contains an unbound namespace prefix. In such a case, because the
 * namespace prefix resolution depends on where the entity reference is, the
 * descendants of the EntityReference node may be bound to different
 * namespace URIs.
 *
 * As for Entity nodes, EntityReference nodes and all their descendants are
 * readonly.
 */
class EntityReference
  : public Node
{
  // DOM 1: The child list of the Entity Reference node is the same
  // as that of the Entity node.
  // DOM 2/3: The subtree of the EntityReference node is in general a
  // copy of the Entity node subtree.
 public:
  /*!
   * (CODEX original)<br>
   * ノードを複製します。
   * \param deep deep copyするかどうかのフラグ
   * \return 複製されたノード
   */
  virtual Node* cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException);
  //! (CODEX original)
  /*! コンストラクタ */
  EntityReference(Document* document_, Node* parent_, CCC_IN const DOMString* name);
  EntityReference(Document* document_, Node* parent_, CCC_IN const DOMString& name);
  /*! コピーコンストラクタ */
  EntityReference(const EntityReference& entity_reference);
  ~EntityReference();
  /*!
   * (CODEX original)<br>
   * XMLをストリームに書き出します。
   * \param xo 出力先
   */
  virtual void writeXml(XMLOutputter* xo) const CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_EntityReference_h */
