﻿// $Id$

#ifndef INCLUDE_ccc_xml_Esis_h
#define INCLUDE_ccc_xml_Esis_h

#include <ccc/base/TextWriter.h>
#include <ccc/base/TextReader.h>
#include <ccc/iceman/Iceman.h>
#include <ccc/xml/dom.h>

CCC_NAMESPACE_START(CCC);

/*!
 * ESIS(Element Structured Information Set)を取り扱うクラスです。
 */
class Esis
{
  /*!
   * ESISを生成するために呼び出されるnsgmlsコマンド
   */
  static const char* nsgmls_cmd;
  /*!
   * DTD等のデータの置かれたディレクトリパス
   * デフォルトはカレントディレクトリが指定されています。
   */
  static const char* data_path;
 public:
  /*!
   * SGMLファイルを読み込み、SGMLパーサで解析し、解析結果のESIS形式の
   * メモリイメージを返します。
   * \param filename ファイル名
   * \param log ログの出力先
   * \return メモリイメージ
   */
  static Allocator* getEsis(const char* filename, TextWriter<Int8>& log);
  /*!
   * ESIS形式の入力フローからDOMのドキュメントを構築します。
   * \param dom_imp DOMImplementation
   * \param esis_in ESIS形式の入力フロー
   * \param esis_ceid ESISのエンコーディング
   * \param log ログの出力先
   * \return DOMドキュメント, 0が返された場合にはエラーが発生したことを
   * 示します。
   */
  static Document* readEsis(DOMImplementation* dom_imp, IFlow* esis_in, CeId esis_ceid, TextWriter<Int8>& log);
  /*!
   * nsgmlsコマンドを設定します。
   * \param cmd nsgmlsコマンド
   */
  static void setNsgmlsCmd(const char* cmd)
  {
    nsgmls_cmd = cmd;
  }
  /*!
   * DTD等のデータの置かれたディレクトリパスを設定します。
   * \param path パス
   */
  static void setDataPath(const char* path)
  {
    data_path = path;
  }
 private:
  /*!
   * for readFile()
   */
  static Element* readElement(Document* document, Node* parent, TextReader<Int8>& reader, CeId esis_ceid, TextWriter<Int8>& log);
  /*!
   * ESISのテキストデータをデコードします。
   */
  static void decodeEsisText(BString& str);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_Esis_h */
