﻿// $Id$
// class External

#include <ccc/xml/dom.h>

using namespace CCC;

External::External(Document* document, Node* parent, unsigned short node_type)
  : Node(document, parent, node_type)
{
  public_id = 0;
  system_id = 0;
}

External::External(External& ref)
  : Node(ref)
{
  if (ref.public_id)
  {
    public_id = new DOMString(ref.public_id);
  }
  if (ref.system_id)
  {
    system_id = new DOMString(ref.system_id);
  }
}

External::~External()
{
  delete public_id;
  delete system_id;
}

void
External::setPublicId(CCC_IN const DOMString* public_id)
{
  delete External::public_id;
  External::public_id = new DOMString(public_id);
}

void
External::setPublicId(CCC_IN const DOMString& public_id)
{
  delete External::public_id;
  External::public_id = new DOMString(public_id);
}

void
External::setSystemId(CCC_IN const DOMString* system_id)
{
  delete External::system_id;
  External::system_id = new DOMString(system_id);
}

void
External::setSystemId(CCC_IN const DOMString& system_id)
{
  delete External::system_id;
  External::system_id = new DOMString(system_id);
}
