﻿// $Id$

#ifndef INCLUDE_ccc_xml_External_h
#define INCLUDE_ccc_xml_External_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * (CODEX original)<br>
 * Externalクラスは内部的に継承して使用する目的で用意されています。
 */
class External
  : public Node
{
  /*!
   * 公開識別子(public id)
   */
  DOMString* public_id;
  /*!
   * システム識別子(system id)
   */
  DOMString* system_id;
 protected:
  friend class XMLParser;
  /*!
   * (CODEX original)<br>
   * コンストラクタ
   * \param document Document
   * \param parent 親ノード
   * \param node_type ノード形式
   */
  External(Document* document, Node* parent, unsigned short node_type);
  /*!
   * (CODEX original)<br>
   * コピーコンストラクタ
   * \param ref コピー元
   */
  External(External& ref);
  /*!
   * (CODEX original)<br>
   * デストラクタ
   */
  ~External();
 public:
  /*!
   * (CODEX original)<br>
   * 公開識別子を設定します。
   * \param public_id 公開識別子
   */
  void setPublicId(CCC_IN const DOMString* public_id);
  void setPublicId(CCC_IN const DOMString& public_id);
  /*!
   * (CODEX original)<br>
   * システム識別子を設定します。
   * \param system_id システム識別子
   */
  void setSystemId(CCC_IN const DOMString* system_id);
  void setSystemId(CCC_IN const DOMString& system_id);
  /*!
   * (CODEX original)<br>
   * 公開識別子を取得します。
   * \return 公開識別子
   */
  const DOMString* getPublicId() const { return public_id; }
  /*!
   * (CODEX original)<br>
   * システム識別子を取得します。
   * \return システム識別子
   */
  const DOMString* getSystemId() const { return system_id; }
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_External_h */
