﻿// $Id$

#include <ccc/xml/dom.h>

using namespace CCC;

NamedNodeMap::NamedNodeMap(Node* owner)
  : owner_node(owner)
{
}

NamedNodeMap::~NamedNodeMap()
{
  // delete child nodes.
  Iterator<Node>* it = createIterator();
  Node* node;
  while ((node = it->next()))
  {
    delete node;
  }
  delete it;
}

const DOMString*
NamedNodeMap::getKey(const Node* element) const
{
  return (const DOMString*)element->getNodeName();
}

int
NamedNodeMap::compare(const DOMString* key1, const DOMString* key2) const
{
  return key1->strCmp(*key2);
}

Node*
NamedNodeMap::removeNode(Node* node)
{
  if (remove((Node*)node))
  {
    if (node->getNodeType() == Node::ATTRIBUTE_NODE)
    {
      ((Attr*)node)->setOwnerElement(0);
    }
    return node;
  }
  return 0;
}

Node*
NamedNodeMap::getNamedItem(CCC_IN const DOMString* name) const
{
  return search(name);
}

Node*
NamedNodeMap::getNamedItem(CCC_IN const DOMString& name) const
{
  return search(&name);
}

Node*
NamedNodeMap::getNamedItem(CCC_IN const DOMChar* name) const
{
  DOMString s(name);
  return search(&s);
}

Node*
NamedNodeMap::getNamedItemNS(CCC_IN const DOMString* namespace_uri,
			     CCC_IN const DOMString* local_name)
{
  DOMString* namespace_uri_atom = 0;
  DOMString* local_name_atom = 0;
  Iterator<Node>* it = createIterator();
  Node* node = 0;
  while ((node = it->next()))
  {
    Document* doc = node->getOwnerDocument();
    if (namespace_uri_atom == 0)
    {
      namespace_uri_atom = doc->getNamespaceUriAtom(namespace_uri);
    }
    if (local_name_atom == 0)
    {
      local_name_atom = doc->getAtom(local_name);
    }
    if ((node->getNamespaceURI() == namespace_uri_atom) &&
	(node->getLocalName() == local_name_atom))
    {
      break;
    }
  }
  delete it;
  return node;
}

Node*
NamedNodeMap::getNamedItemNS(CCC_IN const DOMChar* namespace_uri,
			     CCC_IN const DOMChar* local_name)
{
  DOMString* namespace_uri_atom = 0;
  DOMString* local_name_atom = 0;
  Iterator<Node>* it = createIterator();
  Node* node = 0;
  while ((node = it->next()))
  {
    Document* doc = node->getOwnerDocument();
    if (namespace_uri_atom == 0)
    {
      namespace_uri_atom = doc->getNamespaceUriAtom(namespace_uri);
    }
    if (local_name_atom == 0)
    {
      local_name_atom = doc->getAtom(local_name);
    }
    if ((node->getNamespaceURI() == namespace_uri_atom) &&
	(node->getLocalName() == local_name_atom))
    {
      break;
    }
  }
  delete it;
  return node;
}

Node*
NamedNodeMap::getNamedItemNSWithAtom(const DOMString* namespace_uri_atom,
				     const DOMString* local_name_atom)
{
  Iterator<Node>* it = createIterator();
  Node* node = 0;
  while ((node = it->next()))
  {
    if ((node->getNamespaceURI() == namespace_uri_atom) &&
	(node->getLocalName() == local_name_atom))
    {
      break;
    }
  }
  delete it;
  return node;
}

Node*
NamedNodeMap::setNamedItem(CCC_IN Node* arg) CCC_RAISES(DOMException)
{
  // Attr* attr = (Attr*)arg;
  // Node* node = search(attr->getName());
  Node* node = search(arg->getNodeName());
  if (node)
  {
    remove(node);
    if (node->getNodeType() == Node::ATTRIBUTE_NODE)
    {
      ((Attr*)node)->setOwnerElement(0);
    }
  }
  add(arg);
  if (arg->getNodeType() == Node::ATTRIBUTE_NODE)
  {
    ((Attr*)arg)->setOwnerElement(owner_node);
  }
  return node;
}

Node*
NamedNodeMap::setNamedItemNS(CCC_IN Node* arg) CCC_RAISES(DOMException)
{
  const DOMString* namespace_uri_atom = arg->getNamespaceURI();
  const DOMString* local_name_atom = arg->getLocalName();
  Node* node = getNamedItemNSWithAtom(namespace_uri_atom, local_name_atom);
  if (node)
  {
    remove(node);
    if (node->getNodeType() == Node::ATTRIBUTE_NODE)
    {
      ((Attr*)node)->setOwnerElement(0);
    }
  }
  add(arg);
  if (arg->getNodeType() == Node::ATTRIBUTE_NODE)
  {
    ((Attr*)arg)->setOwnerElement(owner_node);
  }
  return node;
}

Node*
NamedNodeMap::removeNamedItem(CCC_IN const DOMString* name) CCC_RAISES(DOMException)
{
  Node* node = search(name);
  if (!node)
  {
    throw DOMException(NOT_FOUND_ERR);
  }
  remove(node);
  if (node->getNodeType() == Node::ATTRIBUTE_NODE)
  {
    ((Attr*)node)->setOwnerElement(0);
  }
  return node;
}

Node*
NamedNodeMap::removeNamedItem(CCC_IN const DOMChar* name) CCC_RAISES(DOMException)
{
  DOMString x(name);
  Node* node = search(&x);
  if (!node)
  {
    throw DOMException(NOT_FOUND_ERR);
  }
  remove(node);
  if (node->getNodeType() == Node::ATTRIBUTE_NODE)
  {
    ((Attr*)node)->setOwnerElement(0);
  }
  return node;
}

Node*
NamedNodeMap::removeNamedItemNS(CCC_IN const DOMString* namespace_uri,
				CCC_IN const DOMString* local_name) CCC_RAISES(DOMException)
{
  Node* node = getNamedItemNS(namespace_uri, local_name);
  if (!node)
  {
    throw DOMException(NOT_FOUND_ERR);
  }
  remove(node);
  if (node->getNodeType() == Node::ATTRIBUTE_NODE)
  {
    ((Attr*)node)->setOwnerElement(0);
  }
  return node;
}

Node*
NamedNodeMap::item(CCC_IN Size index) const
{
  Iterator<Node>* it = createIterator();
  unsigned long n = 0;
  Node* node;
  while ((node = it->next()))
  {
    if (n++ == index)
    {
      break;
    }
  }
  delete it;
  if (!node)
  {
    throw DOMException(NOT_FOUND_ERR);
  }
  return node;
}

Size
NamedNodeMap::getLength() const
{
  return number();
}

