﻿// $Id$

#ifndef INCLUDE_ccc_xml_NamespaceUnit_h
#define INCLUDE_ccc_xml_NamespaceUnit_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * 名前空間を処理するためのスタック要素
 */
struct NamespaceUnit
{
  /*!
   * プレフィックスのアトム
   */
  DOMString* prefix_atom;
  /*!
   * 名前空間URIのアトム
   */
  DOMString* namespace_uri_atom;
  /*!
   * 名前空間の定義されているエレメント
   */
  Element* element;
  /*!
   * このスタックまでに空プレフィックスが定義されて
   * いるかどうかを示すフラグです。
   * 空プレフィックスの存在確認を瞬時に行なうために、
   * このフラグを用います。
   */
  bool empty_prefix_defined_p;
 public:
  /*!
   * コンストラクタ
   * \param prefix_atom プレフィックスのアトム
   * \param namespace_uri_atom 名前空間URIのアトム
   * \param element 名前空間の定義されているエレメント
   * \param empty_prefix_defined_p 空プレフィックスが定義されているかを示します。
   */
  NamespaceUnit(DOMString* prefix_atom, DOMString* namespace_uri_atom, Element* element, bool empty_prefix_defined_p)
  {
    NamespaceUnit::prefix_atom = prefix_atom;
    NamespaceUnit::namespace_uri_atom = namespace_uri_atom;
    NamespaceUnit::element = element;
    NamespaceUnit::empty_prefix_defined_p = empty_prefix_defined_p;
  }
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_NamespaceUnit_h */
