﻿// $Id$

#include <assert.h>
#include <ccc/xml/dom.h>

using namespace CCC;

static bool
initializeXml(bool init_p)
{
  if (init_p)
  {
    Node::initialize(true);
    DOMImplementation::initailze(true);
    return true;
  }
  else
  {
    DOMImplementation::initailze(false);
    Node::initialize(false);
    return true;
  }
}

static int initialize_xml_dummy = Ccc::setInitializeHandler(CM_XML, &initializeXml);

DOMString* Node::null_string = 0;

void
Node::initialize(bool p)
{
  if (p)
  {
    null_string = new DOMString();
  }
  else
  {
    delete null_string;
    null_string = 0;
  }
}

Node::Node(Document* document_, Node* parent_, unsigned short node_type_)
{
  document = document_;
  parent = parent_;
  node_type = node_type_;
  attributes = new NamedNodeMap(this);
  node_name = 0;
  prefix = 0;
  local_name = 0;
  namespace_uri = 0;
#ifndef CODEX_PURE_DOM
  node_extention = 0;
  redundant_empty_tag_expression_p = false;
#endif /* CODEX_PURE_DOM */
}

// for cloning
// this method doesn't copy any descendant
Node::Node(const Node& node)
{
  document = node.document;
  parent = 0;
  node_type = node.node_type;
  attributes = new NamedNodeMap(this);
  node_name = node.node_name;
  prefix = node.prefix;
  local_name = node.local_name;
  namespace_uri = node.namespace_uri;
  node_value.assign(node.node_value);
#ifndef CODEX_PURE_DOM
  node_extention = 0;
#endif /* CODEX_PURE_DOM */
}

// for DocumentNode
Node::Node(unsigned short node_type_)
{
  document = (Document*)this;
  parent = 0;
  node_type = node_type_;
  attributes = new NamedNodeMap(this);
  node_name = 0;
  prefix = 0;
  local_name = 0;
  namespace_uri = 0;
#ifndef CODEX_PURE_DOM
  node_extention = 0;
#endif /* CODEX_PURE_DOM */
}

Node::~Node()
{
#ifndef CODEX_PURE_DOM
  clearBps();
#endif /* CODEX_PURE_DOM */

  Node* node;
  while ((node = children.pop()))
  {
    delete node;
  }
  delete attributes;
#ifndef CODEX_PURE_DOM
  delete node_extention;
#endif /* CODEX_PURE_DOM */
}

const DOMString*
Node::getNodeValue() const CCC_RAISES(DOMException)
{
  return &node_value;
}

void
Node::setNodeValue(const DOMString* new_value) CCC_RAISES(DOMException)
{
  node_value.assign(*new_value);
}

void
Node::setNodeValue(const DOMString& new_value) CCC_RAISES(DOMException)
{
  node_value.assign(new_value);
}

void
Node::setNodeValue(const DOMChar* new_value) CCC_RAISES(DOMException)
{
  node_value.assign(new_value);
}

void
Node::setNodeValue(const DOMChar* new_value, Size length) CCC_RAISES(DOMException)
{
  node_value.assign(new_value, length);
}

Node*
Node::getFirstChild() const
{
  return children.head();
}

Node*
Node::getLastChild() const
{
  return children.tail();
}

Node*
Node::getPreviousSibling() const
{
  return getPrev();
}

Node*
Node::getNextSibling() const
{
  return getNext();
}

Node*
Node::insertBefore(CCC_IN Node* new_child, CCC_IN Node* ref_child) CCC_RAISES(DOMException)
{
  bool ret = children.insertBefore(ref_child, new_child);
  new_child->parent = this;
  if (!ret)
  {
    throw DOMException(NOT_FOUND_ERR);
  }
  return new_child;
}

Node*
Node::insertAfter(CCC_IN Node* new_child, CCC_IN Node* ref_child) CCC_RAISES(DOMException)
{
  bool ret = children.insertAfter(ref_child, new_child);
  new_child->parent = this;
  if (!ret)
  {
    throw DOMException(NOT_FOUND_ERR);
  }
  return new_child;
}

Node*
Node::replaceChild(CCC_IN Node* new_child, CCC_IN Node* old_child) CCC_RAISES(DOMException)
{
  bool ret = children.exchangeElement(old_child, new_child);
  new_child->parent = this;
  old_child->parent = 0;
  if (!ret)
  {
    throw DOMException(NOT_FOUND_ERR);
  }
  return new_child;
}

Node*
Node::removeChild(CCC_IN Node* old_child) CCC_RAISES(DOMException)
{
  bool ret = children.remove(old_child);
  old_child->parent = 0;
  if (!ret)
  {
    throw DOMException(NOT_FOUND_ERR);
  }
  return old_child;
}

Node*
Node::appendChild(CCC_IN Node* new_child) CCC_RAISES(DOMException)
{
  bool ret = children.add(new_child);
  new_child->parent = this;
  if (!ret)
  {
    throw DOMException(NOT_FOUND_ERR);	// ?
  }
  return new_child;
}

bool
Node::hasChildNodes() const
{
  return !children.emptyP();
}

#if 0
// This method is pure virtual function.
Node*
Node::cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException)
{
  Node* node = new Node(this);
  return node;
}
#endif

void
Node::setNodeName(const DOMString* new_node_name)
{
  assert(document != 0);
  node_name = document->getAtom(new_node_name);
  local_name = 0;
  namespace_uri = 0;
  prefix = 0;
}

void
Node::setNodeName(const DOMString& new_node_name)
{
  assert(document != 0);
  node_name = document->getAtom(new_node_name);
  local_name = 0;
  namespace_uri = 0;
  prefix = 0;
}

void
Node::setNodeName(const DOMChar* new_node_name)
{
  assert(document != 0);
  node_name = document->getAtom(new_node_name);
  local_name = 0;
  namespace_uri = 0;
  prefix = 0;
}

void
Node::setNodeNameNS(CCC_IN const DOMString* namespace_uri_, CCC_IN const DOMString* qualified_name_)
{
  assert(document != 0);
  assert((node_type == ELEMENT_NODE) || (node_type == ATTRIBUTE_NODE));
  node_name = document->getAtom(qualified_name_);
  namespace_uri = document->getNamespaceUriAtom(namespace_uri_);
  prefix = document->getPrefixAtomFromQualifiedName(qualified_name_);
  local_name = document->getLocalNameFromQualifiedName(qualified_name_);
}

void
Node::setNodeNameNS(CCC_IN const DOMString& namespace_uri_, CCC_IN const DOMString& qualified_name_)
{
  assert(document != 0);
  assert((node_type == ELEMENT_NODE) || (node_type == ATTRIBUTE_NODE));
  node_name = document->getAtom(qualified_name_);
  namespace_uri = document->getNamespaceUriAtom(namespace_uri_);
  prefix = document->getPrefixAtomFromQualifiedName(qualified_name_);
  local_name = document->getLocalNameFromQualifiedName(qualified_name_);
}

void
Node::setNodeNameNS(CCC_IN const DOMChar* namespace_uri_, CCC_IN const DOMChar* qualified_name_)
{
  assert(document != 0);
  assert((node_type == ELEMENT_NODE) || (node_type == ATTRIBUTE_NODE));
  node_name = document->getAtom(qualified_name_);
  namespace_uri = document->getNamespaceUriAtom(namespace_uri_);
  prefix = document->getPrefixAtomFromQualifiedName(qualified_name_);
  local_name = document->getLocalNameFromQualifiedName(qualified_name_);
}

void
Node::setPrefix(const DOMString* new_prefix) CCC_RAISES(DOMException)
{
  assert(document != 0);
  if (new_prefix)
  {
    prefix = document->getPrefixAtom(new_prefix);
  }
  else
  {
    prefix = 0;
  }
}

void
Node::setPrefix(const DOMString& new_prefix) CCC_RAISES(DOMException)
{
  assert(document != 0);
  prefix = document->getPrefixAtom(new_prefix);
}

void
Node::setPrefix(const DOMChar* new_prefix) CCC_RAISES(DOMException)
{
  assert(document != 0);
  prefix = document->getPrefixAtom(new_prefix);
}

Node*
Node::getAncestor(const DOMString* atom_node_name)
{
  Node* parent_node = getParentNode();
  while (parent_node)
  {
    if (parent_node->node_name == atom_node_name)
    {
      return parent_node;
    }
    parent_node = parent_node->getParentNode();
  }
  return 0;
}

void
Node::deepCopy(Node* to_node) const
{
  // copy attributes
  const NamedNodeMap* atts = getAttributes();
  NamedNodeMap* new_atts = to_node->getAttributes();
  Size len = atts->getLength();
  Size i;
  for (i = 0; i < len; i++)
  {
    const Attr* attr = (const Attr*)atts->item(i);
    assert(attr->getNodeType() == Node::ATTRIBUTE_NODE);
    Node* new_attr = new Attr(*attr);
    new_atts->setNamedItem(new_attr);
  }
    
  // copy descendants
  const NodeList* nl = getChildNodes();
  NodeList* new_nl = to_node->getChildNodes();
  const Node* node = nl->head();
  while (node)
  {
    Node* new_node = node->cloneNode(true);
    new_nl->add(new_node);
    new_node->parent = to_node;
    node = node->getNext();
  }
}

void
Node::normalize()
{
  NodeList* children = (NodeList*)getChildNodes();
  Node* p = children->head();
  while (p)
  {
    unsigned short node_type = p->getNodeType();
    switch (node_type)
    {
     case Node::TEXT_NODE:
      {
        Text* p1 = (Text*)p;
	for (;;)
	{
	  Node* next = p->getNext();
	  if (next && next->getNodeType() == Node::TEXT_NODE)
	  {
	    // marge p and next
	    Text* p2 = (Text*)next;
	    Size p1_len = p1->getNodeValue()->getLength();
	    p1->appendData((DOMString*)p2->getData());
#ifndef CODEX_PURE_DOM
	    // move buffer pointer
	    BPList* bps = p2->getBPList();
	    BufferPointer* bp;
	    while ((bp = bps->pop()))
	    {
	      bp->set(p1, bp->getOffset() + p1_len);
	      p1->addBp(bp);
	    }
#endif /* CODEX_PURE_DOM */
	    // remove next
	    children->remove(next);
	    delete next;
	  }
	  else
	  {
	    break;
	  }
	}
      }
     case Node::ELEMENT_NODE:
     case Node::DOCUMENT_NODE:
     case Node::DOCUMENT_FRAGMENT_NODE:
      p->normalize();
      break;
    }
    p = p->getNext();
  }
}

bool
Node::hasAttributes()
{
  return !attributes->emptyP();
}

bool
Node::isSupported(CCC_IN DOMString& feature, CCC_IN DOMString& version)
{
  if (!document)
  {
    return false;
  }
  DOMImplementation* dom_implementation = document->getImplementation();
  return dom_implementation->hasFeature(feature, version);
}

#ifndef CODEX_PURE_DOM
void
Node::clearBps()
{
  Iterator<BufferPointer>* itr = bp_list.createIterator();
  BufferPointer* bp;
  while ((bp = itr->next()))
  {
    bp->clear();
  }
  delete itr;
}

void
Node::addBp(BufferPointer* bp)
{
  bp_list.add(bp);
  bp->set(this, 0);
}

void
Node::removeBp(BufferPointer* bp)
{
  bp_list.remove(bp);
  bp->clear();
}

void
Node::removeBps(BPList* bps)
{
  Iterator<BufferPointer>* itr = bps->createIterator();
  BufferPointer* bp;
  while ((bp = itr->next()))
  {
    bp_list.remove(bp);
    bp->clear();
  }
  delete itr;
}

#endif /* CODEX_PURE_DOM */

Element*
Node::getFirstChildElementByTagName(const DOMString* name) const
{
  DOMString* name_atom = getOwnerDocument()->getAtom(name);
  Node* node = getChildNodes()->head();
  while (node)
  {
    if ((node->getNodeType() == Node::ELEMENT_NODE) &&
	(node->getNodeName() == name_atom))
    {
      return (Element*)node;
    }
    node = node->getNext();
  }
  return 0;
}

Element*
Node::getFirstChildElementByTagName(const DOMChar* name) const
{
  DOMString* name_atom = getOwnerDocument()->getAtom(name);
  Node* node = getChildNodes()->head();
  while (node)
  {
    if ((node->getNodeType() == Node::ELEMENT_NODE) &&
	(node->getNodeName() == name_atom))
    {
      return (Element*)node;
    }
    node = node->getNext();
  }
  return 0;
}

Element*
Node::getFirstChildElementByTagNameNS(const DOMString* namespace_uri_, const DOMString* local_name_) const
{
  DOMString* local_name_atom = getOwnerDocument()->getAtom(local_name_);
  DOMString* namespace_uri_atom = getOwnerDocument()->getNamespaceUriAtom(namespace_uri_);
  Node* node = getChildNodes()->head();
  while (node)
  {
    if ((node->getNodeType() == Node::ELEMENT_NODE) &&
	(node->getLocalName() == local_name_atom) &&
	(node->getNamespaceURI() == namespace_uri_atom))
    {
      return (Element*)node;
    }
    node = node->getNext();
  }
  return 0;
}

Element*
Node::getFirstChildElementByTagNameNS(const DOMChar* namespace_uri_, const DOMChar* local_name_) const
{
  DOMString* local_name_atom = getOwnerDocument()->getAtom(local_name_);
  DOMString* namespace_uri_atom = getOwnerDocument()->getNamespaceUriAtom(namespace_uri_);
  Node* node = getChildNodes()->head();
  while (node)
  {
    if ((node->getNodeType() == Node::ELEMENT_NODE) &&
	(node->getLocalName() == local_name_atom) &&
	(node->getNamespaceURI() == namespace_uri_atom))
    {
      return (Element*)node;
    }
    node = node->getNext();
  }
  return 0;
}

void
Node::removeStealthTextNode()
{
  static DOMChar s_lf[] = { '\n', '\0' };
  static DOMChar s_crlf[] = { '\r', '\n', '\0' };

  Node* node = children.head();
  while (node)
  {
    Text* remove_node = 0;
    if (node->getNodeType() == Node::TEXT_NODE)
    {
      if ((node->node_value.getLength() == 0) ||
	  (node->node_value.strCmp(s_lf) == 0) ||
	  (node->node_value.strCmp(s_crlf) == 0))
      {
	remove_node = (Text*)node;
      }
    }
    if (node->getNodeType() == Node::ELEMENT_NODE)
    {
      node->removeStealthTextNode();
    }
    node = node->getNext();
    if (remove_node)
    {
      try
      {
	removeChild(remove_node);
      }
      catch (DOMException)
      {
      }
      delete remove_node;
    }
  }
}

// ------------------------------------------------------------------------
// class NodeExtension
NodeExtension::NodeExtension()
{
}

NodeExtension::~NodeExtension()
{
}
