﻿// $Id$

#ifndef INCLUDE_ccc_xml_NodeAddress_h
#define INCLUDE_ccc_xml_NodeAddress_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

#ifndef CODEX_PURE_DOM

CCC_NAMESPACE_START(CCC);

/*!
 * (CODEX original)<br>
 * ノードのツリー上の位置を兄弟の何番目の枝もしくはノードか
 * という数字の位置情報を階層分使って表現するクラスです。
 */
class NodeAddress
{
  /*!
   * 階層数
   */
  Size size;
  /*!
   * 階層数分のSizeの配列へのポインタ
   */
  Size* address;
 public:
  /*!
   * コンストラクタ
   * \param n 階層数
   */
  NodeAddress(Size n);
  /*!
   * コンストラクタ
   * 指定したノードの位置階層情報がセットされます。
   * \param node ノード
   */
  NodeAddress(Node* node);
  /*!
   * デストラクタ
   */
  ~NodeAddress();
  /*!
   * 階層数を得ます。
   * \return 階層数
   */
  Size getSize() { return size; }
  /*!
   * 指定階層の兄弟の何番目の枝もしくはノードかを返します。
   * \param n 1番上のエレメントを1とする階層番号
   * \return 先頭を1とする兄弟の何番目かを示す数値
   */
  Size getAddress(Size n);
  /*!
   * 指定階層の兄弟の何番目の枝もしくはノードかをセットします。
   * \param n 1番上のエレメントを1とする階層番号
   * \param adr 先頭を1とする兄弟の何番目かを示す数値
   */
  void setAddress(Size n, Size adr);
};

CCC_NAMESPACE_END(CCC);

#endif /* CODEX_PURE_DOM */

#endif /* INCLUDE_ccc_xml_NodeAddress_h */
