﻿// $Id$

#include <ccc/xml/dom.h>

using namespace CCC;

NodeIterator::NodeIterator(Node* top)
{
  if (top)
  {
    reset(top);
  }
  else
  {
    NodeIterator::top = 0;
    current_node = 0;
  }
}

void
NodeIterator::reset(Node* top)
{
  switch (top->getNodeType())
  {
   case Node::ELEMENT_NODE:
   case Node::DOCUMENT_NODE:
   case Node::DOCUMENT_FRAGMENT_NODE:
   case Node::TEXT_NODE:
    NodeIterator::top = top;
    break;
    
   default:
    NodeIterator::top = 0;
    break;
  }
  rewind();
}

Node*
NodeIterator::next()
{
  Node* ret = current_node;
  if (current_node)
  {
    Node* new_current_node = 0;
    // get first child
    new_current_node = current_node->getChildNodes()->head();
    if (!new_current_node)
    {
      Node* node = current_node;
      while (node && node != top)
      {
	new_current_node = node->getNext();
	if (new_current_node)
	{
	  break;
	}
	node = node->getParentNode();
      }
    }
    current_node = new_current_node;
  }
  return ret;
}

Node*
NodeIterator::prev()
{
  Node* ret = current_node;
  if (current_node)
  {
    if (current_node == top)
    {
      return 0;
    }
    Node* new_current_node = 0;
    new_current_node = current_node->getPrev();
    if (new_current_node)
    {
      Node* node = new_current_node;
      while (node)
      {
	new_current_node = node;
	node = node->getChildNodes()->tail();
      }
    }
    else
    {
      new_current_node = current_node->getParentNode();
    }
    current_node = new_current_node;
  }
  return ret;
}

Node*
NodeIterator::rewind()
{
  return current_node = top;
}

Node*
NodeIterator::unwind()
{
  current_node = 0;
  Node* node = top;
  while (node)
  {
    current_node = node;
    node = node->getChildNodes()->tail();
  }
  return current_node;
}

Size
NodeIterator::getPosition() const
{
  NodeIterator ni(top);
  Size n = 0;
  Node* node;
  while ((node = ni.next()))
  {
    n++;
    if (node == current_node)
    {
      break;
    }
  }
  return n;
}

