﻿// $Id$

#ifndef INCLUDE_ccc_xml_NodeIterator_h
#define INCLUDE_ccc_xml_NodeIterator_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * (CODEX original)<br>
 * ノードのツリーを順番に辿るためのイタレータクラスです。
 */
class NodeIterator
  : public Iterator<Node>
{
  /*!
   * 頂上ノード
   */
  Node* top;
  /*!
   * イタレート中のノード
   */
  Node* current_node;
 public:
  /*!
   * コンストラクタ
   * \param top イタレートするツリーの頂上ノード
   */
  NodeIterator(Node* top = 0);
  /*!
   * 頂上ノードを再設定します。
   * \param top イタレートするツリーの頂上ノード
   */
  void reset(Node* top);
  /*!
   * 現在位置のノードへのポインタを返します。
   * \return 指し示しているノードへのポインタ
   */
  Node* current() const { return current_node; }
  /*!
   * 現在位置のノードへのポインタを返し、参照位置を一つ進めます。
   * \return 指し示していたノードへのポインタ
   */
  Node* next();
  /*!
   * 現在位置のノードへのポインタを返し、参照位置を1つ戻します。
   * \return 指し示していたノードへのポインタ
   */
  Node* prev();
  /*!
   * 現在位置を先頭に戻します。
   * \return 先頭のノードへのポインタ
   */
  Node* rewind();
  /*!
   * 現在位置を最後まで進めます。
   * \return 最後のノードへのポインタ
   */
  Node* unwind();
  /*!
   * 現在位置が有効な位置かどうかを調べます。
   * \retval true 有効な位置
   * \retval false 無効な位置
   */
  bool validPositionP() const { return !!current_node; }
  /*!
   * 先頭から順に数えた現在位置の数字を得ます。
   * \return 現在位置の数字,先頭は1から始まります。
   */
  Size getPosition() const;
  /*!
   * イタレーションが終了しているかどうかを調べます。
   * \retval true 終了
   * \retval false まだ終了していない
   */
  bool eofP() const { return !validPositionP(); }
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_NodeIterator_h */
