﻿// $Id$

#ifndef INCLUDE_ccc_xml_NodeList_h
#define INCLUDE_ccc_xml_NodeList_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * The NodeList interface provides the abstraction of an ordered
 * collection of nodes, without defining or constraining how this
 * collection is implemented. NodeList objects in the DOM are live.
 *
 * The items in the NodeList are accessible via an integral index,
 * starting from 0.
 *
 * NodeListの実装方法として以前はNDLinkList<Node>から派生したクラス
 * としていました(Node内にリストの前/次要素のポインタを格納する方法)。
 * DOM2で問い合わせ結果としてNodeListを返すメソッドが追加されたため
 * この部分の実装をListProxy<Node>として仮想化しました。
 */
class NodeList
  : public ListProxy<Node>
{
 public:
  /*!
   * Returns the indexth item in the collection. If index is greater
   * than or equal to the number of nodes in the list, this returns null.
   *
   * \param index Index into the collection.
   *
   * \return The node at the indexth position in the NodeList,
   *	or null if that is not a valid index.
   */
  Node* item(CCC_IN unsigned long index) const;
  /*!
   * The number of nodes in the list. The range of valid child node
   * indices is 0 to length-1 inclusive.
   */
  Size getLength() const;
  /*!
   * (CODEX original)<br>
   * \ja
   * コンストラクタ
   * \ja_end
   * \en
   * Constructor.
   * \en_end
   */
  NodeList();
  /*!
   * (CODEX original)<br>
   * \ja
   * デストラクタ
   * \ja_end
   * \en
   * Destructor.
   * \en_end
   */
  ~NodeList();
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_NodeList_h */
