﻿// $Id$

#include <ccc/xml/dom.h>

using namespace CCC;

// CODEX
Notation::Notation(Document* document_, CCC_IN const DOMString* declard_name)
 : External(document_, 0, Node::NOTATION_NODE)	// NOTE: Notation doesn't have parent. (DOM 1 specification)
{
  setNodeName(declard_name);
}

Notation::Notation(Document* document_, CCC_IN const DOMString& declard_name)
 : External(document_, 0, Node::NOTATION_NODE)	// NOTE: Notation doesn't have parent. (DOM 1 specification)
{
  setNodeName(declard_name);
}

Notation::Notation(const Notation& ref)
  : External((External&)ref)
{
  setNodeName(ref.getNodeName());
}

Notation::~Notation()
{
}

Node*
Notation::cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException)
{
  Notation* notation = new Notation(*this);
  return notation;
}
