﻿// $Id$

#ifndef INCLUDE_ccc_xml_Notation_h
#define INCLUDE_ccc_xml_Notation_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * This interface represents a notation declared in the DTD. A notation
 * either declares, by name, the format of an unparsed entity (see section
 * 4.7 of the XML 1.0 specification [XML]), or is used for formal declaration
 * of processing instruction targets (see section 2.6 of the XML 1.0
 * specification [XML]). The nodeName attribute inherited from Node is set to
 * the declared name of the notation.
 *
 * The DOM Level 1 does not support editing Notation nodes; they are
 * therefore readonly.
 *
 * A Notation node does not have any parent.
 */
class Notation
  : public External
{
 public:
  /*!
   * (CODEX original)<br>
   * ノードを複製します。
   * \param deep deep copyするかどうかのフラグ
   * \return 複製されたノード
   */
  virtual Node* cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException);
  /*!
   * Introduced in DOM Level 2:<br>
   * The public identifier of the external subset.
   */
  //const DOMString* getPublicId() const { return External::getPublidId(); }
  /*!
   * Introduced in DOM Level 2:<br>
   * The system identifier of the external subset.
   */
  //const DOMString* getSystemId() const { return External::getSystemId(); }
  /*!
   * (CODEX original)<br>
   * コンストラクタ
   * \param document Document
   * \param declard_name 名前
   */
  Notation(Document* document, CCC_IN const DOMString* declard_name);
  Notation(Document* document, CCC_IN const DOMString& declard_name);
  /*!
   * (CODEX original)<br>
   * コピーコンストラクタ
   * \param notation コピー元
   */
  Notation(const Notation& notation);
  /*!
   * (CODEX original)<br>
   * デストラクタ
   */
  ~Notation();
  /*!
   * (CODEX original)<br>
   * XMLをストリームに書き出します。
   * \param xo 出力先
   */
  virtual void writeXml(XMLOutputter* xo) const CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_Notation_h */
