﻿// $Id$

#include <ccc/xml/dom.h>

using namespace CCC;

const void
ProcessingInstruction::setData(DOMString* data_) CCC_RAISES(DOMException)
{
  node_value.assign(data_);
}

ProcessingInstruction::ProcessingInstruction(Document* document_, Node* parent_,
					     CCC_IN const DOMString* target_, CCC_IN const DOMString* data_)
 : Node(document_, parent_, Node::PROCESSING_INSTRUCTION_NODE)
{
  setNodeName(target_);
  node_value.assign(data_);
}

ProcessingInstruction::ProcessingInstruction(Document* document_, Node* parent_,
					     CCC_IN const DOMString& target_, CCC_IN const DOMString& data_)
 : Node(document_, parent_, Node::PROCESSING_INSTRUCTION_NODE)
{
  setNodeName(target_);
  node_value.assign(data_);
}

ProcessingInstruction::ProcessingInstruction(const ProcessingInstruction& processing_instruction)
 : Node(processing_instruction.getOwnerDocument(), 0, Node::PROCESSING_INSTRUCTION_NODE)
{
  setNodeName(processing_instruction.getNodeName());
  node_value.assign(processing_instruction.node_value);
}

ProcessingInstruction::~ProcessingInstruction()
{
}

Node*
ProcessingInstruction::cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException)
{
  ProcessingInstruction* processing_instruction = new ProcessingInstruction(*this);
  return processing_instruction;
}
