﻿// $Id$

#ifndef INCLUDE_ccc_xml_ProcessingInstruction_h
#define INCLUDE_ccc_xml_ProcessingInstruction_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * The ProcessingInstruction interface represents a "processing instruction",
 * used in XML as a way to keep processor-specific information in the text of
 * the document.
 */
class ProcessingInstruction
  : public Node
{
 public:
  /*!
   * The target of this processing instruction. XML defines this as
   * being the first token following the markup that begins the
   * processing instruction.
   */
  const DOMString* getTarget() const { return getNodeName(); }
  /*!
   * The content of this processing instruction. This is from the first
   * non white space character after the target to the character
   * immediately preceding the ?\>.
   */
  const DOMString* getData() const { return getNodeValue(); }
  /*!
   * \exception NO_MODIFICATION_ALLOWED_ERR Raised when the node is readonly.
   */
  const void setData(DOMString* data) CCC_RAISES(DOMException);
  /*!
   * (CODEX original)<br>
   * ノードを複製します。
   * \param deep deep copyするかどうかのフラグ
   * \return 複製されたノード
   */
  virtual Node* cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException);
  // (CODEX original)
  ProcessingInstruction(Document* document_, Node* parent_, CCC_IN const DOMString* target_, CCC_IN const DOMString* data_);
  ProcessingInstruction(Document* document_, Node* parent_, CCC_IN const DOMString& target_, CCC_IN const DOMString& data_);
  ProcessingInstruction(const ProcessingInstruction& processing_instruction);
  ~ProcessingInstruction();
  /*!
   * (CODEX original)<br>
   * XMLをストリームに書き出します。
   * \param xo 出力先
   */
  virtual void writeXml(XMLOutputter* xo) const CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_ProcessingInstruction_h */
