﻿#line 1 "Text.upp"
#include <ccc/xml/dom.h>

using namespace CCC;

Text*
Text::splitText(CCC_IN unsigned long offset) CCC_RAISES(DOMException)
{
  if (offset <= node_value.getLength())
  {
    return 0;
  }
  DOMSubString ss(node_value, offset, node_value.getLength() - offset);
  Text* ret = new Text(getOwnerDocument(), getParentNode(), (DOMString*)0);
  ret->node_value.assign(ss);
  node_value.remove(offset, node_value.getLength() - offset);
  return ret;
}

Node*
Text::cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException)
{
  Text* new_text = new Text(*this);
  new_text->node_value.assign(node_value);
  return new_text;
}

// CODEX
static DOMChar text_node_name[] = { 0x23 /* # */, 0x74 /* t */, 0x65 /* e */, 0x78 /* x */, 0x74 /* t */, 0x00, };

Text::Text(Document* document_, Node* parent_, CCC_IN const DOMString* value_)
 : CharacterData(document_, parent_, Node::TEXT_NODE)
{
  setNodeName(text_node_name);
  if (value_)
  {
    node_value.assign(*value_);
  }
}

Text::Text(Document* document_, Node* parent_, CCC_IN const DOMString& value_)
 : CharacterData(document_, parent_, Node::TEXT_NODE)
{
  setNodeName(text_node_name);
  node_value.assign(value_);
}

Text::Text(Document* document_, Node* parent_, CCC_IN const DOMChar* value_)
 : CharacterData(document_, parent_, Node::TEXT_NODE)
{
  setNodeName(text_node_name);
  if (value_)
  {
    node_value.assign(value_);
  }
}

Text::Text(Document* document_, Node* parent_, CCC_IN const DOMChar* value_, Size value_length)
 : CharacterData(document_, parent_, Node::TEXT_NODE)
{
  setNodeName(text_node_name);
  if (value_)
  {
    node_value.assign(value_, value_length);
  }
}

Text::Text(const Text& text)
 : CharacterData(text.getOwnerDocument(), 0, Node::TEXT_NODE)
{
  setNodeName(text_node_name);
  node_value.assign(text.node_value);
}

Text::~Text()
{
}
