﻿// $Id$

#ifndef INCLUDE_ccc_xml_Text_h
#define INCLUDE_ccc_xml_Text_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * The Text interface inherits from CharacterData and represents the textual
 * content (termed character data in XML) of an Element or Attr. If there is
 * no markup inside an element's content, the text is contained in a single
 * object implementing the Text interface that is the only child of the
 * element. If there is markup, it is parsed into the information items
 * (elements, comments, etc.) and Text nodes that form the list of children
 * of the element.
 *
 * When a document is first made available via the DOM, there is only one
 * Text node for each block of text. Users may create adjacent Text nodes
 * that represent the contents of a given element without any intervening
 * markup, but should be aware that there is no way to represent the
 * separations between these nodes in XML or HTML, so they will not (in
 * general) persist between DOM editing sessions. The normalize() method on
 * Node merges any such adjacent Text objects into a single node for each
 * block of text.
 */
class Text
  : public CharacterData
{
 public:
  /*!
   * Breaks this node into two nodes at the specified offset, keeping
   * both in the tree as siblings. After being split, this node will
   * contain all the content up to the offset point. A new node of the
   * same type, which contains all the content at and after the offset
   * point, is returned. If the original node had a parent node, the
   * new node is inserted as the next sibling of the original node.
   * When the offset is equal to the length of this node, the new node
   * has no data.
   *
   * \param offset
   *	The 16-bit unit offset at which to split, starting from 0.
   *
   * \return The new node, of the same type as this node.
   *
   * \exception INDEX_SIZE_ERR Raised if the specified offset is
   *	negative or greater than the number of 16-bit units in data.
   * \exception NO_MODIFICATION_ALLOWED_ERR Raised if this node is readonly.
   */
  Text* splitText(CCC_IN unsigned long offset) CCC_RAISES(DOMException);
  /*!
   * (CODEX original)<br>
   * ノードを複製します。
   * \param deep deep copyするかどうかのフラグ
   * \return 複製されたノード
   */
  virtual Node* cloneNode(CCC_IN bool deep) const CCC_RAISES(DOMException);
  /*!
   * (CODEX original)<br>
   * コンストラクタ
   * \param document_ Document
   * \param parent_ 親ノード
   * \param value ノード値
   */
  Text(Document* document_, Node* parent_, CCC_IN const DOMString* value);
  Text(Document* document_, Node* parent_, CCC_IN const DOMString& value);
  Text(Document* document_, Node* parent_, CCC_IN const DOMChar* value);
  /*!
   * (CODEX original)<br>
   * コンストラクタ
   * \param document_ Document
   * \param parent_ 親ノード
   * \param value ノード値
   * \param value_length ノード値の長さ
   */
  Text(Document* document_, Node* parent_, CCC_IN const DOMChar* value, Size value_length);
  /*!
   * (CODEX original)<br>
   * コピーコンストラクタ
   * \param text コピー元
   */
  Text(const Text& text);
  /*!
   * (CODEX original)<br>
   * デストラクタ
   */
  ~Text();
  /*!
   * (CODEX original)<br>
   * XMLをストリームに書き出します。
   * \param xo 出力先
   */
  virtual void writeXml(XMLOutputter* xo) const CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_Text_h */
