﻿// $Id$

#include <ccc/xml/XLog.h>

CCC_NAMESPACE_START(CCC);

XLog::XLog()
{
  d_str = new DOMString();
  oflow = new StringOFlow<DOMChar>(d_str);
  text_writer = new TextWriter<DOMChar>(oflow);
}

XLog::~XLog()
{
  delete text_writer;
  delete oflow;
  delete d_str;
}

void
XLog::clear()
{
  text_writer->rewind();
  oflow->flush();
  d_str->clear();
}

void
XLog::getUtf8Result(BString* result)
{
  CCC::Iceman::convertToBString(CCC_DOM_CEID, CEID_UTF8N, d_str, result);
}

void
XLog::getResult(CeId ceid, BString* result)
{
  CCC::Iceman::convertToBString(CCC_DOM_CEID, ceid, d_str, result);
}

void
XLog::getResult(CeId ceid, DString* result)
{
  CCC::Iceman::convertToDString(CCC_DOM_CEID, ceid, d_str, result);
}

void
XLog::getResult(CeId ceid, WString* result)
{
  CCC::Iceman::convertToWString(CCC_DOM_CEID, ceid, d_str, result);
}

CCC_NAMESPACE_END(CCC);


