﻿// $Id$

#ifndef INCLUDE_ccc_xml_XLog_h
#define INCLUDE_ccc_xml_XLog_h

#include <ccc/base/StringOFlow.h>
#include <ccc/base/TextWriter.h>
#include <ccc/iceman/Iceman.h>
#include <ccc/xml/DOMString.h>

CCC_NAMESPACE_START(CCC);

/*!
 * TextWriter<DOMChar>ログとして使用するメソッドを
 * 使いやすくするためのクラスです。
 * 実行後に、指定の文字コードによる結果文字列を取得できます。
 */
class XLog
{
  /*!
   * 出力される文字列情報を保持します。
   */
  DOMString* d_str;
  /*!
   * 文字列に書き出すための出力フロー
   */
  StringOFlow<DOMChar>* oflow;
  /*!
   * テキストライター
   */
  TextWriter<DOMChar>* text_writer;
 public:
  /*!
   * コンストラクタ
   */
  XLog();
  /*!
   * デストラクタ
   */
  ~XLog();
  /*!
   * ログの内容を空にします。
   */
  void clear();
  /*!
   * テキストライターを取得します。
   * \return テキストライター
   */
  TextWriter<CCC::DOMChar>* textWriter() { return text_writer; };
  /*!
   * UTF8の出力結果を得ます。
   * \param result 設定先
   */
  void getUtf8Result(CCC::BString* result);
  /*!
   * 指定エンコーディングの出力結果を得ます。
   * \param ceid エンコーディング
   * \param result 設定先
   */
  void getResult(CeId ceid, BString* result);
  /*!
   * 指定エンコーディングの出力結果を得ます。
   * \param ceid エンコーディング
   * \param result 設定先
   */
  void getResult(CeId ceid, DString* result);
  /*!
   * 指定エンコーディングの出力結果を得ます。
   * \param ceid エンコーディング
   * \param result 設定先
   */
  void getResult(CeId ceid, WString* result);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_XLog_h */
