﻿// $Id$

#include <ccc/xml/XMLChecker.h>
#include <ccc/file/FileIFlow.h>

CCC_NAMESPACE_START(CCC);

static bool
imgMatch(UInt8* a, UInt8* b, size_t len)
{
  while (len > 0)
  {
    if (*a++ != *b++)
    {
      return false;
    }
    len--;
  }
  return true;
}

bool
XMLChecker::checkFlow(IFlow* iflow)
{
  static UInt8 ascii[]       = { 0x3c, 0x3f, 0x78, 0x6d, 0x6c };
  static UInt8 utf8_bom[]    = { 0xef, 0xbb, 0xbf, 0x3c, 0x3f, 0x78, 0x6d, 0x6c };
  static UInt8 utf16be[]     = { 0x00, 0x3c, 0x00, 0x3f, 0x00, 0x78, 0x00, 0x6d, 0x00, 0x6c };
  static UInt8 utf16le[]     = { 0x3c, 0x00, 0x3f, 0x00, 0x78, 0x00, 0x6d, 0x00, 0x6c, 0x00 };
  static UInt8 utf16be_bom[] = { 0xfe, 0xff, 0x00, 0x3c, 0x00, 0x3f, 0x00, 0x78, 0x00, 0x6d, 0x00, 0x6c };
  static UInt8 utf16le_bom[] = { 0xff, 0xfe, 0x3c, 0x00, 0x3f, 0x00, 0x78, 0x00, 0x6d, 0x00, 0x6c, 0x00 };
  static UInt8 utf32le[]     = { 0x3c, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x6d, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00 };
  static UInt8 utf32be[]     = { 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x6d, 0x00, 0x00, 0x00, 0x6c };
  static UInt8 utf32le_bom[] = { 0xff, 0xfe, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x6d, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00 };
  static UInt8 utf32be_bom[] = { 0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x6d, 0x00, 0x00, 0x00, 0x6c };
  struct Pat 
  {
    UInt8* img;
    size_t img_len;
  };
  static Pat pat[] =
  {
    { ascii, sizeof(ascii) },
    { utf8_bom, sizeof(utf8_bom) },
    { utf16be, sizeof(utf16be) },
    { utf16le, sizeof(utf16le) },
    { utf16be_bom, sizeof(utf16be_bom) },
    { utf16le_bom, sizeof(utf16le_bom) },
    { utf32le, sizeof(utf32le) },
    { utf32be, sizeof(utf32be) },
    { utf32le_bom, sizeof(utf32le_bom) },
    { utf32be_bom, sizeof(utf32be_bom) },
    { 0, 0 }
  };

  size_t max_len = 0;
  Pat* xp = pat;
  while (xp->img)
  {
    if (max_len < xp->img_len)
    {
      max_len = xp->img_len;
    }
    xp++;
  }
  UInt8* img = new UInt8[max_len];
  bool ret_p = false;
  try
  {
    xp = pat;
    size_t read_len = 0;
    while (xp->img)
    {
      while (read_len < xp->img_len)
      {
	img[read_len++] = (UInt8)iflow->getInt8();
      }
      if (imgMatch(xp->img, img, xp->img_len))
      {
	ret_p = true;
	break;
      }
      xp++;
    }
  }
  catch (IOException* ioe)
  {
    ret_p = false;
  }
  delete [] img;
  return ret_p;
}

bool
XMLChecker::checkFile(const char* path)
{
  FileIFlow iflow;
  if (!iflow.open(path, true))
  {
    // open error
    return false;
  }
  return XMLChecker::checkFlow(&iflow);
}

CCC_NAMESPACE_END(CCC);
