﻿// $Id$

#ifndef INCLUDE_ccc_xml_XMLChecker_h
#define INCLUDE_ccc_xml_XMLChecker_h

#include <ccc/base/IFlow.h>

CCC_NAMESPACE_START(CCC);

class XMLChecker
{
 public:
  /*!
   * This method checks the input flow is XML or not.
   * \param iflow input flow.
   * \retval true input flow is XML.
   * \retval false input flow is not XML.
   */
  static bool checkFlow(IFlow* iflow);
  /*!
   * This method checks an input file is XML or not.
   * \param path the path of the file.
   * \retval true the file is XML.
   * \retval false the file is not XML.
   */
  static bool checkFile(const char* path);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_XMLChecker_h */
