﻿// $Id$

#include <ccc/xml/dom.h>
#include <ccc/xml/XMLParser.h>
#include <ccc/base/cstring.h>

CCC_NAMESPACE_START(CCC);

XMLOutputter::XMLOutputter(OFlow* of, Option o)
{
  XMLOutputter::of = of;
  option = o;
}

XMLOutputter::~XMLOutputter()
{
}

void
XMLOutputter::putChar(DOMChar c) CCC_RAISES(IOException)
{
#ifdef CCC_SINGLE_BYTE_DOM_STRING
  of->putInt8(c);
#else /* CCC_SINGLE_BYTE_DOM_STRING */
  of->putUInt16(c);
#endif /* CCC_SINGLE_BYTE_DOM_STRING */
}

void
XMLOutputter::print(const DOMChar* s) CCC_RAISES(IOException)
{
  Size len = strLen(s);
  Size put_size = 0;
#ifdef CCC_SINGLE_BYTE_DOM_STRING
  of->putInt8Block(len, s, put_size);
#else /* CCC_SINGLE_BYTE_DOM_STRING */
  of->putUInt16Block(len, s, put_size);
#endif /* CCC_SINGLE_BYTE_DOM_STRING */
}

void
XMLOutputter::print(const DOMString* s) CCC_RAISES(IOException)
{
  Size put_size = 0;
#ifdef CCC_SINGLE_BYTE_DOM_STRING
  of->putInt8Block(s->getLength(), s->getStartPtr(), put_size);
#else /* CCC_SINGLE_BYTE_DOM_STRING */
  of->putUInt16Block(s->getLength(), s->getStartPtr(), put_size);
#endif /* CCC_SINGLE_BYTE_DOM_STRING */
}

void
XMLOutputter::escPrint(const DOMString* s) CCC_RAISES(IOException)
{
  DOMChar* p = s->getStartPtr();
  DOMChar* end = p + s->getLength();
  if (option & ENTITY_REPLACEING_REVERTING)
  {
    while (p < end)
    {
      EntityReplacement* er = XMLToken::basic_entity_src;
      while (er->esc)
      {
	if (*p == er->src)
	{
	  break; 	// HIT
	}
	er++;
      }
      if (er->src)
      {
	print(er->esc);
      }
      else
      {
	putChar(*p);
      }
      p++;
    }
  }
  else
  {
    while (p < end)
    {
      EntityReplacement* er = XMLToken::basic_entity;
      while (er->esc)
      {
	if (*p == er->src)
	{
	  break; 	// HIT
	}
	er++;
      }
      if (er->src)
      {
	putChar((DOMChar)'&');
	print(er->esc);
	putChar((DOMChar)';');
      }
      else
      {
	putChar(*p);
      }
      p++;
    }
  }
}

CCC_NAMESPACE_END(CCC);
