﻿// $Id$

#ifndef INCLUDE_ccc_xml_XMLOutputter_h
#define INCLUDE_ccc_xml_XMLOutputter_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * (CODEX original)<br>
 * XMLの出力用に使用するクラスです。
 */
class XMLOutputter
{
 public:
  /*!
   * 出力オプション
   */
  enum Option
  {
    /*!
     * オプション無し
     */
    OPTION_NONE = 0x00,
    /*!
     * デバック用オプション
     */
    OPTION_DEBUG = 0x01,
    /* !
     * インデントオプション
     */
    //OPTION_INDENT = 0x02,
    /*!
     * (&を0x01, ;を0x02)に置換されたエンティティを元の表現に戻します。
     * 参照: XMLParser::ENTITY_REPLACING オプション
     */
    ENTITY_REPLACEING_REVERTING = 0x04,
    /*!
     * 空要素タグの出力時に/の前に空白を出力します。
     */
    OUTPUT_SPACE_BEFORE_EMPTY_ELEM_TAG = 0x08,
    /*!
     * XML宣言の終わりの?の前にスペースを出力しません。
     */
    DONT_OUTPUT_SPACE_BEFORE_XML_DECL_END = 0x10,
#ifndef CODEX_PURE_DOM
    /*!
     * 子要素が空の場合に冗長表現にするか、短縮表現にするかを
     * Nodeに保存されている情報を元にして動的に出力表現を変えます。
     */
    USE_REDUNDANT_EMPTY_TAG_EXPRESSION_CONTROL = 0x20,
#endif /* CODEX_PURE_DOM */
  };
 private:
  /*!
   * 出力用フロー
   */
  OFlow* of;
  /*!
   * 出力オプション
   */
  int option;
 public:
  /*!
   * コンストラクタ
   * \param of 出力先フロー
   * \param o オプション
   */
  XMLOutputter(OFlow* of, Option o = OPTION_NONE);
  /*!
   * デストラクタ
   */
  virtual ~XMLOutputter();
  /*!
   * 1文字出力します。
   * \param c 出力する文字
   */
  virtual void putChar(DOMChar c) CCC_RAISES(IOException);
  /*!
   * ヌルで終端された文字列を出力します。
   * \param s 出力する文字列
   */
  virtual void print(const DOMChar* s) CCC_RAISES(IOException);
  /*!
   * DOMStringの文字列を出力します。
   * \param s 出力する文字列
   */
  virtual void print(const DOMString* s) CCC_RAISES(IOException);
  /*!
   * DOMStringの文字列を出力しますが、XMLで必ず実体参照表現に変換する
   * 必要のある\&\<\>\\'"などの文字は実体参照表現にて出力します。
   * \param s 出力する文字列
   */
  virtual void escPrint(const DOMString* s) CCC_RAISES(IOException);
  /*!
   * 出力オプションを設定します。
   * \param o 出力オプションフラグ
   */
  void setOption(int o) { option = o; }
  /*!
   * 出力オプションを得ます。
   * \return 出力オプション
   */
  int getOption() { return option; }
  /*!
   * 指定した出力オプションが指定されているかどうかを取得します。
   * \retval true 指定されています。
   * \retval false 指定されていません。
   */
  bool optionSetP(Option o) { return ((option & o) != 0); }
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_XMLOutputter_h */
