﻿// $Id$

#ifndef INCLUDE_ccc_xml_XMLParseError_h
#define INCLUDE_ccc_xml_XMLParseError_h

#include <ccc/base/base.h>
#include <ccc/xml/config.h>

CCC_NAMESPACE_START(CCC);

/*!
 * \ja
 * XMLパーサのエラー処理用クラス
 * \ja_end
 * \en
 * XML Parser error handling class
 * \en_end
 */
class XMLParseError
{
  const char* s;
  int num;
 public:
  /*!
   * \ja
   * コンストラクタ
   * \param num エラー番号
   * \param s エラーメッセージ
   * \ja_end
   * \en
   * Constructor.
   * \param num Error number.
   * \param s Error description.
   * \en_end
   */
  XMLParseError(int num, const char* s)
  {
    XMLParseError::num = num;
    XMLParseError::s = s;
  }
  /*!
   * \ja
   * エラーメッセージを取得します。
   * \return エラーメッセージ
   * \ja_end
   */
  const char* getErrorString() { return s; }
  /*!
   * \ja
   * エラー番号を取得します。
   * \return エラー番号
   * \ja_end
   */
  int getErrorNumber() { return num; }
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_ccc_xml_XMLParseError_h */
