﻿#line 1 "XMLParser.upp"
// strict XML Parser

#include <stdio.h>

#include <ccc/xml/dom.h>
#include <ccc/xml/XMLParser.h>
#include <ccc/xml/XMLParserSrc.h>
#include <ccc/xml/XMLReader.h>
#include <ccc/base/cstring.h>

using namespace CCC;

// ------------------------------------------------------------------------
// class XMLTokens

DOMChar XMLToken::str_xmldecl_start[] = { 0x3c /* < */, 0x3f /* ? */, 0x78 /* x */, 0x6d /* m */, 0x6c /* l */, 0x00, };
DOMChar XMLToken::str_xmldecl_end[] = { 0x3f /* ? */, 0x3e /* > */, 0x00, };
DOMChar XMLToken::str_quote[] = { 0x27 /* ' */, 0x00, };
DOMChar XMLToken::str_dquote[] = { 0x22 /* \" */, 0x00, };
DOMChar XMLToken::str_eq[] = { 0x3d /* = */, 0x00, };
DOMChar XMLToken::str_open[] = { 0x3c /* < */, 0x00, };
DOMChar XMLToken::str_close[] = { 0x3e /* > */, 0x00, };
DOMChar XMLToken::str_openbr[] = { 0x28 /* ( */, 0x00, };
DOMChar XMLToken::str_closebr[] = { 0x29 /* ) */, 0x00, };
DOMChar XMLToken::str_question[] = { 0x3f /* ? */, 0x00, };
DOMChar XMLToken::str_aster[] = { 0x2a /* * */, 0x00, };
DOMChar XMLToken::str_plus[] = { 0x2b /* + */, 0x00, };
DOMChar XMLToken::str_or[] = { 0x7c /* | */, 0x00, };
DOMChar XMLToken::str_seq[] = { 0x2c /* , */, 0x00, };
DOMChar XMLToken::str_percent[] = { 0x25 /* % */, 0x00, };
DOMChar XMLToken::str_semicol[] = { 0x3b /* ; */, 0x00, };
DOMChar XMLToken::str_markupdecl_start[] = { 0x5b /* [ */, 0x00, };
DOMChar XMLToken::str_markupdecl_end[] = { 0x5d /* ] */, 0x00, };
DOMChar XMLToken::str_cond_start[] = { 0x3c /* < */, 0x21 /* ! */, 0x5b /* [ */, 0x00, };
DOMChar XMLToken::str_cond_end[] = { 0x5d /* ] */, 0x5d /* ] */, 0x3e /* > */, 0x00, };
DOMChar XMLToken::str_and[] = { 0x26 /* & */, 0x00, };
DOMChar XMLToken::str_sharp[] = { 0x23 /* # */, 0x00, };
DOMChar XMLToken::str_x[] = { 0x78 /* x */, 0x00, };
DOMChar XMLToken::str_version[] = { 0x76 /* v */, 0x65 /* e */, 0x72 /* r */, 0x73 /* s */, 0x69 /* i */, 0x6f /* o */, 0x6e /* n */, 0x00, };
DOMChar XMLToken::str_encoding[] = { 0x65 /* e */, 0x6e /* n */, 0x63 /* c */, 0x6f /* o */, 0x64 /* d */, 0x69 /* i */, 0x6e /* n */, 0x67 /* g */, 0x00, };
DOMChar XMLToken::str_standalone[] = { 0x73 /* s */, 0x74 /* t */, 0x61 /* a */, 0x6e /* n */, 0x64 /* d */, 0x61 /* a */, 0x6c /* l */, 0x6f /* o */, 0x6e /* n */, 0x65 /* e */, 0x00, };
DOMChar XMLToken::str_yes[] = { 0x79 /* y */, 0x65 /* e */, 0x73 /* s */, 0x00, };
DOMChar XMLToken::str_no[] = { 0x6e /* n */, 0x6f /* o */, 0x00, };
DOMChar XMLToken::str_comment_start[] = { 0x3c /* < */, 0x21 /* ! */, 0x2d /* - */, 0x2d /* - */, 0x00, };
DOMChar XMLToken::str_comment_end[] = { 0x2d /* - */, 0x2d /* - */, 0x3e /* > */, 0x00, };
DOMChar XMLToken::str_pi_start[] = { 0x3c /* < */, 0x3f /* ? */, 0x00, };
DOMChar XMLToken::str_pi_end[] = { 0x3f /* ? */, 0x3e /* > */, 0x00, };
DOMChar XMLToken::str_doctype_start[] = { 0x3c /* < */, 0x21 /* ! */, 0x44 /* D */, 0x4f /* O */, 0x43 /* C */, 0x54 /* T */, 0x59 /* Y */, 0x50 /* P */, 0x45 /* E */, 0x00, };
DOMChar XMLToken::str_externalidsystem[] = { 0x53 /* S */, 0x59 /* Y */, 0x53 /* S */, 0x54 /* T */, 0x45 /* E */, 0x4d /* M */, 0x00, };
DOMChar XMLToken::str_externalidpublic[] = { 0x50 /* P */, 0x55 /* U */, 0x42 /* B */, 0x4c /* L */, 0x49 /* I */, 0x43 /* C */, 0x00, };
DOMChar XMLToken::str_element_start[] = { 0x3c /* < */, 0x21 /* ! */, 0x45 /* E */, 0x4c /* L */, 0x45 /* E */, 0x4d /* M */, 0x45 /* E */, 0x4e /* N */, 0x54 /* T */, 0x00, };
DOMChar XMLToken::str_empty[] = { 0x45 /* E */, 0x4d /* M */, 0x50 /* P */, 0x54 /* T */, 0x59 /* Y */, 0x00, };
DOMChar XMLToken::str_any[] = { 0x41 /* A */, 0x4e /* N */, 0x59 /* Y */, 0x00, };
DOMChar XMLToken::str_pcdata[] = { 0x23 /* # */, 0x50 /* P */, 0x43 /* C */, 0x44 /* D */, 0x41 /* A */, 0x54 /* T */, 0x41 /* A */, 0x00, };
DOMChar XMLToken::str_attlist_start[] = { 0x3c /* < */, 0x21 /* ! */, 0x41 /* A */, 0x54 /* T */, 0x54 /* T */, 0x4c /* L */, 0x49 /* I */, 0x53 /* S */, 0x54 /* T */, 0x00, };
DOMChar XMLToken::str_cdata[] = { 0x43 /* C */, 0x44 /* D */, 0x41 /* A */, 0x54 /* T */, 0x41 /* A */, 0x00, };
DOMChar XMLToken::str_id[] = { 0x49 /* I */, 0x44 /* D */, 0x00, };
DOMChar XMLToken::str_idref[] = { 0x49 /* I */, 0x44 /* D */, 0x52 /* R */, 0x45 /* E */, 0x46 /* F */, 0x00, };
DOMChar XMLToken::str_idrefs[] = { 0x49 /* I */, 0x44 /* D */, 0x52 /* R */, 0x45 /* E */, 0x46 /* F */, 0x53 /* S */, 0x00, };
DOMChar XMLToken::str_entity[] = { 0x45 /* E */, 0x4e /* N */, 0x54 /* T */, 0x49 /* I */, 0x54 /* T */, 0x59 /* Y */, 0x00, };
DOMChar XMLToken::str_entities[] = { 0x45 /* E */, 0x4e /* N */, 0x54 /* T */, 0x49 /* I */, 0x54 /* T */, 0x49 /* I */, 0x45 /* E */, 0x53 /* S */, 0x00, };
DOMChar XMLToken::str_nmtoken[] = { 0x4e /* N */, 0x4d /* M */, 0x54 /* T */, 0x4f /* O */, 0x4b /* K */, 0x45 /* E */, 0x4e /* N */, 0x00, };
DOMChar XMLToken::str_nmtokens[] = { 0x4e /* N */, 0x4d /* M */, 0x54 /* T */, 0x4f /* O */, 0x4b /* K */, 0x45 /* E */, 0x4e /* N */, 0x53 /* S */, 0x00, };
DOMChar XMLToken::str_notation[] = { 0x4e /* N */, 0x4f /* O */, 0x54 /* T */, 0x41 /* A */, 0x54 /* T */, 0x49 /* I */, 0x4f /* O */, 0x4e /* N */, 0x00, };
DOMChar XMLToken::str_required[] = { 0x23 /* # */, 0x52 /* R */, 0x45 /* E */, 0x51 /* Q */, 0x55 /* U */, 0x49 /* I */, 0x52 /* R */, 0x45 /* E */, 0x44 /* D */, 0x00, };
DOMChar XMLToken::str_implied[] = { 0x23 /* # */, 0x49 /* I */, 0x4d /* M */, 0x50 /* P */, 0x4c /* L */, 0x49 /* I */, 0x45 /* E */, 0x44 /* D */, 0x00, };
DOMChar XMLToken::str_fixed[] = { 0x23 /* # */, 0x46 /* F */, 0x49 /* I */, 0x58 /* X */, 0x45 /* E */, 0x44 /* D */, 0x00, };
DOMChar XMLToken::str_entity_start[] = { 0x3c /* < */, 0x21 /* ! */, 0x45 /* E */, 0x4e /* N */, 0x54 /* T */, 0x49 /* I */, 0x54 /* T */, 0x59 /* Y */, 0x00, };
DOMChar XMLToken::str_ndata[] = { 0x4e /* N */, 0x44 /* D */, 0x41 /* A */, 0x54 /* T */, 0x41 /* A */, 0x00, };
DOMChar XMLToken::str_notation_start[] = { 0x3c /* < */, 0x21 /* ! */, 0x4e /* N */, 0x4f /* O */, 0x54 /* T */, 0x41 /* A */, 0x54 /* T */, 0x49 /* I */, 0x4f /* O */, 0x4e /* N */, 0x00, };
DOMChar XMLToken::str_empclose[] = { 0x2f /* / */, 0x3e /* > */, 0x00, };
DOMChar XMLToken::str_etag[] = { 0x3c /* < */, 0x2f /* / */, 0x00, };
DOMChar XMLToken::str_cdata_start[] = { 0x3c /* < */, 0x21 /* ! */, 0x5b /* [ */, 0x43 /* C */, 0x44 /* D */, 0x41 /* A */, 0x54 /* T */, 0x41 /* A */, 0x5b /* [ */, 0x00, };
DOMChar XMLToken::str_cdata_end[] = { 0x5d /* ] */, 0x5d /* ] */, 0x3e /* > */, 0x00, };
DOMChar XMLToken::str_include[] = { 0x49 /* I */, 0x4e /* N */, 0x43 /* C */, 0x4c /* L */, 0x55 /* U */, 0x44 /* D */, 0x45 /* E */, 0x00, };
DOMChar XMLToken::str_ignore[] = { 0x49 /* I */, 0x47 /* G */, 0x4e /* N */, 0x4f /* O */, 0x52 /* R */, 0x45 /* E */, 0x00, };
DOMChar XMLToken::str_null[] = { 0x00, };
DOMChar XMLToken::str_sp[] = { 0x20 /*   */, 0x00, };
DOMChar XMLToken::str_lt[] = { 0x6c /* l */, 0x74 /* t */, 0x00, };
DOMChar XMLToken::str_gt[] = { 0x67 /* g */, 0x74 /* t */, 0x00, };
DOMChar XMLToken::str_amp[] = { 0x61 /* a */, 0x6d /* m */, 0x70 /* p */, 0x00, };
DOMChar XMLToken::str_apos[] = { 0x61 /* a */, 0x70 /* p */, 0x6f /* o */, 0x73 /* s */, 0x00, };
DOMChar XMLToken::str_quot[] = { 0x71 /* q */, 0x75 /* u */, 0x6f /* o */, 0x74 /* t */, 0x00, };
DOMChar XMLToken::str_xml[] = { 0x78 /* x */, 0x6d /* m */, 0x6c /* l */, 0x00, };
DOMChar XMLToken::str_xml_uri[] = { 0x68 /* h */, 0x74 /* t */, 0x74 /* t */, 0x70 /* p */, 0x3a /* : */, 0x2f /* / */, 0x2f /* / */, 0x77 /* w */, 0x77 /* w */, 0x77 /* w */, 0x2e /* . */, 0x77 /* w */, 0x33 /* 3 */, 0x2e /* . */, 0x6f /* o */, 0x72 /* r */, 0x67 /* g */, 0x2f /* / */, 0x58 /* X */, 0x4d /* M */, 0x4c /* L */, 0x2f /* / */, 0x31 /* 1 */, 0x39 /* 9 */, 0x39 /* 9 */, 0x38 /* 8 */, 0x2f /* / */, 0x6e /* n */, 0x61 /* a */, 0x6d /* m */, 0x65 /* e */, 0x73 /* s */, 0x70 /* p */, 0x61 /* a */, 0x63 /* c */, 0x65 /* e */, 0x00, };
DOMChar XMLToken::str_xmlns[] = { 0x78 /* x */, 0x6d /* m */, 0x6c /* l */, 0x6e /* n */, 0x73 /* s */, 0x00, };
DOMChar XMLToken::str_xmlns_uri[] = { 0x68 /* h */, 0x74 /* t */, 0x74 /* t */, 0x70 /* p */, 0x3a /* : */, 0x2f /* / */, 0x2f /* / */, 0x77 /* w */, 0x77 /* w */, 0x77 /* w */, 0x2e /* . */, 0x77 /* w */, 0x33 /* 3 */, 0x2e /* . */, 0x6f /* o */, 0x72 /* r */, 0x67 /* g */, 0x2f /* / */, 0x32 /* 2 */, 0x30 /* 0 */, 0x30 /* 0 */, 0x30 /* 0 */, 0x2f /* / */, 0x78 /* x */, 0x6d /* m */, 0x6c /* l */, 0x6e /* n */, 0x73 /* s */, 0x2f /* / */, 0x00, };
DOMChar XMLToken::str_xsl[] = { 0x78 /* x */, 0x73 /* s */, 0x6c /* l */, 0x00, };
DOMChar XMLToken::str_xmlns_xsl[] = { 0x78 /* x */, 0x6d /* m */, 0x6c /* l */, 0x6e /* n */, 0x73 /* s */, 0x3a /* : */, 0x78 /* x */, 0x73 /* s */, 0x6c /* l */, 0x00, };
DOMChar XMLToken::str_xmlns_xsl_uri[] = { 0x68 /* h */, 0x74 /* t */, 0x74 /* t */, 0x70 /* p */, 0x3a /* : */, 0x2f /* / */, 0x2f /* / */, 0x77 /* w */, 0x77 /* w */, 0x77 /* w */, 0x2e /* . */, 0x77 /* w */, 0x33 /* 3 */, 0x2e /* . */, 0x6f /* o */, 0x72 /* r */, 0x67 /* g */, 0x2f /* / */, 0x31 /* 1 */, 0x39 /* 9 */, 0x39 /* 9 */, 0x39 /* 9 */, 0x2f /* / */, 0x58 /* X */, 0x53 /* S */, 0x4c /* L */, 0x2f /* / */, 0x54 /* T */, 0x72 /* r */, 0x61 /* a */, 0x6e /* n */, 0x73 /* s */, 0x66 /* f */, 0x6f /* o */, 0x72 /* r */, 0x6d /* m */, 0x00, };
DOMChar XMLToken::str_entity_rep_and[] = { 0x01, 0x00, };
DOMChar XMLToken::str_entity_rep_semicol[] = { 0x02, 0x00, };

EntityReplacement XMLToken::basic_entity[] =
{
  { XMLToken::str_lt, 0x3c /* < */ },
  { XMLToken::str_gt, 0x3e /* > */ },
  { XMLToken::str_amp, 0x26 /* & */ },
  { XMLToken::str_apos, 0x27 /* \' */ },
  { XMLToken::str_quot, 0x22 /* " */ },
  { 0, 0 },
};

// for basic_entity_src
static DOMChar str_lt_src[] = { 0x26 /* & */, 0x6c /* l */, 0x74 /* t */, 0x3b /* ; */, 0x00, };
static DOMChar str_gt_src[] = { 0x26 /* & */, 0x67 /* g */, 0x74 /* t */, 0x3b /* ; */, 0x00, };
static DOMChar str_amp_src[] = { 0x26 /* & */, 0x61 /* a */, 0x6d /* m */, 0x70 /* p */, 0x3b /* ; */, 0x00, };
static DOMChar str_apos_src[] = { 0x26 /* & */, 0x61 /* a */, 0x70 /* p */, 0x6f /* o */, 0x73 /* s */, 0x3b /* ; */, 0x00, };
static DOMChar str_quot_src[] = { 0x26 /* & */, 0x71 /* q */, 0x75 /* u */, 0x6f /* o */, 0x74 /* t */, 0x3b /* ; */, 0x00, };
static DOMChar str_entity_rep_and_src[] = { 0x26 /* & */, 0x00, };
static DOMChar str_entity_rep_semicol_src[] = { 0x3b /* ; */, 0x00, };

EntityReplacement XMLToken::basic_entity_src[] =
{
  { str_lt_src, 0x3c /* < */ },
  { str_gt_src, 0x3e /* > */ },
  { str_amp_src, 0x26 /* & */ },
  { str_apos_src, 0x27 /* \' */ },
  { str_quot_src, 0x22 /* " */ },
  { str_entity_rep_and_src, 0x01 },
  { str_entity_rep_semicol_src, 0x02 },
  { 0, 0 },
};

// ------------------------------------------------------------------------
// class XMLParser
// last used throw XMLParseError : 173

#ifdef CHECK
#undef CHECK
#endif
/*!
 * CHECK is a macro for shortening arguments of the bool XMLParser::check(DOMChar* str, Size len).
 * \param s DOMChar array
 */
#define CHECK(s) acceptCheck(s, (sizeof(s)/sizeof(DOMChar) - 1))

#ifdef CARG
#undef CARG
#endif
/*!
 * CARG is a macro for shortening arguments for some methods.
 * \param s DOMChar array
 */
#define CARG(s) s, (sizeof(s)/sizeof(DOMChar) - 1)

Document*
XMLParser::readXML(DOMString* uri, DOMImplementation* dom_imp, XMLReader* reader, TextWriter<DOMChar>* log, Option option)
{
  bool dom_imp_created_p = false;
  bool xml_reader_created_p = false;
  CCC::Catalog* catalog = 0;
  if (dom_imp == 0)
  {
    dom_imp = new DOMImplementation();
    dom_imp_created_p = true;
  }
  if (log == 0)
  {
#ifdef CCC_SINGLE_BYTE_DOM_STRING
    log = CCC::nulout_w8;
#else /* CCC_SINGLE_BYTE_DOM_STRING */
    log = CCC::nulout_w16;
#endif /* CCC_SINGLE_BYTE_DOM_STRING */
  }
  if (reader == 0)
  {
    CCC::Catalog* catalog = new CCC::Catalog();
    reader = new CCC::XMLReader(catalog, log);
    xml_reader_created_p = true;
  }
  
  Document* doc = 0;
  do
  {
    XMLParser parser(dom_imp, reader, log, option);
    if (!parser.readFromUri(uri))
    {
      // データ読み込みエラー
      break;
    }
    if (!parser.parse())
    {
      // パースエラー
      // validity check エラー
      break;
    }
    doc = parser.getDocument();
  } while (false);

  if (dom_imp_created_p)
  {
    delete dom_imp;
  }
  if (xml_reader_created_p)
  {
    delete catalog;
    delete reader;
  }
  return doc;
}

Document*
XMLParser::readXML(IFlow* in, const DOMString* name, DOMImplementation* dom_imp, XMLReader* reader, TextWriter<DOMChar>* log, Option option)
{
  bool name_created_p = false;
  bool dom_imp_created_p = false;
  bool xml_reader_created_p = false;
  CCC::Catalog* catalog = 0;
  if (name == 0)
  {
    static DOMChar s[] = { 0x75 /* u */, 0x6e /* n */, 0x6b /* k */, 0x6e /* n */, 0x6f /* o */, 0x77 /* w */, 0x6e /* n */, 0x00, };
    name = new DOMString(s);
    name_created_p = true;
  }
  if (dom_imp == 0)
  {
    dom_imp = new DOMImplementation();
    dom_imp_created_p = true;
  }
  if (log == 0)
  {
#ifdef CCC_SINGLE_BYTE_DOM_STRING
    log = CCC::nulout_w8;
#else /* CCC_SINGLE_BYTE_DOM_STRING */
    log = CCC::nulout_w16;
#endif /* CCC_SINGLE_BYTE_DOM_STRING */
  }
  if (reader == 0)
  {
    CCC::Catalog* catalog = new CCC::Catalog();
    reader = new CCC::XMLReader(catalog, log);
    xml_reader_created_p = true;
  }

  Document* doc = 0;
  do
  {
    XMLParser parser(dom_imp, reader, log, option);
    if (!parser.readFromIFlow(name, in))
    {
      // データ読み込みエラー
      break;
    }
    if (!parser.parse())
    {
      // パースエラー
      // validity check エラー
      break;
    }
    doc = parser.getDocument();
  } while (false);

  if (name_created_p)
  {
    delete name;
  }
  if (dom_imp_created_p)
  {
    delete dom_imp;
  }
  if (xml_reader_created_p)
  {
    delete catalog;
    delete reader;
  }
  return doc;
}

Document*
XMLParser::readXML(const PathString* path, const DOMString* name, DOMImplementation* dom_imp, XMLReader* reader, TextWriter<DOMChar>* log, Option option)
{
#ifdef CCC_UTF16_PATHSTRING
#ifdef _WIN32
  const wchar_t* x = (const wchar_t*)path->getCString();
  return readXML(x, name, dom_imp, reader, log, option);
#else /* _WIN32 */
  CCC::BString x;
  CCC::Iceman::convertToBString(CEID_UTF16N, CEID_UTF8N, path, &x);
  return readXML(x.getCString(), name, dom_imp, reader, log, option);
#endif /* _WIN32 */
#else /* CCC_UTF16_PATHSTRING */
  return readXML(path->getCString(), name, dom_imp, reader, log, option);
#endif /* CCC_UTF16_PATHSTRING */
}

Document*
XMLParser::readXML(const char* filename, const DOMString* name, DOMImplementation* dom_imp, XMLReader* reader, TextWriter<DOMChar>* log, Option option)
{
  bool name_created_p = false;
  bool dom_imp_created_p = false;
  bool xml_reader_created_p = false;
  CCC::Catalog* catalog = 0;
  if (name == 0)
  {
    static DOMChar s[] = { 0x75 /* u */, 0x6e /* n */, 0x6b /* k */, 0x6e /* n */, 0x6f /* o */, 0x77 /* w */, 0x6e /* n */, 0x00, };
    name = new DOMString(s);
    name_created_p = true;
  }
  if (dom_imp == 0)
  {
    dom_imp = new DOMImplementation();
    dom_imp_created_p = true;
  }
  if (log == 0)
  {
#ifdef CCC_SINGLE_BYTE_DOM_STRING
    log = CCC::nulout_w8;
#else /* CCC_SINGLE_BYTE_DOM_STRING */
    log = CCC::nulout_w16;
#endif /* CCC_SINGLE_BYTE_DOM_STRING */
  }
  if (reader == 0)
  {
    CCC::Catalog* catalog = new CCC::Catalog();
    reader = new CCC::XMLReader(catalog, log);
    xml_reader_created_p = true;
  }

  Document* doc = 0;
  do
  {
    XMLParser parser(dom_imp, reader, log, option);
    if (!parser.readFromFile(name, filename))
    {
      // データ読み込みエラー
      break;
    }
    if (!parser.parse())
    {
      // パースエラー
      // validity check エラー
      break;
    }
    doc = parser.getDocument();
  } while (false);
  
  if (name_created_p)
  {
    delete name;
  }
  if (dom_imp_created_p)
  {
    delete dom_imp;
  }
  if (xml_reader_created_p)
  {
    delete catalog;
    delete reader;
  }
  return doc;
}

#ifdef _WIN32
Document*
XMLParser::readXML(const wchar_t* filename, const DOMString* name, DOMImplementation* dom_imp, XMLReader* reader, TextWriter<DOMChar>* log, Option option)
{
  bool name_created_p = false;
  bool dom_imp_created_p = false;
  bool xml_reader_created_p = false;
  CCC::Catalog* catalog = 0;
  if (name == 0)
  {
    static DOMChar s[] = { 0x75 /* u */, 0x6e /* n */, 0x6b /* k */, 0x6e /* n */, 0x6f /* o */, 0x77 /* w */, 0x6e /* n */, 0x00, };
    name = new DOMString(s);
    name_created_p = true;
  }
  if (dom_imp == 0)
  {
    dom_imp = new DOMImplementation();
    dom_imp_created_p = true;
  }
  if (log == 0)
  {
#ifdef CCC_SINGLE_BYTE_DOM_STRING
    log = CCC::nulout_w8;
#else /* CCC_SINGLE_BYTE_DOM_STRING */
    log = CCC::nulout_w16;
#endif /* CCC_SINGLE_BYTE_DOM_STRING */
  }
  if (reader == 0)
  {
    CCC::Catalog* catalog = new CCC::Catalog();
    reader = new CCC::XMLReader(catalog, log);
    xml_reader_created_p = true;
  }

  Document* doc = 0;
  do
  {
    XMLParser parser(dom_imp, reader, log, option);
    if (!parser.readFromFile(name, filename))
    {
      // データ読み込みエラー
      break;
    }
    if (!parser.parse())
    {
      // パースエラー
      // validity check エラー
      break;
    }
    doc = parser.getDocument();
  } while (false);
  
  if (name_created_p)
  {
    delete name;
  }
  if (dom_imp_created_p)
  {
    delete dom_imp;
  }
  if (xml_reader_created_p)
  {
    delete catalog;
    delete reader;
  }
  return doc;
}
#endif /* _WIN32 */

bool
XMLParser::readFromUri(DOMString* uri)
{
  XMLParserSrcUnit* su = reader->readFromUri(uri);
  if (!su)
  {
    return false;
  }
  src->addUnit(su);
  return true;
}

bool
XMLParser::readFromIFlow(const DOMString* name, IFlow* in)
{
  XMLParserSrcUnit* su = reader->readFromIFlow(name, in);
  if (!su)
  {
    return false;
  }
  src->addUnit(su);
  return true;
}

bool
XMLParser::readFromFile(const DOMString* name, const char* file)
{
  XMLParserSrcUnit* su = reader->readFromFile(name, file);
  if (!su)
  {
    return false;
  }
  src->addUnit(su);
  return true;
}

#ifdef _WIN32
bool
XMLParser::readFromFile(const DOMString* name, const wchar_t* file)
{
  XMLParserSrcUnit* su = reader->readFromFile(name, file);
  if (!su)
  {
    return false;
  }
  src->addUnit(su);
  return true;
}

#endif /* _WIN32 */

XMLParser::XMLParser(DOMImplementation* dom_imp, XMLReader* reader, TextWriter<DOMChar>* log, Option option)
{
  XMLParser::dom_imp = dom_imp;
  XMLParser::reader = reader;
  XMLParser::log = log;
  XMLParser::option = option;
  XMLParser::src = new XMLParserSrc();
  document = dom_imp->createDocument();
  xml_decl_node_map = (NamedNodeMap*)document->getXMLDeclNodeMap();
  document_type = (DocumentType*)document->getDocumentType();
  ext_subset_processing_p = false;
  do_not_support_namespace_p = ((option & DO_NOT_SUPPORT_NAMESPACE) != 0);
  /*
   * xmlのプレフィックスに対してhttp://www.w3.org/2000/xmlns/
   * のURIを設定します。
   */
  {
    DOMString* prefix_atom = document->getPrefixAtom(XMLToken::str_xml);
    DOMString* namespace_uri_atom = document->getNamespaceUriAtom(XMLToken::str_xml_uri);
    NamespaceUnit* nu = new NamespaceUnit(prefix_atom, namespace_uri_atom, 0, false);
    namespace_stack.push(nu);
  }
  /*
   * xmlnsのプレフィックスに対してhttp://www.w3.org/2000/xmlns/
   * のURIを設定します。
   */
  {
    DOMString* prefix_atom = document->getPrefixAtom(XMLToken::str_xmlns);
    DOMString* namespace_uri_atom = document->getNamespaceUriAtom(XMLToken::str_xmlns_uri);
    NamespaceUnit* nu = new NamespaceUnit(prefix_atom, namespace_uri_atom, 0, false);
    namespace_stack.push(nu);
  }
}

XMLParser::~XMLParser()
{
  delete src;
  NamespaceUnit* nu;
  while ((nu = namespace_stack.pop()))
  {
    delete nu;
  }
}

void
XMLParser::enterNamespace(DOMString* prefix, DOMString* namespace_uri, Element* element)
{
  bool empty_prefix_defined_p = false;
  NamespaceUnit* nu = namespace_stack.head();
  if (nu)
  {
    empty_prefix_defined_p = nu->empty_prefix_defined_p;
  }
  if (prefix->getLength() == 0)
  {
    empty_prefix_defined_p = true;
  }
  DOMString* prefix_atom = document->getPrefixAtom(prefix);
  DOMString* namespace_uri_atom = document->getNamespaceUriAtom(namespace_uri);
  nu = new NamespaceUnit(prefix_atom, namespace_uri_atom, element, empty_prefix_defined_p);
  namespace_stack.push(nu);
}

void
XMLParser::exitNamespace(Element* element)
{
  for (;;)
  {
    NamespaceUnit* nu = namespace_stack.head();
    if (!nu)
    {
      break;
    }
    if (nu->element == element)
    {
      namespace_stack.pop();
      delete nu;
    }
    else
    {
      break;
    }
  }
}

const DOMString*
XMLParser::findNamespaceUri(const DOMString* prefix)
{
  DOMString* prefix_atom = document->getPrefixAtom(prefix);
  Iterator<NamespaceUnit>* it = namespace_stack.createIterator();
  NamespaceUnit* nu;
  while ((nu = it->next()))
  {
    if (nu->prefix_atom == prefix_atom)
    {
      delete it;
      return nu->namespace_uri_atom;
    }
  }
  delete it;
  return 0;
}

const DOMString*
XMLParser::findNonamePrefixNamespaceUri()
{
  //bool empty_prefix_defined_p = false;
  NamespaceUnit* nu = namespace_stack.head();
  if (!nu ||
      !nu->empty_prefix_defined_p)
  {
    return 0;
  }
  Iterator<NamespaceUnit>* it = namespace_stack.createIterator();
  while ((nu = it->next()))
  {
    if (nu->prefix_atom->getLength() == 0)
    {
      delete it;
      return nu->namespace_uri_atom;
    }
  }
  delete it;
  return 0;
}

bool
XMLParser::parse()
{
  try
  {
    parseDocument();
  }
  catch (XMLParseError& pe)
  {
    fprintf(stderr, "ERROR:%d: %s\n", pe.getErrorNumber(), pe.getErrorString());
    return false;
  }
  return true;
}

void
XMLParser::showRest()
{
  printf("\n--------------------------------------------------\n");
  while (src->validPositionP())
  {
    DOMChar c = src->current();
    putchar(c);
    src->putForward();
  }
  printf("\n--------------------------------------------------\n");
}

void
XMLParser::show(char* msg, DOMString* str)
{
  fputs(msg, stdout);
  DOMChar* p = str->getStartPtr();
  DOMChar* end = p + str->getLength();
  while (p < end)
  {
    putchar(*p++);
  }
  printf("\n");
}

Size
XMLParser::restSize()
{
  return src->restSize();
}

bool
XMLParser::match(DOMChar* str, Size len)
{
  if (restSize() < len)
  {
    return false;
  }
  XMLParserSrcIterator itr(src);
  while (len-- > 0)
  {
    //if (!itr.validPositionP())
    //{
    //  return false;
    //}
    DOMChar c = itr.current();
    if (c != *str++)
    {
      return false;
    }
    itr.putForward();
  }
  return true;
}

bool
XMLParser::acceptCheck(DOMChar* str, Size len)
{
  if (match(str, len))
  {
    src->putForward(len);
    return true;
  }
  return false;
}

bool
XMLParser::matchClass(DOMChar c, DOMChar* candidates, Size len)
{
  while (len-- > 0)
  {
    if (*candidates++ == c)
    {
      return true;
    }
  }
  return false;
}

DOMString*
XMLParser::getStringDS(DOMChar* delimiter_str, Size delimiter_str_len)
{
  DOMString* str = new DOMString();
  while (!match(delimiter_str, delimiter_str_len))
  {
    if (!src->validPositionP())
    {
      break;
    }
    str->add(src->current());
    src->putForward();
  }
  return str;
}

DOMString*
XMLParser::getStringDSs(DOMChar** delimiter_strs, Size delimiter_number)
{
  DOMString* str = new DOMString();
  for (;;)
  {
    Size n;
    for (n = 0; n < delimiter_number; n++)
    {
      DOMChar* delimiter_str = delimiter_strs[n];
      Size delimiter_str_len = strLen(delimiter_str);
      if (match(delimiter_str, delimiter_str_len))
      {
	break;
      }
    }
    if (n < delimiter_number)
    {
      break;
    }
    if (!src->validPositionP())
    {
      break;
    }
    str->add(src->current());
    src->putForward();
  }
  return str;
}


DOMString*
XMLParser::getStringDC(DOMChar* delimiters, Size delimiters_len)
{
  DOMString* str = 0;
  XMLParserSrcIterator itr(src);
  while (itr.validPositionP())
  {
    DOMChar c = itr.current();
    if (matchClass(c, delimiters, delimiters_len))
    {
      break;
    }
    if (!str)
    {
      str = new DOMString();
    }
    str->add(c);
    itr.putForward();
  }
  if (str)
  {
    src->putForward(itr);
  }
  return str;
}

bool
XMLParser::getClassString(DOMChar* candidates, Size len, DOMString* str)
{
  XMLParserSrcIterator itr(src);
  bool p = false;
  while (itr.validPositionP())
  {
    DOMChar c = itr.current();
    if (!matchClass(c, candidates, len))
    {
      break;
    }
    p = true;
    str->add(c);
    itr.putForward();
  }
  if (p)
  {
    src->putForward(itr);
  }
  return p;
}

bool
XMLParser::getClassString(XmlCharClass cc, DOMString* str)
{
  XMLParserSrcIterator itr(src);
  bool p = false;
  while (itr.validPositionP())
  {
    DOMChar c = itr.current();
    if (!(xml_char_class_tbl[c] & cc))
    {
      break;
    }
    p = true;
    str->add(c);
    itr.putForward();
  }
  if (p)
  {
    src->putForward(itr);
  }
  return p;
}

//! \code
//! [5]
//! Name ::= ( Letter | '_' | ':' ) ( NameChar )*
//! NameChar ::=  Letter | Digit | '.' | '-' | '_' | ':' | CombiningChar | Extender
//! Letter ::= BaseChar | Ideographic
//! \endcode
DOMString*
XMLParser::getName()
{
  DOMString* str = new DOMString();
  if (getClassString(XMLCHARCLASS_NAMETOP, str))
  {
    getClassString(XMLCHARCLASS_NAMECHAR, str);
    return str;
  }
  else
  {
    throw XMLParseError(101, "can't get NameTop.");
  }
}

//! \code
//! [7]
//! Nmtoken ::= ( NameChar )+
//! \endcode
DOMString*
XMLParser::getNmtoken()
{
  DOMString* str = new DOMString();
  if (!getClassString(XMLCHARCLASS_NAMECHAR, str))
  {
    throw XMLParseError(102, "can't get Nmtoken.");
  }
  return str;
}

//! \code
//! [67] 
//! Reference ::= EntityRef | CharRef
//! [66] 
//! CharRef ::= '&#' [0-9]+ ';'
//!           | '&#x' [0-9a-fA-F]+ ';'
//! [68] 
//! EntityRef ::= '&' Name ';'
//!=>
//! Reference ::= '&' ( '#' ( [0-9]+ | 'x' [0-9a-fA-F]+ ) ';' )
//!             | '&' Name ';'
//! \endcode
bool
XMLParser::parseReference(bool l1_p, DOMString* s)
{
  static DOMChar cls_10[] = { 0x30 /* 0 */, 0x31 /* 1 */, 0x32 /* 2 */, 0x33 /* 3 */, 0x34 /* 4 */, 0x35 /* 5 */, 0x36 /* 6 */, 0x37 /* 7 */, 0x38 /* 8 */, 0x39 /* 9 */, 0x00, };
  static DOMChar cls_16[] = { 0x30 /* 0 */, 0x31 /* 1 */, 0x32 /* 2 */, 0x33 /* 3 */, 0x34 /* 4 */, 0x35 /* 5 */, 0x36 /* 6 */, 0x37 /* 7 */, 0x38 /* 8 */, 0x39 /* 9 */, 0x61 /* a */, 0x62 /* b */, 0x63 /* c */, 0x64 /* d */, 0x65 /* e */, 0x66 /* f */, 0x41 /* A */, 0x42 /* B */, 0x43 /* C */, 0x44 /* D */, 0x45 /* E */, 0x46 /* F */, 0x00, };
  if (l1_p)
  {
    return CHECK(XMLToken::str_and);
  }
  bool keep_p = ((option & PRIVENT_ENTITY_EXTRACTION) != 0);
  bool rep_p = ((option & ENTITY_REPLACING) != 0);
  bool except_basic_p = ((option &ENTITY_REPLACING_EXCEPT_BASIC_ENTITY) != 0);
  if (keep_p)
  {
    s->add(XMLToken::str_and);
  }
  if (CHECK(XMLToken::str_sharp))
  {
    if (rep_p)
    {
      s->add(XMLToken::str_entity_rep_and);
    }
    if (keep_p || rep_p)
    {
      s->add(XMLToken::str_sharp);
    }
    // CharRef
    if (CHECK(XMLToken::str_x))
    {
      // 16
      DOMString* str = new DOMString();
      if (!getClassString(CARG(cls_16), str))
      {
	throw XMLParseError(103, "CharRef syntax error");
      }
      if (keep_p || rep_p)
      {
	s->add(XMLToken::str_x);
	s->add(*str);
      }
      //show("charref 16:", str);
      DOMChar x = 0;
      Size len = str->getLength();
      Size n;
      for (n = 0; n < len; n++)
      {
	DOMChar add = 0;
	switch ((*str)[n])
	{
	 case '0':
	  add = 0;
	  break;
	 case '1':
	  add = 1;
	  break;
	 case '2':
	  add = 2;
	  break;
	 case '3':
	  add = 3;
	  break;
	 case '4':
	  add = 4;
	  break;
	 case '5':
	  add = 5;
	  break;
	 case '6':
	  add = 6;
	  break;
	 case '7':
	  add = 7;
	  break;
	 case '8':
	  add = 8;
	  break;
	 case '9':
	  add = 9;
	  break;
	 case 'A':
	 case 'a':
	  add = 0xa;
	  break;
	 case 'B':
	 case 'b':
	  add = 0xb;
	  break;
	 case 'C':
	 case 'c':
	  add = 0xc;
	  break;
	 case 'D':
	 case 'd':
	  add = 0xd;
	  break;
	 case 'E':
	 case 'e':
	  add = 0xe;
	  break;
	 case 'F':
	 case 'f':
	  add = 0xf;
	  break;
	 default:
	  break;
	}
	x = (x * 16) + add;
      }
      if (!(keep_p || rep_p))
      {
	s->add(x);
      }
      delete str;
    }
    else
    {
      // 10
      DOMString* str = new DOMString();
      if (!getClassString(CARG(cls_10), str))
      {
	throw XMLParseError(104, "CharRef syntax error");
      }
      if (keep_p || rep_p)
      {
	s->add(*str);
      }
      //show("charref 10:", str);
      DOMChar x = 0;
      Size len = str->getLength();
      Size n;
      for (n = 0; n < len; n++)
      {
	DOMChar add = 0;
	switch ((*str)[n])
	{
	 case '0':
	  add = 0;
	  break;
	 case '1':
	  add = 1;
	  break;
	 case '2':
	  add = 2;
	  break;
	 case '3':
	  add = 3;
	  break;
	 case '4':
	  add = 4;
	  break;
	 case '5':
	  add = 5;
	  break;
	 case '6':
	  add = 6;
	  break;
	 case '7':
	  add = 7;
	  break;
	 case '8':
	  add = 8;
	  break;
	 case '9':
	  add = 9;
	  break;
	 default:
	  break;
	}
	x = (x * 10) + add;
      }
      if (!(keep_p || rep_p))
      {
	s->add(x);
      }
      delete str;
    }
    if (!CHECK(XMLToken::str_semicol))
    {
      throw XMLParseError(105, "can't find the CharRef end semicolon.");
    }
    if (keep_p)
    {
      s->add(XMLToken::str_semicol);
    }
    else if (rep_p)
    {
      s->add(XMLToken::str_entity_rep_semicol);
    }
  }
  else
  {
    // EntityRef
    DOMString* ref = getName();
    const DOMString* next_input = 0;
    bool did_rep_p = false;
    if (keep_p)
    {
      s->add(*ref);
    }
    else
    {
      //show("entity ref:", str);
      const NamedNodeMap* entity_map = document_type->getEntities();
      DOMString* atom = document->getAtom(ref);
      Entity* entity = (Entity*)entity_map->getNamedItem(atom);
      if (entity)
      {
	if (rep_p)
	{
	  s->add(XMLToken::str_entity_rep_and);
	  s->add(*ref);
	  did_rep_p = true;
	}
	else
	{
	  // It is necessary to change the input stream to entity value
	  // after semicolon is parseed.
	  //// s->add(*entity->getEntityValue());
	  next_input = entity->getEntityValue();
	}
      }
      else
      {
	// &lt; &gt; &amp; &apos; &quot; check
	EntityReplacement* er = XMLToken::basic_entity;
	while (er->esc)
	{
	  if (!ref->strCmp(er->esc))
	  {
	    break;
	  }
	  er++;
	}
	if (!er->esc)
	{
	  if ((option & IGNORE_UNRESOLVED_ENTITY_REFERENCE) == 0)
	  {
	    delete ref;
	    throw XMLParseError(167, "can't find Entity definition.");
	  }
	  else if (rep_p)
	  {
	    s->add(XMLToken::str_entity_rep_and);
	    s->add(*ref);
	    did_rep_p = true;
	  }
	}
	else
	{
	  if (rep_p && (except_basic_p == false))
	  {
	    s->add(XMLToken::str_entity_rep_and);
	    s->add(*ref);
	    did_rep_p = true;
	  }
	  else
	  {
	    s->add(er->src);
	  }
	}
      }
      delete ref;
    }
    if (!CHECK(XMLToken::str_semicol))
    {
      throw XMLParseError(106, "can't find the EntityRef end semicolon.");
    }
    if (keep_p)
    {
      s->add(XMLToken::str_semicol);
    }
    else if (rep_p && did_rep_p)
    {
      s->add(XMLToken::str_entity_rep_semicol);
    }
    if (next_input)
    {
      DOMChar s_entity[] = { 0x45 /* E */, 0x4e /* N */, 0x54 /* T */, 0x49 /* I */, 0x54 /* T */, 0x59 /* Y */, 0x00, };
      DOMString s(s_entity);
      XMLParserSrcUnit* unit = new XMLParserSrcUnit(&s, (DOMString*)next_input, false);
      src->addUnit(unit);
    }
  }
  return true;
}

//! \code
//! [10]
//! AttValue ::= '"' ( [^<&"] | Reference )* '"'
//!            | "'" ( [^<&'] | Reference )* "'"
//! \endcode
DOMString*
XMLParser::getAttValue()
{
  static DOMChar dlm1_0[] = { 0x3c /* < */, 0x26 /* & */, 0x22 /* \" */, 0x00, };
  static DOMChar dlm2_0[] = { 0x3c /* < */, 0x26 /* & */, 0x27 /* ' */, 0x00, };
  static DOMChar dlm1_1[] = { 0x26 /* & */, 0x22 /* \" */, 0x00, };
  static DOMChar dlm2_1[] = { 0x26 /* & */, 0x27 /* ' */, 0x00, };
  DOMChar* dlm1 = dlm1_0;
  DOMChar* dlm2 = dlm2_0;
  Size dlm1_size = (sizeof(dlm1_0)/sizeof(DOMChar) - 1);
  Size dlm2_size = (sizeof(dlm2_0)/sizeof(DOMChar) - 1);
  if ((option & HANDLE_LT_IN_THE_ATTVALUE) != 0)
  {
    dlm1 = dlm1_1;
    dlm2 = dlm2_1;
    dlm1_size = (sizeof(dlm1_1)/sizeof(DOMChar) - 1);
    dlm2_size = (sizeof(dlm2_1)/sizeof(DOMChar) - 1);
  }
  DOMString* str = new DOMString();
  if (CHECK(XMLToken::str_dquote))		// '"'
  {
    for (;;)
    {
      if (parseReference(true, 0))
      {
	parseReference(false, str);
      }
      else if (CHECK(XMLToken::str_dquote))	// '"'
      {
	break;
      }
      else if (CHECK(XMLToken::str_open))	// '<'
      {
	throw XMLParseError(107, "can't put '<' in the AttValue.");
      }
      else
      {
	DOMString* str2 = getStringDC(dlm1, dlm1_size);
	if (str2)
	{
	  str->add(*str2);
	  delete str2;
	}
      }
    }
  }
  else if (CHECK(XMLToken::str_quote))		// "'"
  {
    for (;;)
    {
      if (parseReference(true, 0))
      {
	parseReference(false, str);
      }
      else if (CHECK(XMLToken::str_quote))	// "'"
      {
	break;
      }
      else if (CHECK(XMLToken::str_open))		// '<'
      {
	throw XMLParseError(108, "can't put '<' in the AttValue.");
      }
      else
      {
	DOMString* str2 = getStringDC(dlm2, dlm2_size);
	if (str2)
	{
	  str->add(*str2);
	  delete str2;
	}
      }
    }
  }
  else
  {
    throw XMLParseError(109, "can't find attvalue starting ' or \"");
  }
  return str;
}

//! \code
//! [69] 
//! PEReference ::= '%' Name ';'
//! \endcode
bool
XMLParser::parsePEReference(bool l1_p)
{
  if (l1_p)
  {
    return CHECK(XMLToken::str_percent);
  }
  DOMString* str = getName();
  //show("peref: ", str);
  if (!CHECK(XMLToken::str_semicol))
  {
    delete str;
    throw XMLParseError(110, "can't find PEReference end ';'.");
  }
  
  const NamedNodeMap* entity_map = document_type->getPEntities();
  DOMString* atom = document->getAtom(str);
  DtdPEntity* entity = (DtdPEntity*)entity_map->getNamedItem(atom);
  if (entity)
  {
#if 0
    DOMChar s_entity[] = { 0x50 /* P */, 0x45 /* E */, 0x4e /* N */, 0x54 /* T */, 0x49 /* I */, 0x54 /* T */, 0x59 /* Y */, 0x00, };
    DOMString s(s_entity);
    show("def:", (DOMString*)entity->getPEDef());
    XMLParserSrcUnit* unit = new XMLParserSrcUnit(&s, (DOMString*)entity->getPEDef(), false);
    src->addUnit(unit);
#endif
  }
  else
  {
    delete str;
    throw XMLParseError(168, "can't find Parameter Entity definition.");
  }
  delete str;
  return true;
}

//! \code
//! [9]
//! EntityValue ::= '"' ( [^%&"] | PEReference | Reference )* '"'
//!               | "'" ( [^%&'] | PEReference | Reference )* "'"
//! \endcode
DOMString*
XMLParser::getEntityValue()
{
  DOMChar dlm1[] = { 0x25 /* % */, 0x26 /* & */, 0x22 /* \" */, 0x00, };
  DOMChar dlm2[] = { 0x25 /* % */, 0x26 /* & */, 0x27 /* ' */, 0x00, };
  
  DOMString* str = new DOMString();
  if (CHECK(XMLToken::str_dquote))
  {
    for (;;)
    {
      if (parsePEReference(true))
      {
	parsePEReference(false);
      }
      else if (parseReference(true, 0))
      {
	parseReference(false, str);
      }
      else if (CHECK(XMLToken::str_dquote))
      {
	break;
      }
      else
      {
	DOMString* str2 = getStringDC(CARG(dlm1));
	if (str2)
	{
	  str->add(*str2);
	  delete str2;
	}
      }
    }
  }
  else if (CHECK(XMLToken::str_quote))
  {
    DOMString* str = new DOMString();
    for (;;)
    {
      if (parsePEReference(true))
      {
	parsePEReference(false);
      }
      else if (parseReference(true, 0))
      {
	parseReference(false, 0);
      }
      else if (CHECK(XMLToken::str_quote))
      {
	break;
      }
      else
      {
	DOMString* str2 = getStringDC(CARG(dlm2));
	if (str2)
	{
	  str->add(*str2);
	  delete str2;
	}
      }
    }
  }
  else
  {
    throw XMLParseError(111, "can't find attvalue starting ' or \"");
  }
  return str;
}

//! \code
//! [1]
//! document ::= prolog element Misc*
//! \endcode
void
XMLParser::parseDocument()
{
  parseProlog();
  if (parseElement(true, document))
  {
    parseElement(false, document);
  }
  else
  {
    throw XMLParseError(112, "can't find the top element.");
  }
  while (parseMiscEpilog(true))
  {
    parseMiscEpilog(false);
  }
  //showRest();
}

//! \code
//! [22]
//! prolog ::= XMLDecl? Misc* ( doctypedecl Misc*)?
//! \endcode
void
XMLParser::parseProlog()
{
  // XMLDecl?
  if (parseXMLDecl(true))
  {
    parseXMLDecl(false);
  }
  // Misc*
  while (parsePrologMisc1(true))
  {
    parsePrologMisc1(false);
  }
  // doctypedecl
  if (parseDoctypedecl(true))
  {
    parseDoctypedecl(false);
    while (parsePrologMisc2(true))
    {
      parsePrologMisc2(false);
    }
  }
}

//! \code
//! [23]
//! XMLDecl ::= '<?xml' VersionInfo EncodingDecl? SDDecl? S? '?>'
//! LL(1) =>
//! XMLDecl ::= '<?xml' VersionInfo (S EncodingDecl)? (S SDDecl)? S? '?>'
//! \endcode
bool
XMLParser::parseXMLDecl(bool l1_p)
{
  // <?xml
  if (l1_p)
  {
    return CHECK(XMLToken::str_xmldecl_start);
  }
  // VersionInfo
  if (!parseVersionInfo(true))
  {
    throw XMLParseError(113, "can't find 'version' between '<?xml' and '?>'.");
  }
  parseVersionInfo(false);
  // S
  if (parseS(true))
  {
    parseS(false);
    // EncodingDecl?
    if (parseEncodingDecl(true))
    {
      parseEncodingDecl(false);
    }
    if (parseS(true))
    {
      parseS(false);
      // SDDecl?
      if (parseSDDecl(true))
      {
	parseSDDecl(false);
      }
    }
  }
  // S?
  if (parseS(true))
  {
    parseS(false);
  }
  // '?>'
  if (!CHECK(XMLToken::str_xmldecl_end))
  {
    throw XMLParseError(114, "can't find '?>'.");
  }
  return true;
}

//! \code
//! [24]
//! VersionInfo ::= S 'version' Eq ( "'" VersionNum "'" | '"' VersionNum '"' )
//! \endcode
bool
XMLParser::parseVersionInfo(bool l1_p)
{
  if (l1_p)
  {
    // S
    parseS();
    // 'version'
    return CHECK(XMLToken::str_version);
  }
  // Eq
  parseEq();
  // ( "'" VersionNum "'" | '"' VersionNum '"' )
  DOMString* s = 0;
  if (CHECK(XMLToken::str_quote))
  {
    s = parseVersionNum();
    if (!CHECK(XMLToken::str_quote))
    {
      throw XMLParseError(115, "can't find \"'\".");
    }
  }
  else if (CHECK(XMLToken::str_dquote))
  {
    s = parseVersionNum();
    if (!CHECK(XMLToken::str_dquote))
    {
      throw XMLParseError(116, "can't find '\"'.");
    }
  }
  else
  {
    throw XMLParseError(117, "version number specification syntax error.");
  }
  if (!ext_subset_processing_p)
  {
    Attr* attr = document->createAttribute(XMLToken::str_version);
    xml_decl_node_map->setNamedItem(attr);
    attr->setValue(s);
  }
  delete s;
  return true;
}

//! \code
//! [26]
//! VersionNum ::= ( [a-zA-Z0-9_.:] | '-' )+
//! \endcode
DOMString*
XMLParser::parseVersionNum()
{
  static DOMChar cls_versionnum[] = { 0x41 /* A */, 0x42 /* B */, 0x43 /* C */, 0x44 /* D */, 0x45 /* E */, 0x46 /* F */, 0x47 /* G */, 0x48 /* H */, 0x49 /* I */, 0x4a /* J */, 0x4b /* K */, 0x4c /* L */, 0x4d /* M */, 0x4e /* N */, 0x4f /* O */, 0x50 /* P */, 0x51 /* Q */, 0x52 /* R */, 0x53 /* S */, 0x54 /* T */, 0x55 /* U */, 0x56 /* V */, 0x57 /* W */, 0x58 /* X */, 0x59 /* Y */, 0x5a /* Z */, 0x61 /* a */, 0x62 /* b */, 0x63 /* c */, 0x64 /* d */, 0x65 /* e */, 0x66 /* f */, 0x67 /* g */, 0x68 /* h */, 0x69 /* i */, 0x6a /* j */, 0x6b /* k */, 0x6c /* l */, 0x6d /* m */, 0x6e /* n */, 0x6f /* o */, 0x70 /* p */, 0x71 /* q */, 0x72 /* r */, 0x73 /* s */, 0x74 /* t */, 0x75 /* u */, 0x76 /* v */, 0x77 /* w */, 0x78 /* x */, 0x79 /* y */, 0x7a /* z */, 0x30 /* 0 */, 0x31 /* 1 */, 0x32 /* 2 */, 0x33 /* 3 */, 0x34 /* 4 */, 0x35 /* 5 */, 0x36 /* 6 */, 0x37 /* 7 */, 0x38 /* 8 */, 0x39 /* 9 */, 0x5f /* _ */, 0x2e /* . */, 0x3a /* : */, 0x2d /* - */, 0x00, };
  XMLParserSrcIterator itr(src);
  if (!itr.validPositionP())
  {
    throw XMLParseError(118, "unexpected end of input.");
  }
  DOMChar c = itr.current();
  if (!matchClass(c, CARG(cls_versionnum)))
  {
    throw XMLParseError(119, "can't find version number string.");
  }
  DOMString* str = new DOMString();
  str->add(c);
  while (itr.putForward())
  {
    c = itr.current();
    if (!matchClass(c, CARG(cls_versionnum)))
    {
      break;
    }
    str->add(c);
  }
  src->putForward(itr);
  //show("xml version:", str);
  return str;
}

//! \code
//! [25]
//! Eq ::= S? '=' S?
//! \endcode
void
XMLParser::parseEq()
{
  if (parseS(true))
  {
    parseS(false);
  }
  if (!CHECK(XMLToken::str_eq))
  {
    throw XMLParseError(120, "can't find '='.");
  }
  if (parseS(true))
  {
    parseS(false);
  }
}

//! \code
//! [3]
//! S ::= ( #x20 | #x9 | #xD | #xA )+
//! \endcode
bool
XMLParser::parseS(bool l1_p, Node* parent)
{
  static DOMChar cls_s[] = { 0x20, 0x09, 0x0d, 0x0a, 0x00 };
  if (l1_p)
  {
    XMLParserSrcIterator itr(src);
    if (!itr.validPositionP())
    {
      return false;
    }
    bool p = false;
    DOMString s;
    do
    {
      DOMChar c = itr.current();
      if (!matchClass(c, CARG(cls_s)))
      {
	break;
      }
      p = true;
      s.add(c);
    } while (itr.putForward());
    if (p)
    {
      if (parent)
      {
	Text* text = document->createTextNode(&s);
	parent->appendChild(text);
      }
      src->putForward(itr);
    }
    return p;
  }
  return true;
}

void
XMLParser::parseS()
{
  if (!parseS(true))
  {
    throw XMLParseError(121, "can't find space.");
  }
  parseS(false);
}

//! \code
//! [80] 
//! EncodingDecl ::= S 'encoding' Eq ( '"' EncName '"' | "'" EncName "'" )
//! LL(1) =>
//! EncodingDecl ::= 'encoding' Eq ( '"' EncName '"' | "'" EncName "'" )
//! \endcode
bool
XMLParser::parseEncodingDecl(bool l1_p)
{
  if (l1_p)
  {
    return CHECK(XMLToken::str_encoding);
  }
  parseEq();
  DOMString* s;
  if (CHECK(XMLToken::str_quote))
  {
    s = parseEncName();
    if (!CHECK(XMLToken::str_quote))
    {
      throw XMLParseError(122, "can't find \"'\".");
    }
  }
  else if (CHECK(XMLToken::str_dquote))
  {
    s = parseEncName();
    if (!CHECK(XMLToken::str_dquote))
    {
      throw XMLParseError(123, "can't find '\"'.");
    }
  }
  else
  {
    throw XMLParseError(124, "encoding specification syntax error.");
  }
  if (!ext_subset_processing_p)
  {
    Attr* attr = document->createAttribute(XMLToken::str_encoding);
    xml_decl_node_map->setNamedItem(attr);
    attr->setValue(s);
  }
  delete s;
  return true;
}

//! \code
//! [81]
//! EncName ::= [A-Za-z] ( [A-Za-z0-9._] | '-' )*
//! \endcode
DOMString*
XMLParser::parseEncName()
{
  static DOMChar cls_encname1[] = { 0x41 /* A */, 0x42 /* B */, 0x43 /* C */, 0x44 /* D */, 0x45 /* E */, 0x46 /* F */, 0x47 /* G */, 0x48 /* H */, 0x49 /* I */, 0x4a /* J */, 0x4b /* K */, 0x4c /* L */, 0x4d /* M */, 0x4e /* N */, 0x4f /* O */, 0x50 /* P */, 0x51 /* Q */, 0x52 /* R */, 0x53 /* S */, 0x54 /* T */, 0x55 /* U */, 0x56 /* V */, 0x57 /* W */, 0x58 /* X */, 0x59 /* Y */, 0x5a /* Z */, 0x61 /* a */, 0x62 /* b */, 0x63 /* c */, 0x64 /* d */, 0x65 /* e */, 0x66 /* f */, 0x67 /* g */, 0x68 /* h */, 0x69 /* i */, 0x6a /* j */, 0x6b /* k */, 0x6c /* l */, 0x6d /* m */, 0x6e /* n */, 0x6f /* o */, 0x70 /* p */, 0x71 /* q */, 0x72 /* r */, 0x73 /* s */, 0x74 /* t */, 0x75 /* u */, 0x76 /* v */, 0x77 /* w */, 0x78 /* x */, 0x79 /* y */, 0x7a /* z */, 0x00, };
  static DOMChar cls_encname2[] = { 0x41 /* A */, 0x42 /* B */, 0x43 /* C */, 0x44 /* D */, 0x45 /* E */, 0x46 /* F */, 0x47 /* G */, 0x48 /* H */, 0x49 /* I */, 0x4a /* J */, 0x4b /* K */, 0x4c /* L */, 0x4d /* M */, 0x4e /* N */, 0x4f /* O */, 0x50 /* P */, 0x51 /* Q */, 0x52 /* R */, 0x53 /* S */, 0x54 /* T */, 0x55 /* U */, 0x56 /* V */, 0x57 /* W */, 0x58 /* X */, 0x59 /* Y */, 0x5a /* Z */, 0x61 /* a */, 0x62 /* b */, 0x63 /* c */, 0x64 /* d */, 0x65 /* e */, 0x66 /* f */, 0x67 /* g */, 0x68 /* h */, 0x69 /* i */, 0x6a /* j */, 0x6b /* k */, 0x6c /* l */, 0x6d /* m */, 0x6e /* n */, 0x6f /* o */, 0x70 /* p */, 0x71 /* q */, 0x72 /* r */, 0x73 /* s */, 0x74 /* t */, 0x75 /* u */, 0x76 /* v */, 0x77 /* w */, 0x78 /* x */, 0x79 /* y */, 0x7a /* z */, 0x30 /* 0 */, 0x31 /* 1 */, 0x32 /* 2 */, 0x33 /* 3 */, 0x34 /* 4 */, 0x35 /* 5 */, 0x36 /* 6 */, 0x37 /* 7 */, 0x38 /* 8 */, 0x39 /* 9 */, 0x2e /* . */, 0x5f /* _ */, 0x2d /* - */, 0x00, };
  XMLParserSrcIterator itr(src);
  if (!itr.validPositionP())
  {
    throw XMLParseError(125, "unexpected end of input.");
  }
  DOMChar c = itr.current();
  if (!matchClass(c, CARG(cls_encname1)))
  {
    throw XMLParseError(126, "can't find encoding string.");
  }
  DOMString* str = new DOMString();
  str->add(c);
  while (itr.putForward())
  {
    c = itr.current();
    if (!matchClass(c, CARG(cls_encname2)))
    {
      break;
    }
    str->add(c);
  }
  src->putForward(itr);
  //show("xml encoding:", str);
  return str;
}

//! \code
//! [32] 
//! SDDecl ::= S 'standalone' Eq (( "'" ( 'yes' | 'no' ) "'" ) | ( '"' ( 'yes' | 'no' ) '"' ))
//! LL(1) =>
//! SDDecl ::= 'standalone' Eq (( "'" ( 'yes' | 'no' ) "'" ) | ( '"' ( 'yes' | 'no' ) '"' ))
//! \endcode
bool
XMLParser::parseSDDecl(bool l1_p)
{
  if (l1_p)
  {
    return CHECK(XMLToken::str_standalone);
  }
  parseEq();
  bool standalone_p = true;	// TODO: check default value
  if (CHECK(XMLToken::str_quote))
  {
    if (!CHECK(XMLToken::str_yes))
    {
      if (!CHECK(XMLToken::str_no))
      {
	throw XMLParseError(127, "standalone should be 'yes' or 'no'.");
      }
      else
      {
	standalone_p = false;
      }
    }
    else
    {
      standalone_p = true;
    }
    if (!CHECK(XMLToken::str_quote))
    {
      throw XMLParseError(128, "can't find \"'\".");
    }
  }
  else if (CHECK(XMLToken::str_dquote))
  {
    if (!CHECK(XMLToken::str_yes))
    {
      if (!CHECK(XMLToken::str_no))
      {
	throw XMLParseError(129, "standalone should be 'yes' or 'no'.");
      }
      else
      {
	standalone_p = false;
      }
    }
    else
    {
      standalone_p = true;
    }
    if (!CHECK(XMLToken::str_dquote))
    {
      throw XMLParseError(130, "can't find '\"'.");
    }
  }
  else
  {
    throw XMLParseError(131, "standalone specification syntax error.");
  }
  Attr* attr = document->createAttribute(XMLToken::str_standalone);
  xml_decl_node_map->setNamedItem(attr);
  attr->setValue(standalone_p ? XMLToken::str_yes : XMLToken::str_no);
  // printf("xml standalone:%s\n", standalone_p ? "yes" : "no");
  return true;
}

//! \code
//! [27]
//! Misc ::= Comment | PI | S
//! \endcode
bool
XMLParser::parsePrologMisc1(bool l1_p)
{
  if (l1_p)
  {
    bool p = false;
    if (parseComment(true, document))
    {
      parseComment(false, document);
      p = true;
    }
    else if (parsePI(true, document))
    {
      parsePI(false, document);
      p = true;
    }
    else if (parseS(true, document))
    {
      parseS(false, document);
      p = true;
    }
    return p;
  }
  return true;
}

//! \code
//! [15]
//! Comment ::= '<!--' (( Char - '-') | ('-' ( Char - '-')))* '-->'
//! \endcode
bool
XMLParser::parseComment(bool l1_p, Node* parent)
{
  static DOMChar dlm_comment[] = { 0x2d /* - */, 0x2d /* - */, 0x00, };

  // '<!--'
  if (l1_p)
  {
    return CHECK(XMLToken::str_comment_start);
  }
  // (( Char - '-') | ('-' ( Char - '-')))*
  DOMString* str = getStringDS(CARG(dlm_comment));
  Comment* comment = document->createComment(str);
  parent->appendChild(comment);
  //show("comment:", str);
  delete str;
  // '-->'
  if (!CHECK(XMLToken::str_comment_end))
  {
    throw XMLParseError(132, "can't find comment end.");
  }
  return true;
}

//! \code
//! [16]
//! PI ::= '<?' PITarget ( S ( Char* - ( Char* '?>' Char*)))? '?>'
//! \endcode
bool
XMLParser::parsePI(bool l1_p, Node* parent)
{
  // <?
  if (l1_p)
  {
    return CHECK(XMLToken::str_pi_start);
  }
  // PITarget
  DOMString* target = parsePITarget();
  // S
  DOMString* data = 0;
  if (parseS(true))
  {
    parseS(false);
    data = getStringDS(CARG(XMLToken::str_pi_end));
    //show("PI extra:", data);
  }
  ProcessingInstruction* pi = document->createProcessingInstruction(target, data);
  parent->appendChild(pi);
  delete target;
  delete data;

  // ?>
  if (!CHECK(XMLToken::str_pi_end))
  {
    throw XMLParseError(133, "can't find the end of PI.");
  }
  return true;
}

//! \code
//! [17]
//! PITarget ::= Name - (( 'X' | 'x' ) ( 'M' | 'm' ) ( 'L' | 'l' ))
//! \endcode
DOMString*
XMLParser::parsePITarget()
{
  DOMString* str = getName();
  // TODO: check pitarget is not (( 'X' | 'x' ) ( 'M' | 'm' ) ( 'L' | 'l' ))
  //show("PI Target:", str);
  return str;
}

//! \code
//! [27]
//! Misc ::= Comment | PI | S
//! \endcode
bool
XMLParser::parsePrologMisc2(bool l1_p)
{
  if (l1_p)
  {
    bool p = false;
    // Comment
    if (parseComment(true, document))
    {
      parseComment(false, document);
      p = true;
    }
    // PI
    else if (parsePI(true, document))
    {
      parsePI(false, document);
      p = true;
    }
    // S
    else if (parseS(true, document))
    {
      parseS(false, document);
      p = true;
    }
    return p;
  }
  return true;
}

bool
XMLParser::parseMiscEpilog(bool l1_p)
{
  if (l1_p)
  {
    bool p = false;
    // Comment
    if (parseComment(true, document))
    {
      parseComment(false, document);
      p = true;
    }
    // PI
    else if (parsePI(true, document))
    {
      parsePI(false, document);
      p = true;
    }
    // S
    else if (parseS(true, document))
    {
      parseS(false, document);
      p = true;
    }
    return p;
  }
  return true;
}

//! \code
//! [28] 
//! doctypedecl ::= '<!DOCTYPE' S Name ( S ExternalID )? S? ( '[' ( markupdecl | DeclSep )* ']' S? )? '>'
//! =>
//! doctypedecl ::= '<!DOCTYPE' S Name ( S ( ExternalID1 | ExternalID2 ) )? S? ( '['
//!   ( markupdecl | DeclSep )* ']' S? )? '>'
//! =>
//! [29]
//! markupdecl ::= elementdecl | AttlistDecl | EntityDecl | NotationDecl | PI | Comment
//! [28a]
//! DeclSep ::= PEReference | S
//! doctypedecl ::= '<!DOCTYPE' S Name ( S ( ExternalID1 | ExternalID2 ) )? S? ( '['
//!   ( elementdecl | AttlistDecl | EntityDecl | NotationDecl | PI | Comment | PEReference | S )*
//!   ']' S? )? '>'
//! \endcode
bool
XMLParser::parseDoctypedecl(bool l1_p)
{
  // <!DOCTYPE
  if (l1_p)
  {
    return CHECK(XMLToken::str_doctype_start);
  }
  document->appendChild(document_type);
  // S
  parseS();
  // Name
  DOMString* str = getName();
  document_type->setNodeName(str);
  delete str;
  // S
  if (parseS(true))
  {
    parseS(false);
    // ExternalID ::= ExternalID1 | ExternalID2
    if (parseExternalID1(true, document_type))
    {
      parseExternalID1(false, document_type);
    }
    else if (parseExternalID2(true, document_type))
    {
      parseExternalID2(false, document_type);
    }
  }
  // S?
  if (parseS(true))
  {
    parseS(false);
  }
  // [
  if (CHECK(XMLToken::str_markupdecl_start))
  {
    // ( elementdecl | AttlistDecl | EntityDecl | NotationDecl | PI | Comment | PEReference | S )*
    for (;;)
    {
      if (parsePEReference(true))
      {
	parsePEReference(false);
      }
      else if (parseS(true, document_type))
      {
	Node* node = document_type->getLastChild();
	document_type->addDtdInternals(node);
	parseS(false);
      }
      else if (parseElementdecl(true))
      {
	parseElementdecl(false);
      }
      else if (parseAttlistDecl(true))
      {
	parseAttlistDecl(false);
      }
      else if (parseEntityDecl(true))
      {
	parseEntityDecl(false);
      }
      else if (parseNotationDecl(true))
      {
	parseNotationDecl(false);
      }
      else if (parsePI(true, document_type))
      {
	parsePI(false, document_type);
	document_type->addDtdInternals(document_type->getLastChild());
      }
      else if (parseComment(true, document_type))
      {
	parseComment(false, document_type);
	document_type->addDtdInternals(document_type->getLastChild());
      }
      else
      {
	break;
      }
    }
    // ]
    if (!CHECK(XMLToken::str_markupdecl_end))
    {
      throw XMLParseError(134, "can't find ]");
    }
    // S?
    if (parseS(true))
    {
      parseS(false);
    }
  }
  if (!CHECK(XMLToken::str_close))
  {
    throw XMLParseError(135, "can't find '>' of the DOCTYPE end.");
  }
  return true;
}

//! \code
//! [75] 
//! ExternalID ::= 'SYSTEM' S SystemLiteral
//!              | 'PUBLIC' S PubidLiteral S SystemLiteral
//! =>
//! ExternalID1 ::= 'SYSTEM' S SystemLiteral
//! ExternalID2 ::= 'PUBLIC' S PubidLiteral S SystemLiteral
//! \endcode
bool
XMLParser::parseExternalID1(bool l1_p, External* ext)
{
  // SYSTEM
  if (l1_p)
  {
    return CHECK(XMLToken::str_externalidsystem);
  }
  // S
  parseS();
  // SystemLiteral
  DOMString* system_literal = getSystemLiteral();
  ext->setSystemId(system_literal);
  //show("SystemLiteral:", system_literal);
  delete system_literal;
  return true;
}

//! \code
//! [75] 
//! ExternalID ::= 'SYSTEM' S SystemLiteral
//!              | 'PUBLIC' S PubidLiteral S SystemLiteral
//! =>
//! ExternalID1 ::= 'SYSTEM' S SystemLiteral
//! ExternalID2 ::= 'PUBLIC' S PubidLiteral S SystemLiteral
//! \endcode
bool
XMLParser::parseExternalID2(bool l1_p, External* ext)
{
  // PUBLIC
  if (l1_p)
  {
    return CHECK(XMLToken::str_externalidpublic);
  }
  // S
  parseS();
  // PubidLiteral
  DOMString* pubid_literal = getPubidLiteral();
  ext->setPublicId(pubid_literal);
  //show("PubidLiteral:", pubid_literal);
  // S
  parseS();
  // SystemLiteral
  DOMString* system_literal = getSystemLiteral();
  ext->setSystemId(system_literal);
  //show("SystemLiteral:", system_literal);
  delete pubid_literal;
  delete system_literal;
  return true;
}

//! \code
//! [11]
//! SystemLiteral ::= ( '"' [^"]* '"') | ( "'" [^']* "'")
//! \endcode
DOMString*
XMLParser::getSystemLiteral(bool permit_not_found_p)
{
  /* DOMChar c = */ src->current();
  DOMString* str = 0;
  if (CHECK(XMLToken::str_dquote))
  {
    str = getStringDS(CARG(XMLToken::str_dquote));
    if (!CHECK(XMLToken::str_dquote))
    {
      throw XMLParseError(136, "can't find system literal colose \"");
    }
  }
  else if (CHECK(XMLToken::str_quote))
  {
    str = getStringDS(CARG(XMLToken::str_quote));
    if (!CHECK(XMLToken::str_quote))
    {
      throw XMLParseError(137, "can't find system literal colose '");
    }
  }
  else
  {
    if (permit_not_found_p)
    {
      return 0;
    }
    throw XMLParseError(138, "can't find system literal");
  }
  return str;
}

//! \code
//! [12]
//! PubidLiteral ::= '"' PubidChar * '"'
//!                | "'" ( PubidChar - "'" )* "'"
//! [13]
//! PubidChar ::= #x20 | #xD | #xA | [a-zA-Z0-9] | [-'()+,./:=?;!*#@$_%]
//! \endcode
DOMString*
XMLParser::getPubidLiteral()
{
  static DOMChar cls_pubidchar[] = { 0x20 /*   */, 0x0d /* \r */, 0x0a /* \n */, 0x61 /* a */, 0x62 /* b */, 0x63 /* c */, 0x64 /* d */, 0x65 /* e */, 0x66 /* f */, 0x67 /* g */, 0x68 /* h */, 0x69 /* i */, 0x6a /* j */, 0x6b /* k */, 0x6c /* l */, 0x6d /* m */, 0x6e /* n */, 0x6f /* o */, 0x70 /* p */, 0x71 /* q */, 0x72 /* r */, 0x73 /* s */, 0x74 /* t */, 0x75 /* u */, 0x76 /* v */, 0x77 /* w */, 0x78 /* x */, 0x79 /* y */, 0x7a /* z */, 0x41 /* A */, 0x42 /* B */, 0x43 /* C */, 0x44 /* D */, 0x45 /* E */, 0x46 /* F */, 0x47 /* G */, 0x48 /* H */, 0x49 /* I */, 0x4a /* J */, 0x4b /* K */, 0x4c /* L */, 0x4d /* M */, 0x4e /* N */, 0x4f /* O */, 0x50 /* P */, 0x51 /* Q */, 0x52 /* R */, 0x53 /* S */, 0x54 /* T */, 0x55 /* U */, 0x56 /* V */, 0x57 /* W */, 0x58 /* X */, 0x59 /* Y */, 0x5a /* Z */, 0x30 /* 0 */, 0x31 /* 1 */, 0x32 /* 2 */, 0x33 /* 3 */, 0x34 /* 4 */, 0x35 /* 5 */, 0x36 /* 6 */, 0x37 /* 7 */, 0x38 /* 8 */, 0x39 /* 9 */, 0x3b /* ; */, 0x2d /* - */, 0x27 /* ' */, 0x28 /* ( */, 0x29 /* ) */, 0x2b /* + */, 0x2c /* , */, 0x2e /* . */, 0x2f /* / */, 0x3a /* : */, 0x3d /* = */, 0x3f /* ? */, 0x3b /* ; */, 0x21 /* ! */, 0x2a /* * */, 0x23 /* # */, 0x40 /* @ */, 0x24 /* $ */, 0x5f /* _ */, 0x25 /* % */, 0x00, };
  static DOMChar cls_pubidchar2[] = { 0x20 /*   */, 0x0d /* \r */, 0x0a /* \n */, 0x61 /* a */, 0x62 /* b */, 0x63 /* c */, 0x64 /* d */, 0x65 /* e */, 0x66 /* f */, 0x67 /* g */, 0x68 /* h */, 0x69 /* i */, 0x6a /* j */, 0x6b /* k */, 0x6c /* l */, 0x6d /* m */, 0x6e /* n */, 0x6f /* o */, 0x70 /* p */, 0x71 /* q */, 0x72 /* r */, 0x73 /* s */, 0x74 /* t */, 0x75 /* u */, 0x76 /* v */, 0x77 /* w */, 0x78 /* x */, 0x79 /* y */, 0x7a /* z */, 0x41 /* A */, 0x42 /* B */, 0x43 /* C */, 0x44 /* D */, 0x45 /* E */, 0x46 /* F */, 0x47 /* G */, 0x48 /* H */, 0x49 /* I */, 0x4a /* J */, 0x4b /* K */, 0x4c /* L */, 0x4d /* M */, 0x4e /* N */, 0x4f /* O */, 0x50 /* P */, 0x51 /* Q */, 0x52 /* R */, 0x53 /* S */, 0x54 /* T */, 0x55 /* U */, 0x56 /* V */, 0x57 /* W */, 0x58 /* X */, 0x59 /* Y */, 0x5a /* Z */, 0x30 /* 0 */, 0x31 /* 1 */, 0x32 /* 2 */, 0x33 /* 3 */, 0x34 /* 4 */, 0x35 /* 5 */, 0x36 /* 6 */, 0x37 /* 7 */, 0x38 /* 8 */, 0x39 /* 9 */, 0x3b /* ; */, 0x2d /* - */, 0x28 /* ( */, 0x29 /* ) */, 0x2b /* + */, 0x2c /* , */, 0x2e /* . */, 0x2f /* / */, 0x3a /* : */, 0x3d /* = */, 0x3f /* ? */, 0x3b /* ; */, 0x21 /* ! */, 0x2a /* * */, 0x23 /* # */, 0x40 /* @ */, 0x24 /* $ */, 0x5f /* _ */, 0x25 /* % */, 0x00, };

  DOMString* str = new DOMString();
  if (CHECK(XMLToken::str_dquote))
  {
    if (!getClassString(CARG(cls_pubidchar), str))
    {
      throw XMLParseError(139, "can't find pubid literal after \".");
    }
    if (!CHECK(XMLToken::str_dquote))
    {
      throw XMLParseError(140, "can't find publid literal close \"");
    }
  }
  else if (CHECK(XMLToken::str_quote))
  {
    if (!getClassString(CARG(cls_pubidchar2), str))
    {
      throw XMLParseError(141, "can't find pubid literal after '.");
    }
    if (!CHECK(XMLToken::str_quote))
    {
      throw XMLParseError(142, "can't find publid literal colose '");
    }
  }
  else
  {
    delete str;
    throw XMLParseError(143, "can't find pubid literal");
  }
  return str;
}

//! \code
//! [45] 
//! elementdecl  ::= '<!ELEMENT' S Name S contentspec S? '>'
//! [46]
//! contentspec  ::= 'EMPTY' | 'ANY' | Mixed | children
//! [51] 
//! Mixed  ::= '(' S? '#PCDATA' ( S? '|' S? Name )* S? ')*'
//!          | '(' S? '#PCDATA' S? ')'
//! [47] 
//! children ::= ( choice | seq ) ( '?' | '*' | '+' )?
//! [49]
//! choice  ::= '(' S? cp ( S? '|' S? cp )+ S? ')'
//! [50] 
//! seq  ::= '(' S? cp ( S? ',' S? cp )* S? ')'
//! [48]
//! cp  ::= ( Name | choice | seq ) ( '?' | '*' | '+' )?
//! =>
//! contentspec  ::= 'EMPTY'
//!                | 'ANY'
//!                | '(' S? '#PCDATA' ( S? '|' S? Name )* S? ')*'
//!                | '(' S? '#PCDATA' S? ')'
//!                | '(' S? cp S? ( ( '|' S? cp S? )+ | ( ',' S? cp S? )* ) S? ')' ( '?' | '*' | '+' )?
//! cp  ::= ( Name | '(' S? cp S? ( ( '|' S? cp S? )+ | ( ',' S? cp S? )* ) S? ')' ( '?' | '*' | '+' )?
//! \endcode
bool
XMLParser::parseElementdecl(bool l1_p)
{
  // '<!ELEMENT'
  if (l1_p)
  {
    return CHECK(XMLToken::str_element_start);
  }
  // S
  parseS();
  // Name
  DOMString* str = getName();
  DtdElement* element = new DtdElement(document, str);
  DtdECUnit* spec = element->getSpec();
  document_type->addDtdElement(element, !ext_subset_processing_p);
  //show("DTD ELEMENT:", str);
  delete str;
  // S
  parseS();
  // contentspec
  //      ::= 'EMPTY'
  //        | 'ANY'
  //        | '(' S? '#PCDATA' ( S? '|' S? Name )* S? ')*'
  //        | '(' S? '#PCDATA' S? ')'
  //        | '(' S? cp S? ( ( '|' S? cp S? )+ | ( ',' S? cp S? )* ) S? ')' ( '?' | '*' | '+' )?
  if (CHECK(XMLToken::str_empty))		// 'EMPTY'
  {
    // EMPTY
    spec->setUnitType(DtdECUnit::UT_TIP_EMPTY);
    //printf("ELEMENT is EMPTY\n");
  }
  else if (CHECK(XMLToken::str_any))	// 'ANY'
  {
    // ANY
    spec->setUnitType(DtdECUnit::UT_TIP_ANY);
    //printf("ELEMENT is ANY\n");
  }
  else if (CHECK(XMLToken::str_openbr))	// '('
  {
    // S?
    if (parseS(true))
    {
      parseS(false);
    }
    if (CHECK(XMLToken::str_pcdata))	// '#PCDATA'
    {
      //printf("PCDATA\n");
      DtdECUnit* unit = new DtdECUnit(document, DtdECUnit::UT_TIP_PCDATA);
      // ( S? '|' S? Name )* S? ')*'
      // S? ')'
      if (parseS(true))
      {
	parseS(false);
      }
      if (CHECK(XMLToken::str_or))	// '|'
      {
	spec->setUnitType(DtdECUnit::UT_MIXED_CHOICE);
	spec->addChildren(unit);
	// '(' S? '#PCDATA' ( S? '|' S? Name )* S? ')*'
	do
	{
	  if (parseS(true))
	  {
	    parseS(false);
	  }
	  DOMString* str = getName();	// Name
	  unit = new DtdECUnit(document, DtdECUnit::UT_TIP_NAME);
	  unit->setName(str);
	  spec->addChildren(unit);
	  //show("name:", str);
	  delete str;
	  if (parseS(true))
	  {
	    parseS(false);
	  }
	} while (CHECK(XMLToken::str_or));	// '|'
	if (parseS(true))
	{
	  parseS(false);
	}
	if (!CHECK(XMLToken::str_closebr))	// ')'
	{
	  throw XMLParseError(144, "ELEMENT definition syntax error. can't find close brace ')'.");
	}
	if (!CHECK(XMLToken::str_aster))		// '*'
	{
	  throw XMLParseError(145, "ELEMENT definition syntax error. can't find close brace ')*'.");
	}
      }
      else if (CHECK(XMLToken::str_closebr))	// ')'
      {
	// '(' S? '#PCDATA' S? ')'
	spec->setUnitType(DtdECUnit::UT_MIXED_ONE);
	spec->addChildren(unit);
      }
      else
      {
	throw XMLParseError(146, "ELEMENT definition syntax error.");
      }
    }
    else
    {
      // cp S? ( ( '|' S? cp S? )+ | ( ',' S? cp S? )* ) S? ')' ( '?' | '*' | '+' )?
      spec->setUnitType(DtdECUnit::UT_SEQUENCE);	// default
      DtdECUnit* unit = parseCp();
      spec->addChildren(unit);
      if (parseS(true))
      {
	parseS(false);
      }
      if (CHECK(XMLToken::str_or))		// '|'
      {
	spec->setUnitType(DtdECUnit::UT_CHOICE);
	do
	{
	  if (parseS(true))
	  {
	    parseS(false);
	  }
	  unit = parseCp();
	  spec->addChildren(unit);
	  if (parseS(true))
	  {
	    parseS(false);
	  }
	} while (CHECK(XMLToken::str_or));	// '|'
      }
      else if (CHECK(XMLToken::str_seq))		// ','
      {
	do
	{
	  if (parseS(true))
	  {
	    parseS(false);
	  }
	  unit = parseCp();
	  spec->addChildren(unit);
	  if (parseS(true))
	  {
	    parseS(false);
	  }
	} while (CHECK(XMLToken::str_seq));	// ','
      }
      if (!CHECK(XMLToken::str_closebr))		// ')'
      {
	throw XMLParseError(147, "can't find close brace.");
      }
      if (CHECK(XMLToken::str_question))		// '?'
      {
	spec->orUnitType(DtdECUnit::UT_REP_ZERO_OR_ONE);
	//printf("?");
      }
      else if (CHECK(XMLToken::str_aster))	// '*'
      {
	spec->orUnitType(DtdECUnit::UT_REP_ZERO_OR_MORE);
	//printf("*");
      }
      else if (CHECK(XMLToken::str_plus))		// '+'
      {
	spec->orUnitType(DtdECUnit::UT_REP_ONE_OR_MORE);
	//printf("+");
      }
    }
  }
  // S?
  if (parseS(true))
  {
    parseS(false);
  }
  // '>'
  if (!CHECK(XMLToken::str_close))
  {
    throw XMLParseError(148, "can't find element definition close '>'.");
  }
  return true;
}

//! \code
//! [48]
//! cp  ::= ( Name | choice | seq ) ( '?' | '*' | '+' )?
//! [49]
//! choice  ::= '(' S? cp ( S? '|' S? cp )+ S? ')'
//! [50] 
//! seq  ::= '(' S? cp ( S? ',' S? cp )* S? ')'
//! cp  ::= ( Name | '(' S? cp S? ( ( '|' S? cp S? )+ | ( ',' S? cp S? )* ) S? ')' ) ( '?' | '*' | '+' )?
//! \endcode
DtdECUnit*
XMLParser::parseCp()
{
  DtdECUnit* cp = new DtdECUnit(document);
  if (CHECK(XMLToken::str_openbr))	// '('
  {
    cp->setUnitType(DtdECUnit::UT_SEQUENCE);	// default
    if (parseS(true))
    {
      parseS(false);
    }
    // cp S? ( ( '|' S? cp S? )+ | ( ',' S? cp S? )* ) S? ')'
    DtdECUnit* unit = parseCp();
    cp->addChildren(unit);
    if (parseS(true))
    {
      parseS(false);
    }
    if (CHECK(XMLToken::str_or))	// '|'
    {
      cp->setUnitType(DtdECUnit::UT_CHOICE);
      //printf("cp:|\n");
      do
      {
	if (parseS(true))
	{
	  parseS(false);
	}
	unit = parseCp();
	cp->addChildren(unit);
	if (parseS(true))
	{
	  parseS(false);
	}
      } while (CHECK(XMLToken::str_or));	// '|'
    }
    else if (CHECK(XMLToken::str_seq))	// ','
    {
      //printf("cp:,\n");
      do
      {
	if (parseS(true))
	{
	  parseS(false);
	}
	unit = parseCp();
	cp->addChildren(unit);
	if (parseS(true))
	{
	  parseS(false);
	}
      } while (CHECK(XMLToken::str_seq));	// ','
    }
    if (!CHECK(XMLToken::str_closebr))	// ')'
    {
      throw XMLParseError(149, "can't find close brace.");
    }
  }
  else
  {
    DOMString* str = getName();
    cp->setUnitType(DtdECUnit::UT_TIP_NAME);
    cp->setName(str);
    //show("cp unit:", str);
    delete str;
  }
  if (CHECK(XMLToken::str_question))	// '?'
  {
    cp->orUnitType(DtdECUnit::UT_REP_ZERO_OR_ONE);
    //printf("cp:?\n");
  }
  else if (CHECK(XMLToken::str_aster))	// '*'
  {
    cp->orUnitType(DtdECUnit::UT_REP_ZERO_OR_MORE);
    //printf("cp:*\n");
  }
  else if (CHECK(XMLToken::str_plus))	// '+'
  {
    cp->orUnitType(DtdECUnit::UT_REP_ONE_OR_MORE);
    //printf("cp:+\n");
  }
  return cp;
}

//! \code
//! [52] 
//! AttlistDecl ::= '<!ATTLIST' S Name AttDef* S? '>'
//! [53]
//! AttDef  ::= S Name S AttType S DefaultDecl
//! =>
//! AttlistDecl ::= '<!ATTLIST' S Name (S Name S AttType S DefaultDecl)* S? '>'
//! \endcode
bool
XMLParser::parseAttlistDecl(bool l1_p)
{
  if (l1_p)
  {
    return CHECK(XMLToken::str_attlist_start);
  }
  // S
  parseS();
  DOMString* element_name = getName();
  DtdElement* element = document_type->findDtdElement(element_name);
  if (!element)
  {
    if ((option & IGNORE_DTD_UNRESOLVED_ENTITY_REFERENCE) == 0)
    {
      throw XMLParseError(150, "Corresponding ELEMENT isn't defined.");
    }
  }
  //show("ATTLIST:", element_name);
  delete element_name;
  
  // AttDef* S? '>'
  bool first_attdef_p = true;
  DtdAttlist* attlist = 0;
  for (;;)
  {
    if (parseS(true))
    {
      parseS(false);
    }
    if (CHECK(XMLToken::str_close))
    {
      break;
    }
    // Name
    DOMString* attr_name = getName();
    attlist = new DtdAttlist(document, attr_name, first_attdef_p);
    if (element)
    {
      element->appendChild(attlist);
    }
    if (!ext_subset_processing_p)
    {
      document_type->addDtdInternals(attlist);
    }
    // S
    parseS();
    // AttType
    parseAttType(attlist);
    // S
    parseS();
    // DefaultDecl
    parseDefaultDecl(attlist);
    first_attdef_p = false;
    if (element == 0)
    {
      delete attlist;
      attlist = 0;
    }
  }
  if (attlist)
  {
    attlist->setLastAddDefP();
  }
  return true;
}

//! \code
//! [54] 
//! AttType ::= StringType | TokenizedType | EnumeratedType
//! [55] 
//! StringType ::= 'CDATA'
//! [56] 
//! TokenizedType ::= 'ID'
//!                | 'IDREF'
//!                | 'IDREFS'
//!                | 'ENTITY'
//!                | 'ENTITIES'
//!                | 'NMTOKEN'
//!                | 'NMTOKENS'
//! [57] 
//! EnumeratedType ::= NotationType | Enumeration
//! [58] 
//! NotationType ::= 'NOTATION' S '(' S? Name ( S? '|' S? Name )* S? ')'
//! [59] 
//! Enumeration ::= '(' S? Nmtoken ( S? '|' S? Nmtoken )* S? ')'
//!=>
//! AttType ::= 'CDATA'
//!           | 'ID'
//!           | 'IDREF'
//!           | 'IDREFS'
//!           | 'ENTITY'
//!           | 'ENTITIES'
//!           | 'NMTOKEN'
//!           | 'NMTOKENS'
//!           | 'NOTATION' S '(' S? Name S? ( '|' S? Name S? )* ')'
//!           | '(' S? Nmtoken S? ( '|' S? Nmtoken S? )* ')'
//! \endcode
void
XMLParser::parseAttType(DtdAttlist* attlist)
{
  // NOTE: Parser searches from those where the pattern
  // character string is long.
  if (CHECK(XMLToken::str_cdata))
  {
    attlist->setAttType(DtdAttlist::ATTTYPE_CDATA);
    //printf("cdata\n");
  }
  else if (CHECK(XMLToken::str_idrefs))
  {
    attlist->setAttType(DtdAttlist::ATTTYPE_IDREFS);
    //printf("idrefs\n");
  }
  else if (CHECK(XMLToken::str_idref))
  {
    attlist->setAttType(DtdAttlist::ATTTYPE_IDREF);
    //printf("idref\n");
  }
  else if (CHECK(XMLToken::str_id))
  {
    attlist->setAttType(DtdAttlist::ATTTYPE_ID);
    //printf("id\n");
  }
  else if (CHECK(XMLToken::str_entities))
  {
    attlist->setAttType(DtdAttlist::ATTTYPE_ENTITIES);
    //printf("entities\n");
  }
  else if (CHECK(XMLToken::str_entity))
  {
    attlist->setAttType(DtdAttlist::ATTTYPE_ENTITY);
    //printf("entity\n");
  }
  else if (CHECK(XMLToken::str_nmtokens))
  {
    attlist->setAttType(DtdAttlist::ATTTYPE_NMTOKENS);
    //printf("nmtokens\n");
  }
  else if (CHECK(XMLToken::str_nmtoken))
  {
    attlist->setAttType(DtdAttlist::ATTTYPE_NMTOKEN);
    //printf("nmtoken\n");
  }
  else if (CHECK(XMLToken::str_notation))
  {
    attlist->setAttType(DtdAttlist::ATTTYPE_NOTATION);
    //printf("notation\n");
    // S '(' S? Name S? ( '|' S? Name S? )* ')'
    parseS();
    // '('
    if (!CHECK(XMLToken::str_openbr))
    {
      throw XMLParseError(151, "can't find '(' in the notation definition");
    }
    // Name
    DOMString* name = getName();
    attlist->addCandidate(name);
    //show("notations:", name);
    delete name;
    if (parseS(true))
    {
      parseS(false);
    }
    // ( '|' S? Name S? )*
    while (CHECK(XMLToken::str_or))
    {
      // S?
      if (parseS(true))
      {
	parseS(false);
      }
      // Name
      name = getName();
      attlist->addCandidate(name);
      //show("notations:", name);
      delete name;
      // S?
      if (parseS(true))
      {
	parseS(false);
      }
    }
    if (!CHECK(XMLToken::str_closebr))
    {
      throw XMLParseError(152, "can't find ')' in the NotationType definition");
    }
  }
  else if (CHECK(XMLToken::str_openbr))
  {
    attlist->setAttType(DtdAttlist::ATTTYPE_CANDIDATES);
    //printf("openbr\n");
    // S? Nmtoken S? ( '|' S? Nmtoken S? )* ')'
    // S?
    if (parseS(true))
    {
      parseS(false);
    }
    DOMString* nm = getNmtoken();
    attlist->addCandidate(nm);
    //show("enumeration:", nm);
    delete nm;
    // S?
    if (parseS(true))
    {
      parseS(false);
    }
    while (CHECK(XMLToken::str_or))
    {
      // S?
      if (parseS(true))
      {
	parseS(false);
      }
      // Name
      nm = getNmtoken();
      attlist->addCandidate(nm);
      //show("enumerations:", nm);
      delete nm;
      // S?
      if (parseS(true))
      {
	parseS(false);
      }
    }
    if (!CHECK(XMLToken::str_closebr))
    {
      throw XMLParseError(153, "can't find ')' in the Enumeration definition");
    }
  }
}

//! \code
//! [60]
//! DefaultDecl ::= '#REQUIRED'
//!               | '#IMPLIED'
//!               | (('#FIXED' S )? AttValue )
//!=>
//! DefaultDecl ::= '#REQUIRED'
//!               | '#IMPLIED'
//!               | '#FIXED' S AttValue
//!               |  AttValue
//! \endcode
void
XMLParser::parseDefaultDecl(DtdAttlist* attlist)
{
  if (CHECK(XMLToken::str_required))
  {
    attlist->setDefaultType(DtdAttlist::DEFAULTTYPE_REQUIRED);
    //printf("required\n");
  }
  else if (CHECK(XMLToken::str_implied))
  {
    attlist->setDefaultType(DtdAttlist::DEFAULTTYPE_IMPLIED);
    //printf("implied\n");
  }
  else if (CHECK(XMLToken::str_fixed))
  {
    attlist->setDefaultType(DtdAttlist::DEFAULTTYPE_FIXED);
    // S
    parseS();
    // AttValue
    DOMString* av = getAttValue();
    attlist->setDefaultValue(av);
    //show("fixed attvalue:", av);
    delete av;
  }
  else
  {
    attlist->setDefaultType(DtdAttlist::DEFAULTTYPE_DEFAULT);
    // AttValue
    DOMString* av = getAttValue();
    attlist->setDefaultValue(av);
    //show("attvalue:", av);
    delete av;
  }
}

//! \code
//! [70] 
//! EntityDecl  ::= GEDecl | PEDecl
//! [71] 
//! GEDecl  ::= '<!ENTITY' S Name S EntityDef S? '>'
//! [72] 
//! PEDecl  ::= '<!ENTITY' S '%' S Name S PEDef S? '>'
//! [73]
//! EntityDef ::= EntityValue | ( ExternalID NDataDecl? )
//! [74] 
//! PEDef ::= EntityValue | ExternalID
//! [76] 
//! NDataDecl ::= S 'NDATA' S Name
//!=>
//! EntityDecl  ::= '<!ENTITY' S Name S ( EntityValue | ( ExternalID NDataDecl? ) ) S? '>'
//!               | '<!ENTITY' S '%' S Name S ( EntityValue | ExternalID ) S? '>'
//!=>
//! EntityDecl  ::= '<!ENTITY' S '%' S Name S ( EntityValue | ExternalID1 | ExternalID2 ) S? '>'
//!               | '<!ENTITY' S Name S ( EntityValue | ( ( ExternalID1 | ExternalID2 ) ( S 'NDATA' S Name )? ) ) S? '>'
//! \endcode
bool
XMLParser::parseEntityDecl(bool l1_p)
{
  if (l1_p)
  {
    return CHECK(XMLToken::str_entity_start);
  }
  parseS();
  if (CHECK(XMLToken::str_percent))	// '%'
  {
    parseS();
    DOMString* name = getName();
    DtdPEntity* pe = new DtdPEntity(document, name);
    document_type->addDtdPEntity(pe, !ext_subset_processing_p);
    //show("pececl:", name);
    delete name;
    parseS();
    // ( EntityValue | ExternalID1 | ExternalID2 )
    if (parseExternalID1(true, pe))
    {
      parseExternalID1(false, pe);
    }
    else if (parseExternalID2(true, pe))
    {
      parseExternalID2(false, pe);
    }
    else
    {
      DOMString* str = getEntityValue();
      pe->setNodeValue(str);
      //show("entity value:", str);
      delete str;
    }
  }
  else
  {
    DOMString* name = getName();
    Entity* entity = new Entity(document, name);
    document_type->addDtdEntity(entity, !ext_subset_processing_p);
    //show("gedecl:", name);
    delete name;
    parseS();
    // ( EntityValue | ( ( ExternalID1 | ExternalID2 ) (S 'NDATA' S Name)? ) )
    if (parseExternalID1(true, entity))
    {
      parseExternalID1(false, entity);
      if (parseS(true))
      {
	parseS(false);
      }
      if (CHECK(XMLToken::str_ndata))
      {
	parseS();
	DOMString* str = getName();
	entity->setNdata(str);
	delete str;
      }
    }
    else if (parseExternalID2(true, entity))
    {
      parseExternalID2(false, entity);
      if (parseS(true))
      {
	parseS(false);
      }
      if (CHECK(XMLToken::str_ndata))
      {
	parseS();
	DOMString* str = getName();
	entity->setNdata(str);
	delete str;
      }
    }
    else
    {
      DOMString* str = getEntityValue();
      entity->setEntityValue(str);
      //show("entity value:", str);
      delete str;
    }
  }
  // S?
  if (parseS(true))
  {
    parseS(false);
  }
  // '>'
  if (!CHECK(XMLToken::str_close))
  {
    throw XMLParseError(154, "can't find a close '>' of entity definition.");
  }
  return true;
}

//! \code
//! [82] 
//! NotationDecl ::= '<!NOTATION' S Name S ( ExternalID | PublicID ) S? '>'
//!=>
//! NotationDecl ::= '<!NOTATION' S Name S ( ExternalID1 | ExternalID2 | PublicID ) S? '>'
//! ExternalID1 ::= 'SYSTEM' S SystemLiteral
//! ExternalID2 ::= 'PUBLIC' S PubidLiteral S SystemLiteral
//! PublicID ::= 'PUBLIC' S PubidLiteral
//!=>
//! NotationDecl ::= '<!NOTATION' S Name S ( ExternalID1 | PublicID ) S? '>'
//! ExternalID1 ::= 'SYSTEM' S SystemLiteral
//! PublicID ::= 'PUBLIC' S PubidLiteral (S SystemLiteral)?
//! \endcode
bool
XMLParser::parseNotationDecl(bool l1_p)
{
  if (l1_p)
  {
    return CHECK(XMLToken::str_notation_start);
  }
  parseS();
  DOMString* name = getName();
  Notation* notation = new Notation(document, name);
  document_type->addDtdNotation(notation, !ext_subset_processing_p);
  //show("notation:", name);
  delete name;
  parseS();
  if (parseExternalID1(true, notation))
  {
    parseExternalID1(false, notation);
  }
  else if (parsePublicID(true, notation))
  {
    parsePublicID(false, notation);
  }
  else
  {
    throw XMLParseError(155, "notation definition syntax error.");
  }
  // S?
  if (parseS(true))
  {
    parseS(false);
  }
  // '>'
  if (!CHECK(XMLToken::str_close))
  {
    throw XMLParseError(156, "can't find a close '>' of entity definition.");
  }
  return true;
}

//! \code
//! [83] 
//! PublicID ::= 'PUBLIC' S PubidLiteral
//!=>
//! PublicID ::= 'PUBLIC' S PubidLiteral (S SystemLiteral)?
//! \endcode
//! see bool XMLParser::parseNotationDecl(bool l1_p).
bool
XMLParser::parsePublicID(bool l1_p, Notation* notation)
{
  if (l1_p)
  {
    // 'PUBLIC'
    return CHECK(XMLToken::str_externalidpublic);
  }
  // S
  parseS();
  // PubidLiteral
  DOMString* pubid = getPubidLiteral();
  notation->setPublicId(pubid);
  //show("publicid pubidliteral:", pubid);
  delete pubid;
  // S?
  if (parseS(true))
  {
    parseS(false);
  }
  // SystemLiteral?
  DOMString* system_literal = getSystemLiteral(true);
  if (system_literal)
  {
    notation->setSystemId(system_literal);
  }
  return true;
}

//! \code
//! [39]
//! element ::= EmptyElemTag
//!           | STag content ETag
//! [40] 
//! STag  ::= '<' Name ( S Attribute )* S? '>'
//! [44] 
//! EmptyElemTag  ::= '<' Name ( S Attribute )* S? '/>'
//! [43]
//! content ::= CharData? ( ( element | Reference | CDSect | PI | Comment ) CharData? )*
//! [14]
//! CharData ::= [^<&]* - ( [^<&]* ']]>' [^<&]* )
//!=>
//! element ::= '<' Name ( S Attribute )* S? ( '/>' | ( '>' content ETag ) )
//! content ::= ( ( element | Reference | CDSect | PI | Comment | CharData )*
//! CharData ::= [^<&]* - ( [^<&]* ']]>' [^<&]* )
//! \endcode
bool
XMLParser::parseElement(bool l1_p, Node* parent)
{
//  static DOMChar str_x[] = u"]]>";
  static DOMChar dlm1[] = { 0x3c /* < */, 0x26 /* & */, 0x00, };

  if (l1_p)
  {
    return CHECK(XMLToken::str_open);
  }
  DOMString* name = getName();
  Element* element = 0;
  bool post_namespace_uri_check_p = false;
  if (do_not_support_namespace_p)
  {
    // DOM Level 1: 名前空間をサポートしません。
    element = document->createElement(name);
  }
  else
  {
    // DOM Level 2: Elementの名前空間をサポートします。
    {
      DOMChar* s = name->getStartPtr();
      Size len = name->getLength();
      while (len > 0)
      {
	if (*s++ == (DOMChar)':')
	{
	  break;
	}
	len--;
      }
      if (len != 0)
      {
	// nameがQName形式ならプレフィックスを取り出し該当する名前空間URIを名前空間スタックから探します。
	DOMString* prefix_atom = document->getPrefixAtomFromQualifiedName(name);
	const DOMString* namespace_uri = findNamespaceUri(prefix_atom);
	if (!namespace_uri)
	{
	  // このエレメントでこの名前空間が定義される可能性があるので、
	  // ひとまずエレメントをDOM Level 1の方法で作成し、フラグを
	  // セットし、閉じタグの解析時に再度名前空間の解析を行ないます。
	  element = document->createElement(name);
	  post_namespace_uri_check_p = true;
	}
	else
	{
	  element = document->createElementNS(namespace_uri, name);
	}
      }
      else
      {
	const DOMString* namespace_uri = findNonamePrefixNamespaceUri();
	// nameがNameなら空プレフィックスの名前空間を名前空間スタックから探します。
	if (namespace_uri)
	{
	  element = document->createElementNS(namespace_uri, name);
	}
	else
	{
	  // 空プレフィックスが存在しなければ、DOM Level 1の方法で処理します。
	  element = document->createElement(name);
	  post_namespace_uri_check_p = true;
	}
      }
    }
  }

  parent->appendChild(element);
  //show("Element:", name);

  for (;;)
  {
    if (parseS(true))
    {
      parseS(false);
    }
    if (CHECK(XMLToken::str_close))
    {
      if (!do_not_support_namespace_p)
      {
	// DOM Level 2: 属性の名前空間をサポートします。
	parseAttributeNS(element);
	if (post_namespace_uri_check_p)
	{
	  // エレメントの生成時に名前空間を特定できなかったので、
	  // ここで再度調べます。
	  DOMString* prefix_atom = document->getPrefixAtomFromQualifiedName(name);
	  const DOMString* namespace_uri = findNamespaceUri(prefix_atom);
	  if (namespace_uri != 0)
	  {
	    element->setNodeNameNS(namespace_uri, name);
	  }
	  else if (prefix_atom->getLength() > 0)
	  {
	    // ERROR
	    /* 定義されていないプレフィックスが指定されました。*/
	    throw XMLParseError(169, "undefined namespace prefix is used.");
	  }
	}
      }
      Text* text = 0;
      // '>' content ETag
      for (;;)
      {
	if (parseETag(true))		// </
	{
	  parseETag(false);
#ifndef CODEX_PURE_DOM
	  if ((option & KEEP_REDUNDANT_EMPTY_TAG_EXPRESSION) != 0)
	  {
	    if (!element->hasChildNodes())
	    {
	      element->setRedundantEmptyTagExpressionP(true);
	    }
	  }
#endif /* CODEX_PURE_DOM */
	  if (!do_not_support_namespace_p)
	  {
	    // DOM Level 2: 属性の名前空間をサポートします。
	    exitNamespace(element);
	  }
	  break;
	}
	else if (parseReference(true, 0))	// &
	{
	  DOMString* str;
	  if (text)
	  {
	    str = (DOMString*)text->getData();
	  }
	  else
	  {
	    str = new DOMString();
	  }
	  parseReference(false, str);
	  if (!text)
	  {
	    text = document->createTextNode(str);
	    element->appendChild(text);
	  }
	}
	else if (parseCDSect(true, element))	// <![CDATA
	{
	  parseCDSect(false, element);
	  text = 0;
	}
	else if (parsePI(true, element))	// <?
	{
	  parsePI(false, element);
	  text = 0;
	}
	else if (parseComment(true, element))	// <!--
	{
	  parseComment(false, element);
	  text = 0;
	}
	else if (parseElement(true, element))	// <
	{
	  parseElement(false, element);
	  text = 0;
	}
	else
	{
	  // CharData
	  DOMString* s = getStringDC(CARG(dlm1));
	  if (!s)
	  {
	    throw XMLParseError(171, "invalid end of source.");
	    break;
	  }
	  if (text)
	  {
	    DOMString* str = (DOMString*)text->getData();
	    str->add(*s);
	  }
	  else
	  {
	    text = document->createTextNode(s);
	    element->appendChild(text);
	  }
	  // TODO: It is nessary to check whether s has the character string of ']]>'.
	  //show("CharData:", s);
	  delete s;
	}
      }
      break;
    }
    else if (CHECK(XMLToken::str_empclose))
    {
      if (!do_not_support_namespace_p)
      {
	// DOM Level 2: 属性の名前空間をサポートします。
	parseAttributeNS(element);
	if (post_namespace_uri_check_p)
	{
	  // エレメントの生成時に名前空間を特定できなかったので、
	  // ここで再度調べます。
	  DOMString* prefix_atom = document->getPrefixAtomFromQualifiedName(name);
	  const DOMString* namespace_uri = findNamespaceUri(prefix_atom);
	  if (namespace_uri != 0)
	  {
	    element->setNodeNameNS(namespace_uri, name);
	  }
	  else if (prefix_atom->getLength() > 0)
	  {
	    // ERROR
	    /* 定義されていないプレフィックスが指定されました。*/
	    throw XMLParseError(170, "undefined namespace prefix is used.");
	  }
	}
	exitNamespace(element);
      }
      break;
    }
    else
    {
      parseAttribute(element);
    }
  }
  delete name;
  return true;
}

//! \code
//! [41]
//! Attribute ::= Name Eq AttValue
//! \endcode
void
XMLParser::parseAttribute(Element* element)
{
  DOMString* name = getName();
  //show("attr name:", name);
  if (element->getAttributeNode(name))
  {
    throw XMLParseError(157, "attribute is duplicated.");
  }
  parseEq();
  DOMString* av = getAttValue();
  //show("attr value:", av);
  if (do_not_support_namespace_p)
  {
    // DOM Level 1: 名前空間をサポートしません。
    element->setAttribute(name, av);
  }
  else
  {
    // DOM Level 2: 属性の名前空間をサポートします。
    // nameがxmlnsなら空プレフィックスの名前空間を定義します。
    if (name->strCmp(XMLToken::str_xmlns) == 0)
    {
      // 空プレフィックスで名前空間定義をスタックに作成します。
      DOMString null(XMLToken::str_null);
      enterNamespace(&null, av, element);
      element->setAttributeNS(av, name, av);
    }
    else
    {
      DOMChar* s = name->getStartPtr();
      Size len = name->getLength();
      while (len > 0)
      {
	if (*s++ == (DOMChar)':')
	{
	  break;
	}
	len--;
      }
      if (len != 0)
      {
	DOMString* prefix_atom = document->getPrefixAtomFromQualifiedName(name);
	if (prefix_atom->strCmp(XMLToken::str_xmlns) == 0)
	{
	  // nameがxmlns:Xの形式なのでXのプレフィックスの名前空間をスタックに定義します。
	  DOMString* local_name_atom = document->getLocalNameFromQualifiedName(name);
	  enterNamespace(local_name_atom, av, element);

	  // 名前空間定義として属性をエレメントに登録します。
	  // xmlns:foo="uri"
	  DOMString s_xmlns_uri(XMLToken::str_xmlns_uri);
	  element->setAttributeNS(&s_xmlns_uri, name, av);
	}
	else
	{
#if 1
	  // xmlns以外のプレフィックスが指定されたので、名前空間付きの属性
	  // ひとまず名前空間無しの属性としてエレメントに登録します。
	  // エレメントの閉じタグのパース後に、名前空間付きの属性として登録
	  // し直します。
	  element->setAttribute(name, av);
#else
	  // 同じエレメント内で定義された名前空間を属性として使用しないのならば
	  // この#elseブロックの処理で十分です。

	  // nameがQName形式ならプレフィックスを取り出し該当する名前空間URIを名前空間スタックから探します。
	  const DOMString* namespace_uri = findNamespaceUri(prefix_atom);
	  if (!namespace_uri)
	  {
	    // ERROR
	    /* 定義されていないプレフィックスが指定されました。*/
	    throw XMLParseError(172, "undefined namespace prefix is used.");
	  }
	  element->setAttributeNS(namespace_uri, name, av);
#endif
	}
      }
      else
      {
#if 1
	// ひとまず名前空間無しの属性としてエレメントに登録します。
	// エレメントの閉じタグのパース後に、無名名前空間付きの属性の可能性を考慮
	// し、必要であれば無名名前空間付きの属性として登録し直します。
	element->setAttribute(name, av);
#else
	// 同じエレメント内で定義された名前空間を属性として使用しないのならば
	// この#elseブロックの処理で十分です。

	const DOMString* namespace_uri = findNonamePrefixNamespaceUri();
	// nameがNameなら空プレフィックスの名前空間を名前空間スタックから探します。
	if (namespace_uri)
	{
	  element->setAttributeNS(namespace_uri, name, av);
	}
	else
	{
	  // 空プレフィックスが存在しなければ、DOM Level 1の方法で処理します。
	  element->setAttribute(name, av);
	}
#endif
      }
    }
  }
  delete name;
  delete av;
}

void
XMLParser::parseAttributeNS(Element* element)
{
  if (do_not_support_namespace_p)
  {
    return;
  }
  NamedNodeMap* map = element->getAttributes();
  Iterator<Node>* it = map->createIterator();
  Node* node;
  while ((node = it->next()))
  {
    assert(node->getNodeType() == Node::ATTRIBUTE_NODE);
    Attr* attr = (Attr*)node;
    const DOMString* name = attr->getNodeName();
    const DOMString* namespace_uri = attr->getNamespaceURI();
    if (namespace_uri == 0)
    {
      // nameがxmlnsなら空プレフィックスの名前空間を定義します。
      if (name->strCmp(XMLToken::str_xmlns) == 0)
      {
	//assert(false);
      }
      else
      {
	DOMChar* s = name->getStartPtr();
	Size len = name->getLength();
	while (len > 0)
	{
	  if (*s++ == (DOMChar)':')
	  {
	    break;
	  }
	  len--;
	}
	if (len != 0)
	{
	  DOMString* prefix_atom = document->getPrefixAtomFromQualifiedName(name);
	  if (prefix_atom->strCmp(XMLToken::str_xmlns) == 0)
	  {
	    //assert(false);
	  }
	  else
	  {
	    // nameがQName形式ならプレフィックスを取り出し該当する名前空間URIを名前空間スタックから探します。
	    const DOMString* namespace_uri = findNamespaceUri(prefix_atom);
	    if (!namespace_uri)
	    {
	      // ERROR
	      /* 定義されていないプレフィックスが指定されました。*/
	      throw XMLParseError(173, "undefined namespace prefix is used.");
	    }
	    attr->setNodeNameNS(namespace_uri, name);
	  }
	}
	else
	{
	  const DOMString* namespace_uri = findNonamePrefixNamespaceUri();
	  // nameがNameなら空プレフィックスの名前空間を名前空間スタックから探します。
	  if (namespace_uri)
	  {
	    node->setNodeNameNS(namespace_uri, name);
	  }
	}
      }
    }
  }
  delete it;
}

//! \code
//! [42] 
//! ETag  ::= '</' Name S? '>'
//! \endcode
bool
XMLParser::parseETag(bool l1_p)
{
  if (l1_p)
  {
    return CHECK(XMLToken::str_etag);
  }
  DOMString* str = getName();
  //show("Element End Tag:", str);
  delete str;
  if (parseS(true))
  {
    parseS(false);
  }
  if (!CHECK(XMLToken::str_close))
  {
    throw XMLParseError(158, "can't find end tag close '>'.");
  }
  return true;
}

//! \code
//! [18]
//! CDSect ::= CDStart CData CDEnd
//! [19]
//! CDStart ::= '<![CDATA['
//! [20]
//! CData ::= ( Char* - ( Char* ']]>' Char*))
//! [21]
//! CDEnd ::= ']]>'
//!=>
//! CDSect ::= '<![CDATA[' CData ']]>'
//! \endcode
bool
XMLParser::parseCDSect(bool l1_p, Node* parent)
{
  if (l1_p)
  {
    return CHECK(XMLToken::str_cdata_start);
  }
  DOMString* str = getStringDS(CARG(XMLToken::str_cdata_end));
  CDATASection* cdata = document->createCDATASection(str);
  parent->appendChild(cdata);
  //show("cdsect:", str);
  delete str;
  if (!CHECK(XMLToken::str_cdata_end))
  {
    throw XMLParseError(159, "can't find CDSect end ']]>'.");
  }
  return true;
}

//! \code
//! [30]
//! extSubset ::= TextDecl? extSubsetDecl
//! \endcode
void
XMLParser::parseExtSubset()
{
  bool prev_p = ext_subset_processing_p;
  ext_subset_processing_p = true;
  if (parseTextDecl(true))
  {
    parseTextDecl(false);
  }
  parseExtSubsetDecl();
  ext_subset_processing_p = prev_p;
}

//! \code
//! [77] 
//! TextDecl ::= '<?xml' VersionInfo? EncodingDecl S? '?>'
//! LL(1)=>
//! TextDecl ::= '<?xml' VersionInfo? S EncodingDecl S? '?>'
//! \endcode
bool
XMLParser::parseTextDecl(bool l1_p)
{
  if (l1_p)
  {
    return CHECK(XMLToken::str_xmldecl_start);
  }
  // VersionInfo?
  if (parseVersionInfo(true))
  {
    parseVersionInfo(false);
  }
  parseS();
  // EncodingDecl
  if (!parseEncodingDecl(true))
  {
    throw XMLParseError(160, "can't find encoding decl.");
  }
  parseEncodingDecl(false);
  // S?
  if (parseS(true))
  {
    parseS(false);
  }
  if (!CHECK(XMLToken::str_xmldecl_end))
  {
    throw XMLParseError(161, "can't find '?>' in the TextDecl.");
  }
  return true;
}

//! \code
//! [31]
//! extSubsetDecl ::= ( markupdecl | conditionalSect | DeclSep )*
//! [28a]
//! DeclSep ::= PEReference | S
//! [29]
//! markupdecl ::= elementdecl | AttlistDecl | EntityDecl | NotationDecl | PI | Comment
//!=>
//! extSubsetDecl ::= ( elementdecl | AttlistDecl | EntityDecl | NotationDecl | PI | Comment | conditionalSect | PEReference | S )*
//! \endcode
void
XMLParser::parseExtSubsetDecl()
{
  for (;;)
  {
    if (parsePEReference(true))
    {
      parsePEReference(false);
    }
    else if (parseS(true))
    {
      parseS(false);
    }
    else if (parseElementdecl(true))
    {
      parseElementdecl(false);
    }
    else if (parseAttlistDecl(true))
    {
      parseAttlistDecl(false);
    }
    else if (parseEntityDecl(true))
    {
      parseEntityDecl(false);
    }
    else if (parseNotationDecl(true))
    {
      parseNotationDecl(false);
    }
    else if (parsePI(true, document_type))
    {
      parsePI(false, document_type);
    }
    else if (parseComment(true, document_type))
    {
      parseComment(false, document_type);
    }
    else if (parseConditionalSect(true))
    {
      parseConditionalSect(false);
    }
    else
    {
      break;
    }
  }
}

//! \code
//! [61] 
//! conditionalSect ::= includeSect | ignoreSect
//! [62] 
//! includeSect  ::= '<![' S? 'INCLUDE' S? '[' extSubsetDecl ']]>'
//! [63] 
//! ignoreSect  ::= '<![' S? 'IGNORE' S? '[' ignoreSectContents* ']]>'
//!=>
//! conditionalSect ::= '<![' S? ( ( 'INCLUDE' S? '[' extSubsetDecl ']]>' ) | 'IGNORE' S? '[' ignoreSectContents* ']]>' )
//! \endcode
bool
XMLParser::parseConditionalSect(bool l1_p)
{
  if (l1_p)
  {
    return CHECK(XMLToken::str_cond_start);
  }
  // S?
  if (parseS(true))
  {
    parseS(false);
  }
  // check PE
  if (parsePEReference(true))
  {
    parsePEReference(false);
    if (parseS(true))
    {
      parseS(false);
    }
  }
  if (CHECK(XMLToken::str_include))
  {
    if (parseS(true))
    {
      parseS(false);
    }
    if (!CHECK(XMLToken::str_markupdecl_start))
    {
      throw XMLParseError(162, "can't find '[' in the INCLUDE conditional section.");
    }
    parseExtSubsetDecl();
    if (!CHECK(XMLToken::str_cond_end))
    {
      throw XMLParseError(163, "can't find ']]>' in the INCLUDE conditional section.");
    }
  }
  else if (CHECK(XMLToken::str_ignore))
  {
    if (parseS(true))
    {
      parseS(false);
    }
    if (!CHECK(XMLToken::str_markupdecl_start))
    {
      throw XMLParseError(164, "can't find '[' in the IGNORE conditional section.");
    }
    while (parseIgnoreSectContents(true))
    {
      parseIgnoreSectContents(false);
    }
    if (!CHECK(XMLToken::str_cond_end))
    {
      throw XMLParseError(165, "can't find ']]>' in the IGNORE conditional section.");
    }
  }
  return true;
}

//! \code
//! [64] 
//! ignoreSectContents ::= Ignore ( '<![' ignoreSectContents ']]>' Ignore )*
//! \endcode
bool
XMLParser::parseIgnoreSectContents(bool l1_p)
{
  if (l1_p)
  {
    DOMString* s = getIgnore();
    delete s;
    return true;
  }
  while (CHECK(XMLToken::str_cond_start))
  {
    if (!parseIgnoreSectContents(true))
    {
      throw XMLParseError(166, "no ignoreSectContents between '<![' and ']]>'.");
    }
    parseIgnoreSectContents(false);
    DOMString* s = getIgnore();
    delete s;
  }
  return true;
}

//! \code
//! [65]
//! Ignore ::= Char* - ( Char* ('<![' | ']]>' ) Char* )
//! \endcode
DOMString*
XMLParser::getIgnore()
{
  DOMChar* strs[] = 
  {
    XMLToken::str_cond_start,
    XMLToken::str_cond_end,
    0,
  };
  DOMString* s = getStringDSs(strs, 2);
  return s;
}
