﻿// $Id$

#include <assert.h>
#include <ccc/xml/XMLParserSrc.h>

using namespace CCC;

// ------------------------------------------------------------------------
// class XMLParserSrc

XMLParserSrc::XMLParserSrc()
{
  setDeleteNodeP(true);
}

XMLParserSrc::~XMLParserSrc()
{
}

void
XMLParserSrc::addUnit(XMLParserSrcUnit* unit)
{
  inject(unit);
}

Size
XMLParserSrc::restSize()
{
  Size n = 0;
  XMLParserSrcUnit* unit = tail();
  while (unit)
  {
    n += unit->restSize();
    unit = unit->getPrev();
  }
  return n;
}

const DOMString*
XMLParserSrc::getCurrentSrcName()
{
  XMLParserSrcUnit* unit = tail();
  assert(!!unit);
  return unit->getName();
}

bool
XMLParserSrc::validPositionP()
{
  XMLParserSrcUnit* unit = tail();
  if (!unit)
  {
    return false;
  }
  return unit->validPositionP();
}

DOMChar
XMLParserSrc::current()
{
  XMLParserSrcUnit* unit = tail();
  assert(!!unit);
  assert(unit->validPositionP());
  return *(unit->getPos());
}

bool
XMLParserSrc::putForward(Size n)
{
  XMLParserSrcUnit* unit = tail();
  while (unit && n > 0)
  {
    Size rest = unit->restSize();
    Size unit_fwd = (n < rest) ? n : rest;
    n -= unit_fwd;
    if (!unit->putForward(unit_fwd))
    {
      // unit reaches EOF.
      unit = eject();
      delete unit;
      unit = tail();
    }
  }
  return n == 0;
}

bool
XMLParserSrc::putForward(XMLParserSrcIterator& si)
{
  XMLParserSrcUnit* unit = tail();
  while (unit != si.getCurrentUnit())
  {
    unit = eject();
    delete unit;
    unit = tail();
  }
  if (unit)
  {
    if (!unit->setPos(si.getCurrentPos()))
    {
      unit = eject();
      delete unit;
      unit = tail();
    }
  }
  return validPositionP();
}

