﻿// $Id$

#ifndef INCLUDE_CCC_XML_XMLPARSERSRC_H
#define INCLUDE_CCC_XML_XMLPARSERSRC_H

#include <ccc/base/NDLinkList.h>
#include <ccc/xml/config.h>
#include <ccc/xml/DOMString.h>
#include <ccc/xml/XMLParserSrcUnit.h>
#include <ccc/xml/XMLParserSrcIterator.h>

CCC_NAMESPACE_START(CCC);

//class XMLParserSrcUnit;
//class XMLParserSrcIterator;

/*!
 * \ja
 * このクラスはXMLパーサのソースイメージを管理し、カスケードソースイメージを
 * 扱う機能を持っています。
 * \ja_end
 * \en
 * This class manages XML parser source images and has a functionality 
 * of cascading source images handling.
 * \en_end
 */
class XMLParserSrc
  : public NDLinkList<XMLParserSrcUnit>
{
 public:
  /*!
   * \ja
   * コンストラクタ
   * \ja_end
   */
  XMLParserSrc();
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  ~XMLParserSrc();
  /*!
   * \ja
   * このメソッドはXMLPerserSrcUnitを追加します。追加されたXMLPerserSrcUnitオブジェクトは、
   * XMLPerserSrcUnitに対する走査の終了後このオブジェクトによって削除されます。
   * \ja_end
   * \en
   * This method adds XMLPerserSrcUnit. An added XMLPerserSrcUnit object will be 
   * deleted by this object after XMLPerserSrcUnit will have scanned.
   * \en_end
   */
  void addUnit(XMLParserSrcUnit* unit);
  /*!
   * \ja
   * 複数のソースイメージの残りの総データサイズを取得します。
   * \return データサイズ
   * \ja_end
   */
  Size restSize();
  /*!
   * \ja
   * 走査位置が現在走査中のXMLParserSrcUnitのデータイメージ内かどうかを調べます。
   * \return データイメージ内なら真
   * \ja_end
   */
  bool validPositionP();
  /*!
   * \ja
   * 現在走査中のソース名を取得します。
   * \return ソース名
   * \ja_end
   */
  const DOMString* getCurrentSrcName();
  /*!
   * \ja
   * 現在の走査位置の文字を取得します。
   * \return 走査位置の文字
   * \ja_end
   */
  DOMChar current();
  /*!
   * \ja
   * 走査位置を進めます。
   * \param n 進める字数
   * \return 新しい走査位置がデータイメージ内なら真
   * \ja_end
   */
  bool putForward(Size n = 1);
  /*!
   * \ja
   * 走査位置を進めます。
   * \param si 新しい走査位置を示すイタレータ
   * \return 新しい走査位置がデータイメージ内なら真
   * \ja_end
   */
  bool putForward(XMLParserSrcIterator& si);
};

CCC_NAMESPACE_END(CCC);

#endif /* INCLUDE_CCC_XML_XMLPARSERSRC_H */
