﻿// $Id$

#include <assert.h>
#include <ccc/xml/XMLParserSrc.h>

using namespace CCC;

// ------------------------------------------------------------------------
// class XMLParserSrcIterator

XMLParserSrcIterator::XMLParserSrcIterator()
{
  src = 0;
  current_unit = 0;
  current_pos = 0;
}

void
XMLParserSrcIterator::assign(XMLParserSrcIterator& itr)
{
  src = itr.src;
  current_unit = itr.current_unit;
  current_pos = itr.current_pos;
}

XMLParserSrcIterator::XMLParserSrcIterator(XMLParserSrc* src)
{
  XMLParserSrcIterator::src = src;
  current_unit = 0;
  current_pos = 0;
  rewind();
}

bool
XMLParserSrcIterator::putForward()
{
  assert(validPositionP());
  current_pos++;
  unitEndCheck();
  return validPositionP();
}

// DOMChar
// XMLParserSrcIterator::next()
// {
//   if (putForward())
//   {
//     return current();
//   }
//   // NOTE: If data has -1 value, this EOF can't tell the EOF and data value.
//   return -1;
// }

bool
XMLParserSrcIterator::validPositionP()
{
  return current_unit && current_pos < current_unit->getEnd();
}

void
XMLParserSrcIterator::unitEndCheck()
{
  while (current_unit &&
	 current_pos >= current_unit->getEnd())
  {
    // change current_uint into the previous unit.
    current_unit = current_unit->getPrev();
    if (current_unit)
    {
      current_pos = current_unit->getPos();
    }
    else
    {
      // EOF
      current_pos = 0;
    }
  }
}

void
XMLParserSrcIterator::rewind()
{
  current_unit = src->tail();
  if (current_unit)
  {
    current_pos = current_unit->getPos();
    unitEndCheck();
  }
}

